/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.redhat.devtools.intellij.common.utils.YAMLHelper;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class YAMLHelperTest {
    private static final String RESOURCE_PATH = "utils/YAMLHelper/";
    private static final String LABEL_KEY = "key";
    private static final String LABEL_VALUE = "value";

    @Test
    public void YamlToJsonNode_YAMLIsValid_JsonNode() throws IOException {
        String yaml = this.load("utils/YAMLHelper/service.yaml");
        JsonNode result = YAMLHelper.YAMLToJsonNode((String)yaml);
        Assert.assertTrue((boolean)result.has("apiVersion"));
        Assert.assertEquals((Object)"serving.knative.dev/v1", (Object)result.get("apiVersion").asText());
        Assert.assertTrue((boolean)result.has("kind"));
        Assert.assertEquals((Object)"Service", (Object)result.get("kind").asText());
        Assert.assertTrue((boolean)result.has("metadata"));
        Assert.assertTrue((boolean)result.get("metadata").has("name"));
        Assert.assertEquals((Object)"test", (Object)result.get("metadata").get("name").asText());
        Assert.assertTrue((boolean)result.has("spec"));
    }

    @Test
    public void YamlToJsonNode_YAMLIsNotValid_Throws() {
        try {
            String yaml = this.load("utils/YAMLHelper/invalid_service.yaml");
            YAMLHelper.YAMLToJsonNode((String)yaml);
        }
        catch (IOException e) {
            Assert.assertFalse((boolean)e.getLocalizedMessage().isEmpty());
        }
    }

    @Test
    public void AddLabelToResource_YAMLIsNotValid_Throws() {
        try {
            String yaml = this.load("utils/YAMLHelper/invalid_service.yaml");
            YAMLHelper.addLabelToResource((String)yaml, (String)LABEL_KEY, (String)LABEL_VALUE);
        }
        catch (IOException e) {
            Assert.assertFalse((boolean)e.getLocalizedMessage().isEmpty());
        }
    }

    @Test
    public void AddLabelToResource_YAMLHasNotMetadataField_JsonNodeWithLabel() throws IOException {
        String yaml = this.load("utils/YAMLHelper/missingmetadata_service.yaml");
        JsonNode result = YAMLHelper.addLabelToResource((String)yaml, (String)LABEL_KEY, (String)LABEL_VALUE);
        Assert.assertFalse((boolean)YAMLHelper.YAMLToJsonNode((String)yaml).has("metadata"));
        Assert.assertTrue((boolean)result.has("metadata"));
        JsonNode metadata = result.get("metadata");
        Assert.assertFalse((boolean)metadata.has("name"));
        Assert.assertTrue((boolean)metadata.has("labels"));
        Assert.assertTrue((boolean)metadata.get("labels").has(LABEL_KEY));
        Assert.assertEquals((Object)LABEL_VALUE, (Object)metadata.get("labels").get(LABEL_KEY).asText());
    }

    @Test
    public void AddLabelToResource_YAMLHasMetadataFieldButNoLabels_JsonNodeWithLabel() throws IOException {
        String yaml = this.load("utils/YAMLHelper/service.yaml");
        JsonNode result = YAMLHelper.addLabelToResource((String)yaml, (String)LABEL_KEY, (String)LABEL_VALUE);
        Assert.assertFalse((boolean)YAMLHelper.YAMLToJsonNode((String)yaml).get("metadata").has("labels"));
        Assert.assertTrue((boolean)result.has("metadata"));
        JsonNode metadata = result.get("metadata");
        Assert.assertTrue((boolean)metadata.has("name"));
        Assert.assertEquals((Object)"test", (Object)metadata.get("name").asText());
        Assert.assertTrue((boolean)metadata.has("labels"));
        Assert.assertTrue((boolean)metadata.get("labels").has(LABEL_KEY));
        Assert.assertEquals((Object)LABEL_VALUE, (Object)metadata.get("labels").get(LABEL_KEY).asText());
    }

    @Test
    public void AddLabelToResource_YAMLHasMetadataFieldWithSomeLabels_JsonNodeWithLabels() throws IOException {
        String yaml = this.load("utils/YAMLHelper/service_with_multiple_labels.yaml");
        JsonNode result = YAMLHelper.addLabelToResource((String)yaml, (String)LABEL_KEY, (String)LABEL_VALUE);
        Assert.assertTrue((boolean)YAMLHelper.YAMLToJsonNode((String)yaml).get("metadata").has("labels"));
        Assert.assertTrue((boolean)result.has("metadata"));
        JsonNode metadata = result.get("metadata");
        Assert.assertTrue((boolean)metadata.has("name"));
        Assert.assertEquals((Object)"test", (Object)metadata.get("name").asText());
        Assert.assertTrue((boolean)metadata.has("labels"));
        Assert.assertTrue((boolean)metadata.get("labels").has(LABEL_KEY));
        Assert.assertEquals((Object)LABEL_VALUE, (Object)metadata.get("labels").get(LABEL_KEY).asText());
        Assert.assertTrue((boolean)metadata.get("labels").has("app"));
        Assert.assertEquals((Object)"v1", (Object)metadata.get("labels").get("app").asText());
        Assert.assertTrue((boolean)metadata.get("labels").has("sample"));
        Assert.assertEquals((Object)"foo", (Object)metadata.get("labels").get("sample").asText());
    }

    @Test
    public void AddLabelToResource_YAMLAlreadyHasLabel_OriginalJsonNode() throws IOException {
        String yaml = this.load("utils/YAMLHelper/service_with_label.yaml");
        JsonNode result = YAMLHelper.addLabelToResource((String)yaml, (String)LABEL_KEY, (String)LABEL_VALUE);
        Assert.assertEquals((Object)result, (Object)YAMLHelper.YAMLToJsonNode((String)yaml));
    }

    @Test
    public void RemoveLabelFromResource_YAMLIsNotValid_Throws() {
        try {
            String yaml = this.load("utils/YAMLHelper/invalid_service.yaml");
            YAMLHelper.removeLabelFromResource((String)yaml, (String)LABEL_KEY);
        }
        catch (IOException e) {
            Assert.assertFalse((boolean)e.getLocalizedMessage().isEmpty());
        }
    }

    @Test
    public void RemoveLabelFromResource_YAMLHasNoMetadataField_JsonNodeWithEmptyMetadata() throws IOException {
        String yaml = this.load("utils/YAMLHelper/missingmetadata_service.yaml");
        JsonNode result = YAMLHelper.removeLabelFromResource((String)yaml, (String)LABEL_KEY);
        Assert.assertFalse((boolean)YAMLHelper.YAMLToJsonNode((String)yaml).has("metadata"));
        Assert.assertTrue((boolean)result.has("metadata"));
        Assert.assertEquals((long)0L, (long)result.get("metadata").size());
    }

    @Test
    public void RemoveLabelFromResource_YAMLHasMetadataFieldButNoLabel_OriginalJsonNode() throws IOException {
        String yaml = this.load("utils/YAMLHelper/service.yaml");
        JsonNode result = YAMLHelper.removeLabelFromResource((String)yaml, (String)LABEL_KEY);
        Assert.assertEquals((Object)result, (Object)YAMLHelper.YAMLToJsonNode((String)yaml));
    }

    @Test
    public void RemoveLabelFromResource_YAMLHasMetadataFieldWithLabel_JsonNodeWithoutLabel() throws IOException {
        String yaml = this.load("utils/YAMLHelper/service_with_label.yaml");
        JsonNode result = YAMLHelper.removeLabelFromResource((String)yaml, (String)LABEL_KEY);
        Assert.assertTrue((boolean)result.has("metadata"));
        JsonNode metadata = result.get("metadata");
        Assert.assertTrue((boolean)metadata.has("name"));
        Assert.assertEquals((Object)"test", (Object)metadata.get("name").asText());
        Assert.assertFalse((boolean)metadata.has("labels"));
        Assert.assertTrue((boolean)YAMLHelper.YAMLToJsonNode((String)yaml).get("metadata").get("labels").has(LABEL_KEY));
    }

    @Test
    public void GetStringValueFromYAML_YAMLHasNoField_Null() throws IOException {
        String yaml = this.load("utils/YAMLHelper/service.yaml");
        String result = YAMLHelper.getStringValueFromYAML((String)yaml, (String[])new String[]{"fake"});
        Assert.assertNull((Object)result);
    }

    @Test
    public void GetStringValueFromYAML_YAMLHasField_Value() throws IOException {
        String yaml = this.load("utils/YAMLHelper/service.yaml");
        String result = YAMLHelper.getStringValueFromYAML((String)yaml, (String[])new String[]{"metadata", "name"});
        Assert.assertEquals((Object)"test", (Object)result);
    }

    @Test
    public void GetStringValueFromYAML_YAMLHasArrayField_ValuePerIndex() throws IOException {
        String yaml = this.load("utils/YAMLHelper/service.yaml");
        String result = YAMLHelper.getStringValueFromYAML((String)yaml, (String[])new String[]{"spec", "template", "spec", "containers[0]", "image"});
        Assert.assertEquals((Object)"image", (Object)result);
    }

    @Test
    public void GetStringValueFromYAML_YAMLHasArrayFieldAndIndexIsOutOfRange_Null() throws IOException {
        String yaml = this.load("utils/YAMLHelper/service.yaml");
        String result = YAMLHelper.getStringValueFromYAML((String)yaml, (String[])new String[]{"spec", "template", "spec", "containers[1]", "image"});
        Assert.assertNull((Object)result);
    }

    @Test
    public void GetValueFromYAML_YAMLHasNoField_Null() throws IOException {
        String yaml = this.load("utils/YAMLHelper/service.yaml");
        JsonNode result = YAMLHelper.getValueFromYAML((String)yaml, (String[])new String[]{"fake"});
        Assert.assertNull((Object)result);
    }

    @Test
    public void GetValueFromYAML_YAMLHasField_Value() throws IOException {
        String yaml = this.load("utils/YAMLHelper/service.yaml");
        JsonNode result = YAMLHelper.getValueFromYAML((String)yaml, (String[])new String[]{"metadata", "name"});
        Assert.assertEquals((Object)"test", (Object)result.asText());
    }

    @Test
    public void GetValueFromYAML_YAMLHasArrayField_ValuePerIndex() throws IOException {
        String yaml = this.load("utils/YAMLHelper/service.yaml");
        JsonNode result = YAMLHelper.getValueFromYAML((String)yaml, (String[])new String[]{"spec", "template", "spec", "containers[0]", "image"});
        Assert.assertEquals((Object)"image", (Object)result.asText());
    }

    @Test
    public void GetValueFromYAML_YAMLHasArrayFieldAndIndexIsOutOfRange_Null() throws IOException {
        String yaml = this.load("utils/YAMLHelper/service.yaml");
        JsonNode result = YAMLHelper.getValueFromYAML((String)yaml, (String[])new String[]{"spec", "template", "spec", "containers[1]", "image"});
        Assert.assertNull((Object)result);
    }

    private String load(String name) throws IOException {
        return IOUtils.toString((URL)YAMLHelperTest.class.getResource("/" + name), (Charset)StandardCharsets.UTF_8);
    }
}

