/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.ssl;

import com.redhat.devtools.intellij.common.ssl.CompositeX509ExtendedTrustManager;
import com.redhat.devtools.intellij.common.ssl.IDEATrustManager;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import junit.framework.TestCase;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.mockito.Mockito;

public class IDEATrustManagerTest {
    @Test
    public void single_system_manager_field_should_replace_existing_trust_manager_with_new_composite_trust_manager() {
        TrustManagerWithMySystemManagerField trustManager = new TrustManagerWithMySystemManagerField((X509TrustManager)Mockito.mock(X509ExtendedTrustManager.class));
        IDEATrustManager operator = new IDEATrustManager((X509TrustManager)trustManager);
        Assertions.assertThat((Object)trustManager.mySystemManager).isNotInstanceOf(CompositeX509ExtendedTrustManager.class);
        operator.configure(Collections.emptyList());
        Assertions.assertThat((Object)trustManager.mySystemManager).isInstanceOf(CompositeX509ExtendedTrustManager.class);
    }

    @Test
    public void single_system_manager_field_should_replace_existing_trust_manager_with_new_composite_trust_manager_that_contains_given_trust_managers() {
        TrustManagerWithMySystemManagerField trustManager = new TrustManagerWithMySystemManagerField((X509TrustManager)Mockito.mock(X509ExtendedTrustManager.class));
        IDEATrustManager operator = new IDEATrustManager((X509TrustManager)trustManager);
        List<X509ExtendedTrustManager> newTrustManagers = Arrays.asList((X509ExtendedTrustManager)Mockito.mock(X509ExtendedTrustManager.class), (X509ExtendedTrustManager)Mockito.mock(X509ExtendedTrustManager.class));
        operator.configure(newTrustManagers);
        Assertions.assertThat((Object)trustManager.mySystemManager).isInstanceOf(CompositeX509ExtendedTrustManager.class);
        List afterConfigure = ((CompositeX509ExtendedTrustManager)trustManager.mySystemManager).getInnerTrustManagers();
        Assertions.assertThat((List)afterConfigure).containsAll(newTrustManagers);
    }

    @Test
    public void single_system_manager_field_should_replace_existing_trust_manager_with_new_composite_trust_manager_that_has_replaced_trust_manager_as_1st_entry() {
        X509ExtendedTrustManager beforeReplace = (X509ExtendedTrustManager)Mockito.mock(X509ExtendedTrustManager.class);
        TrustManagerWithMySystemManagerField trustManager = new TrustManagerWithMySystemManagerField(beforeReplace);
        IDEATrustManager operator = new IDEATrustManager((X509TrustManager)trustManager);
        operator.configure(Arrays.asList((X509ExtendedTrustManager)Mockito.mock(X509ExtendedTrustManager.class), (X509ExtendedTrustManager)Mockito.mock(X509ExtendedTrustManager.class)));
        Assertions.assertThat((Object)trustManager.mySystemManager).isInstanceOf(CompositeX509ExtendedTrustManager.class);
        List afterConfigure = ((CompositeX509ExtendedTrustManager)trustManager.mySystemManager).getInnerTrustManagers();
        Assertions.assertThat((Object)((X509ExtendedTrustManager)afterConfigure.get(0))).isEqualTo((Object)beforeReplace);
    }

    @Test
    public void single_system_manager_field_should_replace_composite_trust_manager_with_new_instance_that_has_1st_entry_of_replaced_composite_manager() {
        X509ExtendedTrustManager toInclude = (X509ExtendedTrustManager)Mockito.mock(X509ExtendedTrustManager.class);
        X509ExtendedTrustManager toExclude = (X509ExtendedTrustManager)Mockito.mock(X509ExtendedTrustManager.class);
        CompositeX509ExtendedTrustManager compositeTrustManager = new CompositeX509ExtendedTrustManager(Arrays.asList(toInclude, toExclude));
        TrustManagerWithMySystemManagerField trustManager = new TrustManagerWithMySystemManagerField((X509TrustManager)compositeTrustManager);
        IDEATrustManager manager = new IDEATrustManager((X509TrustManager)trustManager);
        manager.configure(Arrays.asList((X509ExtendedTrustManager)Mockito.mock(X509ExtendedTrustManager.class), (X509ExtendedTrustManager)Mockito.mock(X509ExtendedTrustManager.class)));
        ((ObjectAssert)Assertions.assertThat((Object)trustManager.mySystemManager).isNotSameAs((Object)compositeTrustManager)).isInstanceOf(CompositeX509ExtendedTrustManager.class);
        List afterConfigure = ((CompositeX509ExtendedTrustManager)trustManager.mySystemManager).getInnerTrustManagers();
        Assertions.assertThat((Object)((X509ExtendedTrustManager)afterConfigure.get(0))).isEqualTo((Object)toInclude);
    }

    @Test
    public void multi_system_managers_field_should_still_contain_existing_trust_managers() {
        X509ExtendedTrustManager existing = (X509ExtendedTrustManager)Mockito.mock(X509ExtendedTrustManager.class);
        List<X509TrustManager> managers = Collections.singletonList(existing);
        TrustManagerWithMySystemManagersField trustManager = new TrustManagerWithMySystemManagersField(managers);
        IDEATrustManager operator = new IDEATrustManager((X509TrustManager)trustManager);
        operator.configure(Collections.emptyList());
        Assertions.assertThat(trustManager.mySystemManagers).contains((Object[])new X509TrustManager[]{existing});
    }

    @Test
    public void multi_system_managers_field_should_add_composite_manager_that_contains_new_trust_managers() {
        ArrayList<X509TrustManager> managers = new ArrayList<X509TrustManager>();
        managers.add((X509TrustManager)Mockito.mock(X509ExtendedTrustManager.class));
        TrustManagerWithMySystemManagersField trustManager = new TrustManagerWithMySystemManagersField(managers);
        IDEATrustManager operator = new IDEATrustManager((X509TrustManager)trustManager);
        List<X509ExtendedTrustManager> newTrustManagers = Arrays.asList((X509ExtendedTrustManager)Mockito.mock(X509ExtendedTrustManager.class), (X509ExtendedTrustManager)Mockito.mock(X509ExtendedTrustManager.class));
        operator.configure(newTrustManagers);
        Optional<CompositeX509ExtendedTrustManager> composite = trustManager.mySystemManagers.stream().filter(CompositeX509ExtendedTrustManager.class::isInstance).map(CompositeX509ExtendedTrustManager.class::cast).findFirst();
        TestCase.assertTrue((boolean)composite.isPresent());
        Assertions.assertThat((List)composite.get().getInnerTrustManagers()).containsAll(newTrustManagers);
    }

    @Test
    public void multi_system_managers_field_should_replace_existing_composite_manager_that_contains_new_trust_managers() {
        X509ExtendedTrustManager existingTrustManager = (X509ExtendedTrustManager)Mockito.mock(X509ExtendedTrustManager.class);
        CompositeX509ExtendedTrustManager existingCompositeManager = new CompositeX509ExtendedTrustManager(Collections.singletonList((X509ExtendedTrustManager)Mockito.mock(X509ExtendedTrustManager.class)));
        ArrayList<X509TrustManager> managers = new ArrayList<X509TrustManager>();
        managers.add(existingTrustManager);
        managers.add((X509TrustManager)existingCompositeManager);
        TrustManagerWithMySystemManagersField trustManager = new TrustManagerWithMySystemManagersField(managers);
        IDEATrustManager operator = new IDEATrustManager((X509TrustManager)trustManager);
        List<X509ExtendedTrustManager> newTrustManagers = Arrays.asList((X509ExtendedTrustManager)Mockito.mock(X509ExtendedTrustManager.class), (X509ExtendedTrustManager)Mockito.mock(X509ExtendedTrustManager.class));
        operator.configure(newTrustManagers);
        Assertions.assertThat(trustManager.mySystemManagers).doesNotContain((Object[])new X509TrustManager[]{existingCompositeManager});
        Optional<CompositeX509ExtendedTrustManager> composite = trustManager.mySystemManagers.stream().filter(CompositeX509ExtendedTrustManager.class::isInstance).map(CompositeX509ExtendedTrustManager.class::cast).findFirst();
        TestCase.assertTrue((boolean)composite.isPresent());
        Assertions.assertThat((List)composite.get().getInnerTrustManagers()).containsAll(newTrustManagers);
    }

    private static class TrustManagerWithMySystemManagerField
    implements X509TrustManager {
        X509TrustManager mySystemManager;

        public TrustManagerWithMySystemManagerField(X509TrustManager mySystemManager) {
            this.mySystemManager = mySystemManager;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class TrustManagerWithMySystemManagersField
    implements X509TrustManager {
        List<X509TrustManager> mySystemManagers;

        public TrustManagerWithMySystemManagersField(List<X509TrustManager> mySystemManagers) {
            this.mySystemManagers = mySystemManagers;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

