/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.tree;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ui.SimpleTextAttributes;
import com.redhat.devtools.intellij.common.tree.LabelAndIconDescriptor;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class LabelAndIconDescriptorTest {
    @Test
    public void checkLinkWithoutHref() {
        Assert.assertTrue((boolean)LabelAndIconDescriptor.HREF_PATTERN.matcher("Click <a>here</a>.").find());
    }

    @Test
    public void checkLinkWithHref() {
        Assert.assertTrue((boolean)LabelAndIconDescriptor.HREF_PATTERN.matcher("Click <a href=\"xxxx\">here</a>.").find());
    }

    @Test
    public void checkTextWithoutHyperLink() {
        LabelAndIconDescriptor descriptor = new LabelAndIconDescriptor(null, null, "mytext", null, null);
        PresentationData data = new PresentationData();
        descriptor.update(data);
        Assert.assertEquals((Object)"mytext", (Object)data.getPresentableText());
    }

    private void testTextWithOneHyperlink(String text) {
        LabelAndIconDescriptor descriptor = new LabelAndIconDescriptor(null, null, text, null, null);
        PresentationData data = new PresentationData();
        descriptor.update(data);
        Assert.assertNull((Object)data.getPresentableText());
        List fragments = data.getColoredText();
        Assert.assertNotNull((Object)fragments);
        Assert.assertEquals((long)3L, (long)fragments.size());
        Assert.assertEquals((Object)"Click ", (Object)((PresentableNodeDescriptor.ColoredFragment)fragments.get(0)).getText());
        Assert.assertEquals((Object)SimpleTextAttributes.REGULAR_ATTRIBUTES, (Object)((PresentableNodeDescriptor.ColoredFragment)fragments.get(0)).getAttributes());
        Assert.assertEquals((Object)"here", (Object)((PresentableNodeDescriptor.ColoredFragment)fragments.get(1)).getText());
        Assert.assertEquals((Object)LabelAndIconDescriptor.LINK_ATTRIBUTES, (Object)((PresentableNodeDescriptor.ColoredFragment)fragments.get(1)).getAttributes());
        Assert.assertEquals((Object)".", (Object)((PresentableNodeDescriptor.ColoredFragment)fragments.get(2)).getText());
        Assert.assertEquals((Object)SimpleTextAttributes.REGULAR_ATTRIBUTES, (Object)((PresentableNodeDescriptor.ColoredFragment)fragments.get(2)).getAttributes());
    }

    @Test
    public void checkTextWithOneHyperLinkAndNoHref() {
        this.testTextWithOneHyperlink("Click <a>here</a>.");
    }

    @Test
    public void checkTextWithOneHyperLinkAndHref() {
        this.testTextWithOneHyperlink("Click <a href=\"xxx\">here</a>.");
    }

    private void testTextWithTwoHyperlinks(String text) {
        LabelAndIconDescriptor descriptor = new LabelAndIconDescriptor(null, null, text, null, null);
        PresentationData data = new PresentationData();
        descriptor.update(data);
        Assert.assertNull((Object)data.getPresentableText());
        List fragments = data.getColoredText();
        Assert.assertNotNull((Object)fragments);
        Assert.assertEquals((long)5L, (long)fragments.size());
        Assert.assertEquals((Object)"Click ", (Object)((PresentableNodeDescriptor.ColoredFragment)fragments.get(0)).getText());
        Assert.assertEquals((Object)SimpleTextAttributes.REGULAR_ATTRIBUTES, (Object)((PresentableNodeDescriptor.ColoredFragment)fragments.get(0)).getAttributes());
        Assert.assertEquals((Object)"here", (Object)((PresentableNodeDescriptor.ColoredFragment)fragments.get(1)).getText());
        Assert.assertEquals((Object)LabelAndIconDescriptor.LINK_ATTRIBUTES, (Object)((PresentableNodeDescriptor.ColoredFragment)fragments.get(1)).getAttributes());
        Assert.assertEquals((Object)" or ", (Object)((PresentableNodeDescriptor.ColoredFragment)fragments.get(2)).getText());
        Assert.assertEquals((Object)SimpleTextAttributes.REGULAR_ATTRIBUTES, (Object)((PresentableNodeDescriptor.ColoredFragment)fragments.get(2)).getAttributes());
        Assert.assertEquals((Object)"there", (Object)((PresentableNodeDescriptor.ColoredFragment)fragments.get(3)).getText());
        Assert.assertEquals((Object)LabelAndIconDescriptor.LINK_ATTRIBUTES, (Object)((PresentableNodeDescriptor.ColoredFragment)fragments.get(3)).getAttributes());
        Assert.assertEquals((Object)".", (Object)((PresentableNodeDescriptor.ColoredFragment)fragments.get(4)).getText());
        Assert.assertEquals((Object)SimpleTextAttributes.REGULAR_ATTRIBUTES, (Object)((PresentableNodeDescriptor.ColoredFragment)fragments.get(4)).getAttributes());
    }

    @Test
    public void checkTextWithTwoHyperLinkAndNoHref() {
        this.testTextWithTwoHyperlinks("Click <a>here</a> or <a>there</a>.");
    }

    @Test
    public void checkTextWithTwoHyperLinkAndHref() {
        this.testTextWithTwoHyperlinks("Click <a href=\"xxx\">here</a> or <a>there</a>.");
    }
}

