/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.redhat.devtools.intellij.common.utils.ToolsConfig;
import com.redhat.devtools.intellij.common.utils.ToolsConfigHelper;
import java.io.IOException;
import java.net.URL;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ToolsConfigTest {
    private static ToolsConfig config;

    @BeforeClass
    public static void init() throws IOException {
        config = ToolsConfigHelper.loadToolsConfig((URL)ToolsConfig.class.getResource("/tkn-test.json"));
    }

    @Test
    public void verifyThatConfigCanLoad() {
        Assert.assertNotNull((Object)config);
    }

    @Test
    public void verifyThatConfigReturnsTools() {
        Assert.assertNotNull((Object)config);
        ToolsConfig.Tool tool = (ToolsConfig.Tool)config.getTools().get("tkn");
        Assert.assertNotNull((Object)tool);
    }

    @Test
    public void verifyThatConfigReturnsVersion() {
        Assert.assertNotNull((Object)config);
        ToolsConfig.Tool tool = (ToolsConfig.Tool)config.getTools().get("tkn");
        Assert.assertNotNull((Object)tool);
        Assert.assertEquals((Object)"0.5.0", (Object)tool.getVersion());
    }

    @Test
    public void verifyThatConfigReturnsVersionCmd() {
        Assert.assertNotNull((Object)config);
        ToolsConfig.Tool tool = (ToolsConfig.Tool)config.getTools().get("tkn");
        Assert.assertNotNull((Object)tool);
        Assert.assertEquals((Object)"version", (Object)tool.getVersionCmd());
    }

    @Test
    public void verifyThatConfigReturnsVersionExtractRegExp() {
        Assert.assertNotNull((Object)config);
        ToolsConfig.Tool tool = (ToolsConfig.Tool)config.getTools().get("tkn");
        Assert.assertNotNull((Object)tool);
        Assert.assertEquals((Object)"Client version: (\\d+[\\.\\d+]*)\\s.*", (Object)tool.getVersionExtractRegExp());
    }

    @Test
    public void verifyThatConfigReturnsVersionMatchRegExp() {
        Assert.assertNotNull((Object)config);
        ToolsConfig.Tool tool = (ToolsConfig.Tool)config.getTools().get("tkn");
        Assert.assertNotNull((Object)tool);
        Assert.assertEquals((Object)"0\\..*", (Object)tool.getVersionMatchRegExpr());
    }

    @Test
    public void verifyThatConfigReturnsBaseDir() {
        Assert.assertNotNull((Object)config);
        ToolsConfig.Tool tool = (ToolsConfig.Tool)config.getTools().get("tkn");
        Assert.assertNotNull((Object)tool);
        Assert.assertEquals((Object)".", (Object)tool.getBaseDir());
    }

    @Test
    public void verifyThatConfigReturnsPlatforms() {
        Assert.assertNotNull((Object)config);
        ToolsConfig.Tool tool = (ToolsConfig.Tool)config.getTools().get("tkn");
        Assert.assertNotNull((Object)tool);
        Assert.assertNotNull((Object)tool.getPlatforms());
        Assert.assertFalse((boolean)tool.getPlatforms().isEmpty());
        Assert.assertNotNull(tool.getPlatforms().get("win"));
        Assert.assertNotNull(tool.getPlatforms().get("lnx"));
        Assert.assertNotNull(tool.getPlatforms().get("osx"));
    }

    @Test
    public void verifyThatConfigReturnsCorrectChecksums() {
        Assert.assertNotNull((Object)config);
        ToolsConfig.Tool tool = (ToolsConfig.Tool)config.getTools().get("tkn");
        Assert.assertNotNull((Object)tool);
        Assert.assertNotNull((Object)tool.getPlatforms());
        Assert.assertFalse((boolean)tool.getPlatforms().isEmpty());
        Assert.assertNotNull(tool.getPlatforms().get("win"));
        Assert.assertEquals((Object)"50dfa941ccdbe63c112cb28af521f74f3d972cf06ba0092844a20197ddf31de5", (Object)((ToolsConfig.Platform)tool.getPlatforms().get("win")).getSha256());
    }
}

