/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.editor;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentSynchronizationVetoer;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.redhat.devtools.intellij.common.CommonConstants;
import org.jetbrains.annotations.NotNull;

public abstract class SaveInEditorListener
extends FileDocumentSynchronizationVetoer {
    public boolean maySaveDocument(@NotNull Document document, boolean isSaveExplicit) {
        if (document == null) {
            SaveInEditorListener.$$$reportNull$$$0(0);
        }
        VirtualFile vf = FileDocumentManager.getInstance().getFile(document);
        Project project = (Project)vf.getUserData(CommonConstants.PROJECT);
        Long lastModificationStamp = (Long)vf.getUserData(CommonConstants.LAST_MODIFICATION_STAMP);
        Long currentModificationStamp = document.getModificationStamp();
        if (project == null || !this.isFileToPush(project, vf) || currentModificationStamp.equals(lastModificationStamp)) {
            return true;
        }
        vf.putUserData(CommonConstants.LAST_MODIFICATION_STAMP, (Object)currentModificationStamp);
        if (this.save(document, project)) {
            this.notify(document);
            this.refresh(project, vf.getUserData(CommonConstants.TARGET_NODE));
        }
        return false;
    }

    protected abstract void notify(Document var1);

    protected abstract void refresh(Project var1, Object var2);

    protected abstract boolean save(Document var1, Project var2);

    protected boolean isFileToPush(Project project, VirtualFile vf) {
        FileEditor selectedEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor();
        return selectedEditor != null && selectedEditor.getFile().equals(vf);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/redhat/devtools/intellij/common/editor/SaveInEditorListener", "maySaveDocument"));
    }
}

