/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.gettingstarted;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import com.redhat.devtools.intellij.common.gettingstarted.GettingStartedCourse;
import com.redhat.devtools.intellij.common.gettingstarted.GettingStartedGroupLessons;
import com.redhat.devtools.intellij.common.gettingstarted.GettingStartedLesson;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.net.URL;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GettingStartedContent
extends ContentImpl {
    protected ToolWindow toolWindow;
    protected GettingStartedCourse course;
    protected JPanel mainPanel;

    public GettingStartedContent(ToolWindow toolWindow, String displayName, GettingStartedCourse course) {
        super(null, displayName, true);
        this.toolWindow = toolWindow;
        this.course = course;
        this.mainPanel = new JPanel(new BorderLayout());
        this.fillWithLessonsList(-1);
        this.setComponent((JComponent)new JBScrollPane((Component)this.mainPanel));
    }

    private void fillWithLessonsList(int rowToExpandWhenExitingLesson) {
        this.emptyMainPanel();
        JPanel titlePanel = this.createCourseTitlePanel();
        this.mainPanel.add((Component)titlePanel, "North");
        JTree tree = this.createLessonsTree(rowToExpandWhenExitingLesson);
        this.mainPanel.add((Component)tree, "Center");
        URL feedbackLink = this.course.getUserRedirectForFeedback();
        if (feedbackLink != null) {
            JPanel feedbackPanel = this.createAskFeedbackPanel(feedbackLink);
            this.mainPanel.add((Component)feedbackPanel, "South");
        }
        this.refresh();
    }

    private JPanel createCourseTitlePanel() {
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 1));
        titlePanel.setBorder((Border)JBUI.Borders.emptyBottom((int)20));
        JLabel courseTitleLabel = this.createLabel(this.course.getTitle(), true, 1, 16.0f);
        titlePanel.add(courseTitleLabel);
        String courseShortDescription = this.course.getShortDescription();
        if (!courseShortDescription.isEmpty()) {
            JLabel courseDescriptionLabel = this.createLabel(courseShortDescription, false, -1, -1.0f);
            titlePanel.add(courseDescriptionLabel);
        }
        return titlePanel;
    }

    private JTree createLessonsTree(int rowToExpandWhenExitingLesson) {
        if (this.course.getGroupLessons().size() == 1) {
            rowToExpandWhenExitingLesson = 0;
        }
        DefaultTreeModel model = this.createTreeModel();
        Tree tree = this.buildTree(model);
        if (rowToExpandWhenExitingLesson != -1) {
            tree.expandRow(rowToExpandWhenExitingLesson);
        }
        tree.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        return tree;
    }

    private JPanel createAskFeedbackPanel(URL feedbackLink) {
        JPanel feedbackPanel = new JPanel();
        feedbackPanel.setLayout(new BoxLayout(feedbackPanel, 1));
        JPanel linkPanel = new JPanel(new FlowLayout(0));
        JBEmptyBorder innerBorder = JBUI.Borders.emptyTop((int)10);
        MatteBorder lineSeparatorBelow = new MatteBorder(1, 0, 0, 0, JBUI.CurrentTheme.Tooltip.borderColor());
        CompoundBorder compoundBorderMargin = BorderFactory.createCompoundBorder(lineSeparatorBelow, (Border)innerBorder);
        linkPanel.setBorder(compoundBorderMargin);
        linkPanel.add(this.createLink("Leave feedback", () -> BrowserUtil.browse((URL)feedbackLink)));
        feedbackPanel.add(linkPanel);
        JPanel feedbackMessagePanel = new JPanel(new FlowLayout(0));
        JLabel feedbackMessageLabel = this.createLabel("Help us making this plugin better for everyone", false, -1, -1.0f);
        feedbackMessagePanel.add(feedbackMessageLabel);
        feedbackPanel.add(feedbackMessagePanel);
        return feedbackPanel;
    }

    private void fillWithLessonContent(GettingStartedGroupLessons group, GettingStartedLesson lesson, int rowToExpandWhenExitingLesson) {
        this.emptyMainPanel();
        this.mainPanel.add((Component)this.createTopNavigationPanel(group, lesson, rowToExpandWhenExitingLesson), "North");
        this.mainPanel.add((Component)this.createLessonContentPanel(lesson), "Center");
        this.refresh();
    }

    private JPanel createTopNavigationPanel(GettingStartedGroupLessons group, GettingStartedLesson lesson, int rowToExpandWhenExitingLesson) {
        JLabel backToMenuLink = this.createLink("<< " + group.getTitle(), () -> this.fillWithLessonsList(rowToExpandWhenExitingLesson));
        JPanel lessonNavigationPanel = this.createLessonNavigationPanel(group, lesson, rowToExpandWhenExitingLesson);
        JPanel navigationPanel = new JPanel(new BorderLayout());
        JBEmptyBorder innerBorder = JBUI.Borders.emptyBottom((int)5);
        MatteBorder lineSeparatorBelow = new MatteBorder(0, 0, 1, 0, JBUI.CurrentTheme.Tooltip.borderColor());
        CompoundBorder compoundBorderMargin = BorderFactory.createCompoundBorder(lineSeparatorBelow, (Border)innerBorder);
        navigationPanel.setBorder(compoundBorderMargin);
        navigationPanel.setPreferredSize(new Dimension(Integer.MAX_VALUE, 35));
        navigationPanel.add((Component)backToMenuLink, "Center");
        navigationPanel.add((Component)lessonNavigationPanel, "East");
        return navigationPanel;
    }

    private JPanel createLessonNavigationPanel(GettingStartedGroupLessons group, GettingStartedLesson lesson, int rowToExpandWhenExitingLesson) {
        GettingStartedLesson previousLesson = null;
        GettingStartedLesson nextLesson = null;
        int numberOfLessons = group.getLessons().size();
        for (int i = 0; i < numberOfLessons; ++i) {
            GettingStartedLesson currentLesson = group.getLessons().get(i);
            if (!currentLesson.equals(lesson)) continue;
            if (i != 0) {
                previousLesson = group.getLessons().get(i - 1);
            }
            if (i == numberOfLessons - 1) continue;
            nextLesson = group.getLessons().get(i + 1);
        }
        JPanel lessonNavigationPanel = new JPanel(new FlowLayout(2));
        if (previousLesson != null) {
            lessonNavigationPanel.add(this.createPreviousLessonLink(group, previousLesson, rowToExpandWhenExitingLesson));
        }
        if (nextLesson != null) {
            lessonNavigationPanel.add(this.createNextLessonLink(group, nextLesson, rowToExpandWhenExitingLesson));
        }
        return lessonNavigationPanel;
    }

    private JLabel createPreviousLessonLink(GettingStartedGroupLessons group, GettingStartedLesson lesson, int rowToExpandWhenExitingLesson) {
        return this.createOtherLessonLink(group, lesson, rowToExpandWhenExitingLesson, false);
    }

    private JLabel createNextLessonLink(GettingStartedGroupLessons group, GettingStartedLesson lesson, int rowToExpandWhenExitingLesson) {
        return this.createOtherLessonLink(group, lesson, rowToExpandWhenExitingLesson, true);
    }

    private JLabel createOtherLessonLink(GettingStartedGroupLessons group, GettingStartedLesson lesson, int rowToExpandWhenExitingLesson, boolean isNext) {
        return this.createLink(isNext ? "Next: " + lesson.getTitle() + " >" : "< Back: " + lesson.getTitle(), () -> this.fillWithLessonContent(group, lesson, rowToExpandWhenExitingLesson));
    }

    private JLabel createLink(String text, final Runnable runnable) {
        JLabel link = new JLabel(text);
        link.setForeground(JBUI.CurrentTheme.Link.Foreground.ENABLED);
        link.setCursor(Cursor.getPredefinedCursor(12));
        link.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e.getSource() instanceof JLabel) {
                    GettingStartedContent.this.adaptLabelAsLink((JLabel)e.getSource(), TextAttribute.UNDERLINE_ON);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                GettingStartedContent.this.adaptLabelAsLink((JLabel)e.getSource(), -1);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                runnable.run();
            }
        });
        return link;
    }

    private void adaptLabelAsLink(JLabel label, int underlineAttribute) {
        Font font = label.getFont();
        Map<TextAttribute, ?> attributes = font.getAttributes();
        attributes.put(TextAttribute.UNDERLINE, underlineAttribute);
        label.setFont(font.deriveFont(attributes));
    }

    private JComponent createLessonContentPanel(GettingStartedLesson lesson) {
        JPanel lessonContentPanel = new JPanel(new BorderLayout());
        lessonContentPanel.add((Component)this.createTitleDescriptionAndButtonsPanel(lesson), "North");
        lessonContentPanel.add((Component)this.createAnimatedImagePanel(lesson.getAnimatedImage()), "Center");
        return lessonContentPanel;
    }

    private JPanel createTitleDescriptionAndButtonsPanel(GettingStartedLesson lesson) {
        JPanel titleDescriptionAndButtonsPanel = new JPanel();
        titleDescriptionAndButtonsPanel.setLayout(new BoxLayout(titleDescriptionAndButtonsPanel, 1));
        JPanel lessonTitlePanel = this.createLessonTitlePanel(lesson.getTitle(), lesson.getDescription().contains("<html>"));
        titleDescriptionAndButtonsPanel.add(lessonTitlePanel);
        JEditorPane editorPanel = this.createLessonDescriptionPanel(lesson.getDescription());
        titleDescriptionAndButtonsPanel.add(editorPanel);
        titleDescriptionAndButtonsPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        for (Action action : lesson.getActions()) {
            JButton button = new JButton((String)action.getValue("Name"));
            button.setAction(action);
            button.setAlignmentX(0.5f);
            titleDescriptionAndButtonsPanel.add(button);
            titleDescriptionAndButtonsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        return titleDescriptionAndButtonsPanel;
    }

    private JPanel createLessonTitlePanel(String title, boolean isDescriptionInHtml) {
        JPanel lessonTitlePanel = new JPanel(new FlowLayout(0, 0, 0));
        JLabel courseTitleLabel = this.createLabel(title, true, 1, 20.0f);
        lessonTitlePanel.setBorder((Border)JBUI.Borders.emptyTop((int)15));
        if (!isDescriptionInHtml) {
            lessonTitlePanel.setBorder((Border)JBUI.Borders.empty((int)15, (int)0, (int)10, (int)0));
        }
        lessonTitlePanel.add(courseTitleLabel);
        return lessonTitlePanel;
    }

    private JEditorPane createLessonDescriptionPanel(String description) {
        JEditorPane editorPanel = new JEditorPane("text/html", description);
        editorPanel.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        editorPanel.setFont(new JLabel().getFont());
        editorPanel.setForeground(new JLabel().getForeground());
        editorPanel.setEditable(false);
        editorPanel.setOpaque(false);
        editorPanel.setBorder(null);
        return editorPanel;
    }

    private JPanel createAnimatedImagePanel(URL animatedImageURL) {
        final ImageIcon imgIcon = new ImageIcon(animatedImageURL);
        return new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                int imageWidth = imgIcon.getIconWidth();
                double widthScale = (double)this.getWidth() / (double)imageWidth;
                int imageHeight = (int)((double)imgIcon.getIconHeight() * widthScale);
                return new Dimension(imageWidth, imageHeight);
            }

            @Override
            protected void paintComponent(Graphics g) {
                int imageWidth = imgIcon.getIconWidth();
                int imageHeight = imgIcon.getIconHeight();
                if (imageWidth == 0 || imageHeight == 0) {
                    return;
                }
                double widthScale = (double)this.getWidth() / (double)imageWidth;
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.drawImage(imgIcon.getImage(), AffineTransform.getScaleInstance(widthScale, widthScale), this);
                g2d.dispose();
            }
        };
    }

    private void emptyMainPanel() {
        this.mainPanel.removeAll();
        this.mainPanel.setBorder(JBUI.Borders.empty((int)20));
    }

    private void refresh() {
        this.mainPanel.repaint();
        this.mainPanel.revalidate();
    }

    private Tree buildTree(TreeModel treeModel) {
        final Tree tree = new Tree(treeModel);
        tree.setCellRenderer(this.getTreeCellRenderer());
        final int[] lastSelected = new int[]{-1};
        tree.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                JTree tree = (JTree)e.getSource();
                lastSelected[0] = -1;
                tree.clearSelection();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                JTree tree = (JTree)e.getSource();
                int selRow = tree.getRowForLocation(e.getX(), e.getY());
                if (selRow == -1) {
                    tree.clearSelection();
                    lastSelected[0] = -1;
                } else if (selRow != lastSelected[0]) {
                    tree.setSelectionRow(selRow);
                    lastSelected[0] = selRow;
                }
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object parentUserObject;
                TreeNode parentLastPath;
                Object userObject;
                TreePath path;
                Object lastPath;
                Point p = e.getPoint();
                int selRow = tree.getRowForLocation(p.x, p.y);
                TreeCellRenderer r = tree.getCellRenderer();
                if (selRow != -1 && r != null && (lastPath = (path = tree.getPathForRow(selRow)).getLastPathComponent()) instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)lastPath).getUserObject()) instanceof GettingStartedLesson && (parentLastPath = ((DefaultMutableTreeNode)lastPath).getParent()) instanceof DefaultMutableTreeNode && (parentUserObject = ((DefaultMutableTreeNode)parentLastPath).getUserObject()) instanceof GettingStartedGroupLessons) {
                    int rowToExpandWhenExitingLesson = tree.getRowForPath(path.getParentPath());
                    GettingStartedContent.this.fillWithLessonContent((GettingStartedGroupLessons)parentUserObject, (GettingStartedLesson)userObject, rowToExpandWhenExitingLesson);
                }
            }
        });
        tree.setVisible(true);
        tree.setRootVisible(false);
        return tree;
    }

    private DefaultTreeModel createTreeModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (GettingStartedGroupLessons groupLessons : this.course.getGroupLessons()) {
            DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode(groupLessons);
            for (GettingStartedLesson lesson : groupLessons.getLessons()) {
                DefaultMutableTreeNode lessonNode = new DefaultMutableTreeNode(lesson);
                groupNode.add(lessonNode);
            }
            root.add(groupNode);
        }
        return new DefaultTreeModel(root);
    }

    private TreeCellRenderer getTreeCellRenderer() {
        return (tree1, value, selected, expanded, leaf, row, hasFocus) -> {
            Object node = TreeUtil.getUserObject((Object)value);
            if (node instanceof GettingStartedGroupLessons) {
                tree1.setCursor(Cursor.getDefaultCursor());
                return this.createLessonsGroupLabel((GettingStartedGroupLessons)node);
            }
            if (node instanceof GettingStartedLesson) {
                tree1.setCursor(Cursor.getPredefinedCursor(12));
                return this.createLessonLabel((GettingStartedLesson)node, hasFocus);
            }
            return null;
        };
    }

    private JComponent createLessonsGroupLabel(GettingStartedGroupLessons group) {
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
        JLabel courseTitleLabel = this.createLabel(group.getTitle(), true, 1, -1.0f);
        titlePanel.add((Component)courseTitleLabel, "Center");
        JLabel lessonDescriptionLabel = this.createLabel(group.getShortDescription(), false, -1, -1.0f);
        titlePanel.add((Component)lessonDescriptionLabel, "South");
        return titlePanel;
    }

    private JComponent createLessonLabel(GettingStartedLesson lesson, boolean hasFocus) {
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 1));
        JLabel lessonTitleLabel = new JLabel(lesson.getTitle());
        lessonTitleLabel.setForeground(JBUI.CurrentTheme.Link.Foreground.ENABLED);
        titlePanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
        titlePanel.add(lessonTitleLabel);
        if (hasFocus) {
            titlePanel.setBackground(JBUI.CurrentTheme.StatusBar.Widget.HOVER_BACKGROUND);
        }
        return titlePanel;
    }

    private JLabel createLabel(String text, boolean enabled, int style, float size) {
        JLabel label = new JLabel(text);
        label.setEnabled(enabled);
        if (style == -1) {
            style = label.getFont().getStyle();
        }
        if (size == -1.0f) {
            size = label.getFont().getSize();
        }
        label.setFont(label.getFont().deriveFont(style, size));
        return label;
    }
}

