/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.kubernetes;

import com.redhat.devtools.intellij.common.kubernetes.ClusterInfo;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.openshift.client.OpenShiftClient;

public class ClusterHelper {
    private ClusterHelper() {
    }

    public static boolean isOpenShift(KubernetesClient client) {
        try {
            return client != null && client.hasApiGroup("openshift.io", false);
        }
        catch (KubernetesClientException e) {
            return false;
        }
    }

    public static ClusterInfo getClusterInfo(KubernetesClient client) {
        OpenShiftClient openShiftClient = ClusterHelper.getOpenShiftClient(client);
        if (openShiftClient != null) {
            return new ClusterInfo(ClusterHelper.getKubernetesVersion(client), true, ClusterHelper.getOpenShiftVersion(openShiftClient));
        }
        return new ClusterInfo(ClusterHelper.getKubernetesVersion(client), false, "");
    }

    private static String getKubernetesVersion(KubernetesClient client) {
        VersionInfo version = client.getKubernetesVersion();
        return version != null ? version.getGitVersion() : "";
    }

    private static OpenShiftClient getOpenShiftClient(KubernetesClient client) {
        if (client instanceof OpenShiftClient) {
            return (OpenShiftClient)client;
        }
        if (ClusterHelper.isOpenShift(client)) {
            return (OpenShiftClient)client.adapt(OpenShiftClient.class);
        }
        return null;
    }

    private static String getOpenShiftVersion(OpenShiftClient client) {
        VersionInfo version = client.getVersion();
        if (version != null && version.getMajor() != null) {
            return ClusterHelper.getVersion(version.getMajor(), version.getMinor());
        }
        return "";
    }

    private static String getVersion(String major, String minor) {
        return major + "." + minor;
    }
}

