/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.tree;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabelAndIconDescriptor<T>
extends PresentableNodeDescriptor<T> {
    public static final Pattern HREF_PATTERN = Pattern.compile("<a(?:\\s+href\\s*=\\s*[\"']([^\"']*)[\"'])?\\s*>([^<]*)</a>");
    public static final SimpleTextAttributes LINK_ATTRIBUTES = new SimpleTextAttributes(528, (Color)JBColor.blue);
    private final T element;
    private final Supplier<String> label;
    private final Supplier<String> location;
    private final Supplier<Icon> nodeIcon;

    public LabelAndIconDescriptor(Project project, T element, String label, String location, Icon nodeIcon, @Nullable NodeDescriptor parentDescriptor) {
        super(project, parentDescriptor);
        this.element = element;
        this.label = () -> label;
        this.location = () -> location;
        this.nodeIcon = () -> nodeIcon;
    }

    public LabelAndIconDescriptor(Project project, T element, String label, Icon nodeIcon, @Nullable NodeDescriptor parentDescriptor) {
        this(project, element, label, null, nodeIcon, parentDescriptor);
    }

    public LabelAndIconDescriptor(Project project, T element, Supplier<String> label, Supplier<String> location, Supplier<Icon> nodeIcon, @Nullable NodeDescriptor parentDescriptor) {
        super(project, parentDescriptor);
        this.element = element;
        this.label = label;
        this.location = location;
        this.nodeIcon = nodeIcon;
    }

    public LabelAndIconDescriptor(Project project, T element, Supplier<String> label, Supplier<Icon> nodeIcon, @Nullable NodeDescriptor parentDescriptor) {
        this(project, element, label, null, nodeIcon, parentDescriptor);
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            LabelAndIconDescriptor.$$$reportNull$$$0(0);
        }
        this.processLabel(presentation);
        if (this.location != null && this.location.get() != null) {
            presentation.setLocationString(this.location.get());
        }
        if (this.nodeIcon != null && this.nodeIcon.get() != null) {
            presentation.setIcon(this.nodeIcon.get());
        }
    }

    private void processLabel(@NotNull PresentationData presentation) {
        String text;
        if (presentation == null) {
            LabelAndIconDescriptor.$$$reportNull$$$0(1);
        }
        if ((text = this.label.get()) == null) {
            return;
        }
        Matcher matcher = HREF_PATTERN.matcher(text);
        if (matcher.find()) {
            int prev = 0;
            do {
                if (matcher.start() != prev) {
                    presentation.addText(text.substring(prev, matcher.start()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
                presentation.addText(matcher.group(2), LINK_ATTRIBUTES);
                prev = matcher.end();
            } while (matcher.find());
            if (prev < text.length()) {
                presentation.addText(text.substring(prev), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        } else {
            presentation.setPresentableText(text);
        }
    }

    public T getElement() {
        return this.element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "presentation";
        objectArray2[1] = "com/redhat/devtools/intellij/common/tree/LabelAndIconDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processLabel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

