/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.tree;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreePathUtil;
import com.redhat.devtools.intellij.common.tree.MutableModel;
import java.util.Enumeration;
import java.util.function.Supplier;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class MutableModelSynchronizer<T>
implements MutableModel.Listener<T> {
    protected final StructureTreeModel<? extends AbstractTreeStructure> treeModel;
    private final AbstractTreeStructure structure;
    private final MutableModel<T> mutableModel;

    public MutableModelSynchronizer(StructureTreeModel<? extends AbstractTreeStructure> treeModel, AbstractTreeStructure structure, MutableModel<T> mutableModel) {
        this.treeModel = treeModel;
        this.structure = structure;
        this.mutableModel = mutableModel;
        this.mutableModel.addListener(this);
    }

    private void invalidatePath(Supplier<TreePath> pathSupplier) {
        this.treeModel.getInvoker().invokeLater(() -> {
            TreePath path = (TreePath)pathSupplier.get();
            if (path == null) {
                return;
            }
            if (path.getLastPathComponent() == this.treeModel.getRoot()) {
                this.invalidateRoot();
            } else {
                this.treeModel.invalidate(path, true);
            }
        });
    }

    private void invalidateRoot() {
        this.treeModel.invalidateAsync();
    }

    private T getParentElement(T element) {
        return (T)this.structure.getParentElement(element);
    }

    protected TreePath getTreePath(T element) {
        if (element == null) {
            return null;
        }
        TreeNode node = this.getNode(element);
        if (node != null) {
            return new TreePath(node);
        }
        return new TreePath(this.treeModel.getRoot());
    }

    @Nullable
    private TreeNode getNode(T element) {
        TreeNode node = this.isRootNode(element) ? this.treeModel.getRoot() : this.findTreeNode(element, (DefaultMutableTreeNode)this.treeModel.getRoot());
        return node;
    }

    protected boolean isRootNode(T element) {
        TreeNode root = this.treeModel.getRoot();
        if (!(root instanceof DefaultMutableTreeNode)) {
            return false;
        }
        Object userObject = ((DefaultMutableTreeNode)root).getUserObject();
        if (!(userObject instanceof NodeDescriptor)) {
            return false;
        }
        NodeDescriptor descriptor = (NodeDescriptor)userObject;
        return descriptor.getElement() == element;
    }

    private TreeNode findTreeNode(T element, DefaultMutableTreeNode start) {
        if (element == null || start == null) {
            return null;
        }
        Enumeration<TreeNode> children = start.children();
        while (children.hasMoreElements()) {
            TreeNode child = children.nextElement();
            if (!(child instanceof DefaultMutableTreeNode)) continue;
            if (this.hasElement(element, (DefaultMutableTreeNode)child)) {
                return (DefaultMutableTreeNode)child;
            }
            TreeNode node = this.findTreeNode(element, (DefaultMutableTreeNode)child);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    private boolean hasElement(T element, DefaultMutableTreeNode node) {
        NodeDescriptor descriptor = (NodeDescriptor)node.getUserObject();
        return descriptor != null && descriptor.getElement() == element;
    }

    @Override
    public void onAdded(T element) {
        this.treeModel.getInvoker().invokeLater(() -> this.invalidatePath(() -> this.getTreePath(this.getParentElement(element))));
    }

    @Override
    public void onModified(T element) {
        this.treeModel.getInvoker().invokeLater(() -> {
            TreePath path = this.getTreePath(element);
            if (path == null) {
                return;
            }
            this.updateDescriptor(path);
            this.invalidatePath(() -> path);
        });
    }

    private void updateDescriptor(TreePath path) {
        TreeNode node = TreePathUtil.toTreeNode((TreePath)path);
        if (!(node instanceof DefaultMutableTreeNode)) {
            return;
        }
        Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
        if (!(userObject instanceof PresentableNodeDescriptor)) {
            return;
        }
        ((PresentableNodeDescriptor)userObject).update();
    }

    @Override
    public void onRemoved(T element) {
        this.treeModel.getInvoker().invokeLater(() -> this.invalidatePath(() -> this.getTreePath(this.getParentElement(element))));
    }
}

