/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.ui;

import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputDialogWithCheckbox
extends Messages.InputDialog {
    private JCheckBox myCheckBox;

    public InputDialogWithCheckbox(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @NlsContexts.Checkbox String checkboxText, boolean checked, boolean checkboxEnabled, @Nullable Icon icon, @Nullable @NlsSafe String initialValue, @Nullable InputValidator validator) {
        super(message, title, icon, initialValue, validator);
        this.myCheckBox.setText(checkboxText);
        this.myCheckBox.setSelected(checked);
        this.myCheckBox.setEnabled(checkboxEnabled);
    }

    @NotNull
    protected JPanel createMessagePanel() {
        JPanel messagePanel = new JPanel(new BorderLayout());
        if (this.myMessage != null) {
            JComponent textComponent = this.createTextComponent();
            messagePanel.add((Component)textComponent, "North");
        }
        this.myField = this.createTextFieldComponent();
        messagePanel.add((Component)this.createScrollableTextComponent(), "Center");
        this.myCheckBox = new JCheckBox();
        messagePanel.add((Component)this.myCheckBox, "South");
        JPanel jPanel = messagePanel;
        if (jPanel == null) {
            InputDialogWithCheckbox.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public JCheckBox getMyCheckBox() {
        return this.myCheckBox;
    }

    public void setEnableTextPanelWithCheckbox() {
        this.updateTextFieldState(this.myCheckBox.isSelected());
        this.myCheckBox.addItemListener(e -> this.updateTextFieldState(this.myCheckBox.isSelected()));
    }

    public void setDisableTextPanelWithCheckbox() {
        this.updateTextFieldState(!this.myCheckBox.isSelected());
        this.myCheckBox.addItemListener(e -> this.updateTextFieldState(!this.myCheckBox.isSelected()));
    }

    private void updateTextFieldState(boolean enabled) {
        this.myField.setEnabled(enabled);
    }

    public Boolean isChecked() {
        return this.myCheckBox.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/redhat/devtools/intellij/common/ui/InputDialogWithCheckbox", "createMessagePanel"));
    }
}

