/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.client.Config;
import java.util.Collection;
import java.util.Objects;

public class ConfigHelper {
    public static boolean areEqual(Config thisConfig, Config thatConfig) {
        return ConfigHelper.areEqualCurrentContext(thisConfig, thatConfig) && ConfigHelper.areEqualCluster(thisConfig, thatConfig) && ConfigHelper.areEqualAuthInfo(thisConfig, thatConfig);
    }

    public static boolean areEqualCurrentContext(Config thisConfig, Config thatConfig) {
        if (thisConfig == null) {
            return thatConfig == null;
        }
        if (thatConfig == null) {
            return false;
        }
        return ConfigHelper.areEqualContext(thisConfig.getCurrentContext(), thatConfig.getCurrentContext());
    }

    public static boolean areEqualContext(NamedContext thisContext, NamedContext thatContext) {
        if (thisContext == null) {
            return thatContext == null;
        }
        if (thatContext == null) {
            return false;
        }
        return Objects.equals(thisContext.getName(), thatContext.getName()) && ConfigHelper.areEqualContext(thisContext.getContext(), thatContext.getContext());
    }

    private static boolean areEqualContext(Context thisContext, Context thatContext) {
        if (thisContext == null) {
            return thatContext == null;
        }
        if (thatContext == null) {
            return false;
        }
        return Objects.equals(thisContext.getCluster(), thatContext.getCluster()) && Objects.equals(thisContext.getUser(), thatContext.getUser()) && Objects.equals(thisContext.getNamespace(), thatContext.getNamespace());
    }

    public static boolean areEqualCluster(Config thisConfig, Config thatConfig) {
        if (thisConfig == null) {
            return thatConfig == null;
        }
        if (thatConfig == null) {
            return false;
        }
        return Objects.equals(thisConfig.getMasterUrl(), thatConfig.getMasterUrl()) && ConfigHelper.areEqualTrustCerts(thisConfig, thatConfig) && ConfigHelper.areEqualProxy(thisConfig, thatConfig) && ConfigHelper.areEqualAuthInfo(thisConfig, thatConfig);
    }

    private static boolean areEqualProxy(Config thisConfig, Config thatConfig) {
        if (thisConfig == null) {
            return thatConfig == null;
        }
        if (thatConfig == null) {
            return false;
        }
        return Objects.equals(thisConfig.getHttpProxy(), thatConfig.getHttpProxy()) && Objects.equals(thisConfig.getHttpsProxy(), thatConfig.getHttpsProxy()) && Objects.equals(thisConfig.getProxyUsername(), thatConfig.getProxyUsername()) && Objects.equals(thisConfig.getProxyPassword(), thatConfig.getProxyPassword());
    }

    private static boolean areEqualTrustCerts(Config thisConfig, Config thatConfig) {
        if (thisConfig == null) {
            return thatConfig == null;
        }
        if (thatConfig == null) {
            return false;
        }
        return thisConfig.isTrustCerts() == thatConfig.isTrustCerts() && thisConfig.isDisableHostnameVerification() == thatConfig.isDisableHostnameVerification() && Objects.equals(thisConfig.getCaCertData(), thatConfig.getCaCertData()) && Objects.equals(thisConfig.getCaCertFile(), thatConfig.getCaCertFile());
    }

    public static boolean areEqualAuthInfo(Config thisConfig, Config thatConfig) {
        if (thisConfig == null) {
            return thatConfig == null;
        }
        if (thatConfig == null) {
            return false;
        }
        return Objects.equals(thisConfig.getClientCertFile(), thatConfig.getClientCertFile()) && Objects.equals(thisConfig.getClientCertData(), thatConfig.getClientCertData()) && Objects.equals(thisConfig.getClientKeyFile(), thatConfig.getClientKeyFile()) && Objects.equals(thisConfig.getClientKeyData(), thatConfig.getClientKeyData()) && Objects.equals(thisConfig.getClientKeyAlgo(), thatConfig.getClientKeyAlgo()) && Objects.equals(thisConfig.getUsername(), thatConfig.getUsername()) && Objects.equals(thisConfig.getPassword(), thatConfig.getPassword()) && ConfigHelper.areEqualProxy(thisConfig, thatConfig) && ConfigHelper.areEqualToken(thisConfig, thatConfig);
    }

    public static boolean areEqualContexts(Config thisConfig, Config thatConfig) {
        return ConfigHelper.areEqualContexts(thisConfig.getContexts(), thatConfig.getContexts());
    }

    private static boolean areEqualContexts(Collection<NamedContext> these, Collection<NamedContext> those) {
        if (these == null) {
            return those == null;
        }
        if (those == null) {
            return false;
        }
        return these.size() == those.size() && these.stream().allMatch(namedContext -> ConfigHelper.contains(namedContext, those));
    }

    private static boolean contains(NamedContext namedContext, Collection<NamedContext> namedContexts) {
        if (namedContexts == null || namedContexts.isEmpty()) {
            return false;
        }
        return namedContexts.stream().anyMatch(named -> ConfigHelper.areEqualContext(namedContext, named));
    }

    public static boolean areEqualToken(Config thisConfig, Config thatConfig) {
        if (thisConfig == null) {
            return thatConfig == null;
        }
        if (thatConfig == null) {
            return false;
        }
        return Objects.equals(thisConfig.getAutoOAuthToken(), thatConfig.getAutoOAuthToken());
    }
}

