/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.intellij.util.io.BaseInputStreamReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class ExecReader
extends BaseInputStreamReader {
    private char[] readBuffer;
    private char[] buffer;
    private int bufferPosition;
    private int bufferSize;
    private boolean justReadCR;

    public ExecReader(@NotNull InputStream in) {
        if (in == null) {
            ExecReader.$$$reportNull$$$0(0);
        }
        super(in);
        this.readBuffer = new char[1024];
        this.buffer = new char[this.readBuffer.length * 2];
        this.bufferPosition = 0;
        this.bufferSize = 0;
        this.justReadCR = false;
    }

    public ExecReader(@NotNull InputStream in, @NotNull Charset cs) {
        if (in == null) {
            ExecReader.$$$reportNull$$$0(1);
        }
        if (cs == null) {
            ExecReader.$$$reportNull$$$0(2);
        }
        super(in, cs);
        this.readBuffer = new char[1024];
        this.buffer = new char[this.readBuffer.length * 2];
        this.bufferPosition = 0;
        this.bufferSize = 0;
        this.justReadCR = false;
    }

    private boolean refillBufferIfNeeded(boolean onlyIfReady) throws IOException {
        if (this.bufferPosition < this.bufferSize || onlyIfReady && !super.ready()) {
            return false;
        }
        this.bufferPosition = 0;
        this.bufferSize = 0;
        char[] readBuffer = this.readBuffer;
        int read = super.read(readBuffer, 0, readBuffer.length);
        if (read < 0) {
            return true;
        }
        boolean justReadCR = this.justReadCR;
        char[] buffer = this.buffer;
        int outI = 0;
        for (int i = 0; i < read; ++i) {
            char c = readBuffer[i];
            if (c == '\n' && !justReadCR) {
                buffer[outI++] = 13;
            }
            buffer[outI++] = c;
            justReadCR = c == '\r';
        }
        this.bufferSize = outI;
        this.justReadCR = justReadCR;
        return false;
    }

    public int read() throws IOException {
        if (this.refillBufferIfNeeded(false)) {
            return -1;
        }
        return this.buffer[this.bufferPosition++];
    }

    public int read(@NotNull char[] cbuf, int offset, int length) throws IOException {
        if (cbuf == null) {
            ExecReader.$$$reportNull$$$0(3);
        }
        if (this.refillBufferIfNeeded(false)) {
            return -1;
        }
        int read = 0;
        while (this.bufferPosition < this.bufferSize && read < length) {
            int available = this.bufferSize - this.bufferPosition;
            int required = length - read;
            int copied = Math.min(available, required);
            System.arraycopy(this.buffer, this.bufferPosition, cbuf, offset + read, copied);
            read += copied;
            this.bufferPosition += copied;
            if (!this.refillBufferIfNeeded(true)) continue;
            break;
        }
        return read;
    }

    public boolean ready() throws IOException {
        return this.bufferPosition < this.bufferSize || super.ready();
    }

    public int read(@NotNull CharBuffer target) throws IOException {
        if (target == null) {
            ExecReader.$$$reportNull$$$0(4);
        }
        if (this.refillBufferIfNeeded(false)) {
            return -1;
        }
        int read = 0;
        while (this.bufferPosition < this.bufferSize && target.remaining() > 0) {
            int available = this.bufferSize - this.bufferPosition;
            int required = target.remaining();
            int copied = Math.min(available, required);
            target.put(this.buffer, this.bufferPosition, copied);
            read += copied;
            this.bufferPosition += copied;
            if (!this.refillBufferIfNeeded(true)) continue;
            break;
        }
        return read;
    }

    public int read(@NotNull char[] cbuf) throws IOException {
        if (cbuf == null) {
            ExecReader.$$$reportNull$$$0(5);
        }
        return this.read(cbuf, 0, cbuf.length);
    }

    public long skip(long n) throws IOException {
        long skipped;
        long copied;
        if (this.refillBufferIfNeeded(false)) {
            return -1L;
        }
        for (skipped = 0L; this.bufferPosition < this.bufferSize && skipped < n; skipped += copied) {
            long available = this.bufferSize - this.bufferPosition;
            long required = n - skipped;
            copied = Math.min(available, required);
            this.bufferPosition = (int)((long)this.bufferPosition + copied);
            if (!this.refillBufferIfNeeded(true)) continue;
            break;
        }
        return skipped;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readAheadLimit) throws IOException {
        super.mark(readAheadLimit);
    }

    public void reset() throws IOException {
        super.reset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cs";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cbuf";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "com/redhat/devtools/intellij/common/utils/ExecReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

