/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.redhat.devtools.intellij.common.utils.IdeProxyAdapter;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;

public class NetworkUtils {
    public static OkHttpClient getClient() {
        ProxySelector proxySelector = IdeProxyAdapter.getProxySelector();
        Authenticator proxyAuthenticator = NetworkUtils.getProxyAuthenticator(IdeProxyAdapter.getPasswordAuthentication());
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.proxySelector(proxySelector).proxyAuthenticator(proxyAuthenticator);
        return builder.build();
    }

    private static Authenticator getProxyAuthenticator(PasswordAuthentication authentication) {
        Authenticator proxyAuthenticator = null;
        if (authentication != null) {
            proxyAuthenticator = (route, response) -> {
                String credential = Credentials.basic((String)authentication.getUserName(), (String)Arrays.toString(authentication.getPassword()));
                return response.request().newBuilder().header("Proxy-Authorization", credential).build();
            };
        }
        return proxyAuthenticator;
    }

    @NotNull
    public static Map<String, String> buildEnvironmentVariables(String url) throws URISyntaxException {
        HashMap<String, String> environmentVariables = new HashMap<String, String>(6);
        List<Proxy> proxies = IdeProxyAdapter.getProxies(url);
        Proxy proxy = proxies.stream().findFirst().orElse(null);
        if (proxy != null) {
            Proxy.Type type = proxy.type();
            switch (type) {
                case HTTP: 
                case SOCKS: {
                    SocketAddress address = proxy.address();
                    if (!(address instanceof InetSocketAddress)) break;
                    PasswordAuthentication authentication = IdeProxyAdapter.getPasswordAuthentication();
                    String envVarValue = NetworkUtils.buildHttpProxy(type, authentication, (InetSocketAddress)address);
                    HashSet proxyEnvironmentVariables = Sets.newHashSet((Object[])new String[]{"HTTP_PROXY", "HTTPS_PROXY", "ALL_PROXY"});
                    proxyEnvironmentVariables.forEach(envVarName -> {
                        environmentVariables.put((String)envVarName, envVarValue);
                        environmentVariables.put(envVarName.toLowerCase(), envVarValue);
                    });
                }
            }
        }
        HashMap<String, String> hashMap = environmentVariables;
        if (hashMap == null) {
            NetworkUtils.$$$reportNull$$$0(0);
        }
        return hashMap;
    }

    @NotNull
    private static String buildHttpProxy(Proxy.Type type, PasswordAuthentication authentication, InetSocketAddress address) {
        String host = address.getHostName();
        int port = address.getPort();
        return NetworkUtils.buildHttpProxy(type, authentication, host, port);
    }

    @NotNull
    private static String buildHttpProxy(Proxy.Type type, PasswordAuthentication authentication, String host, int port) {
        String userName = null;
        String password = null;
        if (authentication != null) {
            userName = authentication.getUserName();
            password = Arrays.toString(authentication.getPassword());
        }
        return NetworkUtils.buildHttpProxy(type, userName, password, host, port);
    }

    @NotNull
    private static String buildHttpProxy(Proxy.Type type, String userName, String password, String host, int port) {
        StringBuilder builder = new StringBuilder();
        switch (type) {
            case HTTP: {
                builder.append("http://");
                break;
            }
            case SOCKS: {
                builder.append("socks://");
            }
        }
        if (StringUtil.isNotEmpty((String)userName) && StringUtil.isNotEmpty((String)password)) {
            builder.append(userName).append(":").append(password).append("@");
        }
        builder.append(host).append(":").append(port);
        String string = builder.toString();
        if (string == null) {
            NetworkUtils.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/redhat/devtools/intellij/common/utils/NetworkUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildEnvironmentVariables";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHttpProxy";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

