/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.redhat.devtools.intellij.common.CommonConstants;
import com.redhat.devtools.intellij.common.utils.YAMLHelper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualFileHelper {
    private static final Logger logger = LoggerFactory.getLogger(VirtualFileHelper.class);

    public static VirtualFile createTempFile(String name, String content) throws IOException {
        File file = new File(System.getProperty("java.io.tmpdir"), name);
        if (file.exists()) {
            file.delete();
            LocalFileSystem.getInstance().refreshIoFiles(Arrays.asList(file));
        }
        FileUtils.write((File)file, (CharSequence)content, (Charset)StandardCharsets.UTF_8);
        file.deleteOnExit();
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
    }

    @Deprecated
    public static String cleanContent(String content) {
        if (content.isEmpty()) {
            return content;
        }
        try {
            ObjectNode metadata;
            ObjectNode contentNode = (ObjectNode)YAMLHelper.YAMLToJsonNode(content);
            ObjectNode objectNode = metadata = contentNode.has("metadata") ? (ObjectNode)contentNode.get("metadata") : null;
            if (metadata != null) {
                metadata.remove(CommonConstants.metadataClutter);
                contentNode.set("metadata", (JsonNode)metadata);
                content = YAMLHelper.JSONToYAML((JsonNode)contentNode);
            }
        }
        catch (IOException e) {
            logger.warn(e.getLocalizedMessage(), (Throwable)e);
        }
        return content;
    }
}

