/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.validation;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.redhat.devtools.intellij.common.validation.KubernetesTypeInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaProvider
implements JsonSchemaFileProvider {
    private Project project;
    private final KubernetesTypeInfo info;
    private final VirtualFile schemaFile;

    public SchemaProvider(KubernetesTypeInfo info, VirtualFile file) {
        this.info = info;
        this.schemaFile = file;
    }

    private SchemaProvider(Project project, KubernetesTypeInfo info, VirtualFile file) {
        this(info, file);
        this.project = project;
    }

    public boolean isAvailable(@NotNull VirtualFile file) {
        if (file == null) {
            SchemaProvider.$$$reportNull$$$0(0);
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
            PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(file);
            if (psiFile != null) {
                KubernetesTypeInfo fileInfo = KubernetesTypeInfo.extractMeta(psiFile);
                return this.info.equals(fileInfo);
            }
            return false;
        });
    }

    @NotNull
    public String getName() {
        String string = this.info.toString();
        if (string == null) {
            SchemaProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public VirtualFile getSchemaFile() {
        return this.schemaFile;
    }

    @NotNull
    public SchemaType getSchemaType() {
        SchemaType schemaType = SchemaType.schema;
        if (schemaType == null) {
            SchemaProvider.$$$reportNull$$$0(2);
        }
        return schemaType;
    }

    public SchemaProvider withProject(Project project) {
        if (this.project == project) {
            return this;
        }
        return new SchemaProvider(project, this.info, this.schemaFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/redhat/devtools/intellij/common/validation/SchemaProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/redhat/devtools/intellij/common/validation/SchemaProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

