/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.redhat.devtools.intellij.common.utils.ConfigHelper;
import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.client.Config;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class ConfigHelperTest {
    private static final NamedContext ctx1 = new NamedContext(new Context("cluster1", null, "namespace1", "papa smurf"), "papa smurfs context");
    private static final NamedContext ctx2 = new NamedContext(new Context("cluster2", null, "namespace2", "grumpy smurf"), "grumpy smurfs context");
    private static final NamedContext ctx3 = new NamedContext(new Context("cluster3", null, "namespace3", "smurfette"), "smurfettes context");
    private static final NamedContext ctx4 = new NamedContext(new Context("cluster4", null, "namespace4", "jokey smurf"), "jokey smurfs context");
    private static final NamedContext ctx5 = new NamedContext(new Context("cluster2", null, "namespace2", "azrael"), "azraels context");
    private static final List<NamedContext> allContextsButCtx4 = Arrays.asList(ctx1, ctx2, ctx3, ctx5);

    @Test
    public void areEqualCurrentContext_returns_true_given_identical_current_contexts() {
        Config config1 = ConfigHelperTest.clientConfig(ctx1);
        Config config2 = ConfigHelperTest.clientConfig(ctx1);
        boolean equal = ConfigHelper.areEqualCurrentContext((Config)config1, (Config)config2);
        Assertions.assertThat((boolean)equal).isTrue();
    }

    @Test
    public void areEqualCurrentContext_returns_false_given_one_config_has_no_current_context_and_the_other_has() {
        Config config1 = ConfigHelperTest.clientConfig((NamedContext)null);
        Config config2 = ConfigHelperTest.clientConfig(ctx1);
        boolean equal = ConfigHelper.areEqualCurrentContext((Config)config1, (Config)config2);
        Assertions.assertThat((boolean)equal).isFalse();
    }

    @Test
    public void areEqualCurrentContext_returns_false_given_current_contexts_differ_in_cluster() {
        Config config1 = ConfigHelperTest.clientConfig(ctx1);
        NamedContext differentCluster = ConfigHelperTest.clone(ctx1);
        differentCluster.getContext().setCluster("imperial fleet");
        Config config2 = ConfigHelperTest.clientConfig(differentCluster);
        boolean equal = ConfigHelper.areEqualCurrentContext((Config)config1, (Config)config2);
        Assertions.assertThat((boolean)equal).isFalse();
    }

    @Test
    public void areEqualCurrentContext_returns_false_given_current_contexts_differ_in_namespace() {
        Config config1 = ConfigHelperTest.clientConfig(ctx1);
        NamedContext differentNamespace = ConfigHelperTest.clone(ctx1);
        differentNamespace.getContext().setNamespace("stormtroopers");
        Config config2 = ConfigHelperTest.clientConfig(differentNamespace);
        boolean equal = ConfigHelper.areEqualCurrentContext((Config)config1, (Config)config2);
        Assertions.assertThat((boolean)equal).isFalse();
    }

    @Test
    public void areEqualCurrentContext_returns_false_given_current_contexts_differ_in_user() {
        Config config1 = ConfigHelperTest.clientConfig(ctx1);
        NamedContext differentUser = ConfigHelperTest.clone(ctx1);
        differentUser.getContext().setUser("lord vader");
        Config config2 = ConfigHelperTest.clientConfig(differentUser);
        boolean equal = ConfigHelper.areEqualCurrentContext((Config)config1, (Config)config2);
        Assertions.assertThat((boolean)equal).isFalse();
    }

    @Test
    public void areEqualCurrentContext_returns_false_given_current_contexts_differ_in_name() {
        Config config1 = ConfigHelperTest.clientConfig(ctx1);
        NamedContext differentName = ConfigHelperTest.clone(ctx1);
        differentName.setName("r2d2");
        Config config2 = ConfigHelperTest.clientConfig(differentName);
        boolean equal = ConfigHelper.areEqualCurrentContext((Config)config1, (Config)config2);
        Assertions.assertThat((boolean)equal).isFalse();
    }

    @Test
    public void areEqualContexts_returns_true_given_contexts_with_same_members() {
        Config config1 = ConfigHelperTest.clientConfig(allContextsButCtx4);
        List<NamedContext> sameMembers = ConfigHelperTest.clone(allContextsButCtx4);
        Config config2 = ConfigHelperTest.clientConfig(sameMembers);
        boolean equal = ConfigHelper.areEqualContexts((Config)config1, (Config)config2);
        Assertions.assertThat((boolean)equal).isTrue();
    }

    @Test
    public void areEqualContexts_returns_false_given_config_is_missing_one_context() {
        Config config1 = ConfigHelperTest.clientConfig(allContextsButCtx4);
        List<NamedContext> isMissingOneContext = ConfigHelperTest.clone(allContextsButCtx4);
        isMissingOneContext.remove(isMissingOneContext.size() - 1);
        Config config2 = ConfigHelperTest.clientConfig(isMissingOneContext);
        boolean equal = ConfigHelper.areEqualContexts((Config)config1, (Config)config2);
        Assertions.assertThat((boolean)equal).isFalse();
    }

    @Test
    public void areEqualContexts_returns_false_given_config_has_additional_context() {
        Config config1 = ConfigHelperTest.clientConfig(allContextsButCtx4);
        List<NamedContext> hasAdditionalCtx4 = ConfigHelperTest.clone(allContextsButCtx4);
        hasAdditionalCtx4.add(ctx4);
        Config config2 = ConfigHelperTest.clientConfig(hasAdditionalCtx4);
        boolean equal = ConfigHelper.areEqualContexts((Config)config1, (Config)config2);
        Assertions.assertThat((boolean)equal).isFalse();
    }

    @Test
    public void areEqualAuthInfo_returns_false_given_contexts_differ_in_username() {
        Config config1 = ConfigHelperTest.clientConfig("yoda", null);
        Config config2 = ConfigHelperTest.clientConfig("obiwan", null);
        boolean equal = ConfigHelper.areEqualAuthInfo((Config)config1, (Config)config2);
        Assertions.assertThat((boolean)equal).isFalse();
    }

    @Test
    public void areEqualAuthInfo_returns_false_given_contexts_differ_in_password() {
        Config config1 = ConfigHelperTest.clientConfig("yoda", "the force");
        Config config2 = ConfigHelperTest.clientConfig("yoda", "the light saber");
        boolean equal = ConfigHelper.areEqualAuthInfo((Config)config1, (Config)config2);
        Assertions.assertThat((boolean)equal).isFalse();
    }

    @Test
    public void areEqualToken_returns_true_given_contexts_have_same_token() {
        Config config1 = ConfigHelperTest.clientConfig("R2-D2");
        Config config2 = ConfigHelperTest.clientConfig("R2-D2");
        boolean equal = ConfigHelper.areEqualToken((Config)config1, (Config)config2);
        Assertions.assertThat((boolean)equal).isTrue();
    }

    @Test
    public void areEqualToken_returns_false_given_contexts_differ_in_token() {
        Config config1 = ConfigHelperTest.clientConfig("R2-D2");
        Config config2 = ConfigHelperTest.clientConfig("C-3PO");
        boolean equal = ConfigHelper.areEqualToken((Config)config1, (Config)config2);
        Assertions.assertThat((boolean)equal).isFalse();
    }

    @Test
    public void areEqual_returns_true_given_both_context_have_same_token_current_ctx_and_contexts() {
        Config config1 = ConfigHelperTest.clientConfig("C3-PO", ctx2, allContextsButCtx4);
        Config config2 = ConfigHelperTest.clientConfig("C3-PO", ConfigHelperTest.clone(ctx2), ConfigHelperTest.clone(allContextsButCtx4));
        boolean equal = ConfigHelper.areEqual((Config)config1, (Config)config2);
        Assertions.assertThat((boolean)equal).isTrue();
    }

    @Test
    public void areEqual_returns_false_given_one_context_has_different_token() {
        Config config1 = ConfigHelperTest.clientConfig("C3-PO", ctx2, allContextsButCtx4);
        Config config2 = ConfigHelperTest.clientConfig("R2-D2", ConfigHelperTest.clone(ctx2), ConfigHelperTest.clone(allContextsButCtx4));
        boolean equal = ConfigHelper.areEqual((Config)config1, (Config)config2);
        Assertions.assertThat((boolean)equal).isFalse();
    }

    @Test
    public void areEqual_returns_false_given_one_context_has_different_current_context() {
        Config config1 = ConfigHelperTest.clientConfig("C3-PO", ctx2, allContextsButCtx4);
        Config config2 = ConfigHelperTest.clientConfig("C3-PO", ctx3, ConfigHelperTest.clone(allContextsButCtx4));
        boolean equal = ConfigHelper.areEqual((Config)config1, (Config)config2);
        Assertions.assertThat((boolean)equal).isFalse();
    }

    @Test
    public void areEqual_returns_true_even_if_one_context_has_additional_context() {
        Config config1 = ConfigHelperTest.clientConfig("C3-PO", ctx2, allContextsButCtx4);
        List<NamedContext> hasAdditionalContext = ConfigHelperTest.clone(allContextsButCtx4);
        hasAdditionalContext.add(ctx4);
        Config config2 = ConfigHelperTest.clientConfig("C3-PO", ConfigHelperTest.clone(ctx2), hasAdditionalContext);
        boolean equal = ConfigHelper.areEqual((Config)config1, (Config)config2);
        Assertions.assertThat((boolean)equal).isTrue();
    }

    private static Config clientConfig(String token) {
        return ConfigHelperTest.clientConfig(token, null, null);
    }

    private static Config clientConfig(String username, String password) {
        Config config = ConfigHelperTest.clientConfig(null, null, null);
        ((Config)Mockito.doReturn((Object)username).when((Object)config)).getUsername();
        ((Config)Mockito.doReturn((Object)password).when((Object)config)).getPassword();
        return config;
    }

    private static Config clientConfig(NamedContext currentContext) {
        return ConfigHelperTest.clientConfig(null, currentContext, null);
    }

    private static Config clientConfig(List<NamedContext> contexts) {
        return ConfigHelperTest.clientConfig(null, null, contexts);
    }

    private static Config clientConfig(String token, NamedContext currentContext, List<NamedContext> contexts) {
        Config config = (Config)Mockito.mock(Config.class);
        ((Config)Mockito.doReturn((Object)token).when((Object)config)).getAutoOAuthToken();
        ((Config)Mockito.doReturn((Object)currentContext).when((Object)config)).getCurrentContext();
        ((Config)Mockito.doReturn(contexts).when((Object)config)).getContexts();
        return config;
    }

    private static List<NamedContext> clone(List<NamedContext> namedContexts) {
        return namedContexts.stream().map(ConfigHelperTest::clone).collect(Collectors.toList());
    }

    private static NamedContext clone(NamedContext namedContext) {
        Context context = namedContext.getContext();
        return new NamedContext(new Context(context.getCluster(), context.getExtensions(), context.getNamespace(), context.getUser()), namedContext.getName());
    }
}

