/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.redhat.devtools.intellij.common.utils.ConfigWatcher;
import com.redhat.devtools.intellij.common.utils.HighSensitivityRegistrar;
import io.fabric8.kubernetes.client.Config;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.yaml.snakeyaml.error.YAMLException;

public class ConfigWatcherTest {
    private Path config1;
    private Path config2;
    private Path config3;
    private final ConfigWatcher.Listener listener = (ConfigWatcher.Listener)Mockito.mock(ConfigWatcher.Listener.class);
    private final HighSensitivityRegistrar registrar = (HighSensitivityRegistrar)Mockito.mock(HighSensitivityRegistrar.class);
    private final WatchService service = (WatchService)Mockito.mock(WatchService.class);
    private ConfigWatcher watcher;

    @Before
    public void before() throws IOException {
        this.config1 = Paths.get(Files.createTempFile("skywalker", null, new FileAttribute[0]).toString(), new String[0]);
        this.config2 = Paths.get(Files.createTempFile("yoda", null, new FileAttribute[0]).toString(), new String[0]);
        this.config3 = Paths.get(Files.createTempFile("obiwan", null, new FileAttribute[0]).toString(), new String[0]);
        this.watcher = new TestableConfigWatcher(List.of(this.config1, this.config2, this.config3), this.listener, this.registrar, this.service);
    }

    @Test
    public void run_registers_service_for_parent_directory() throws IOException {
        this.watcher.run();
        ((HighSensitivityRegistrar)Mockito.verify((Object)this.registrar)).registerService((Path)ArgumentMatchers.eq((Object)this.config1.getParent()), (WatchEvent.Kind[])ArgumentMatchers.any(), (WatchService)ArgumentMatchers.any());
        ((HighSensitivityRegistrar)Mockito.verify((Object)this.registrar)).registerService((Path)ArgumentMatchers.eq((Object)this.config2.getParent()), (WatchEvent.Kind[])ArgumentMatchers.any(), (WatchService)ArgumentMatchers.any());
        ((HighSensitivityRegistrar)Mockito.verify((Object)this.registrar)).registerService((Path)ArgumentMatchers.eq((Object)this.config3.getParent()), (WatchEvent.Kind[])ArgumentMatchers.any(), (WatchService)ArgumentMatchers.any());
    }

    @Test
    public void run_registers_service_only_once_if_parent_directory_is_the_same_for_all_configs() throws IOException {
        this.watcher.run();
        ((HighSensitivityRegistrar)Mockito.verify((Object)this.registrar, (VerificationMode)Mockito.times((int)1))).registerService((Path)ArgumentMatchers.any(), (WatchEvent.Kind[])ArgumentMatchers.any(), (WatchService)ArgumentMatchers.any());
    }

    @Test
    public void run_does_NOT_register_service_if_config_is_directory() throws IOException {
        Path tempDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        TestableConfigWatcher watcher = new TestableConfigWatcher(List.of(tempDir), this.listener, this.registrar, this.service);
        watcher.run();
        ((HighSensitivityRegistrar)Mockito.verify((Object)this.registrar, (VerificationMode)Mockito.never())).registerService((Path)ArgumentMatchers.any(), (WatchEvent.Kind[])ArgumentMatchers.any(), (WatchService)ArgumentMatchers.any());
    }

    @Test
    public void listener_is_called_if_config_file_is_changed() throws InterruptedException {
        ReportingListener reportingListener = new ReportingListener();
        TestableConfigWatcher watcher = new TestableConfigWatcher(List.of(this.config1), reportingListener, this.registrar, this.service);
        ConfigWatcherTest.createWatchKeyForService(this.config1, this.service);
        watcher.run();
        Assertions.assertThat((boolean)reportingListener.isCalled()).isTrue();
        Assertions.assertThat((Object)reportingListener.getUpdatedConfig()).isNotNull();
    }

    @Test
    public void listener_is_called_if_config_file_is_changed_but_loading_it_throws() throws InterruptedException {
        ReportingListener reportingListener = new ReportingListener();
        TestableConfigWatcher watcher = new TestableConfigWatcher(List.of(this.config1), reportingListener, this.registrar, this.service){

            @Override
            @NotNull
            protected Config createConfig() {
                throw new YAMLException("can't use the force");
            }
        };
        ConfigWatcherTest.createWatchKeyForService(this.config1, this.service);
        watcher.run();
        Assertions.assertThat((boolean)reportingListener.isCalled()).isTrue();
        Assertions.assertThat((Throwable)reportingListener.getError()).isInstanceOf(YAMLException.class);
    }

    @Test
    public void listener_is_NOT_called_if_a_different_file_is_changed() throws InterruptedException {
        ReportingListener reportingListener = new ReportingListener();
        TestableConfigWatcher watcher = new TestableConfigWatcher(List.of(this.config1), reportingListener, this.registrar, this.service);
        ConfigWatcherTest.createWatchKeyForService(this.config2, this.service);
        watcher.run();
        Assertions.assertThat((boolean)reportingListener.isCalled()).isFalse();
    }

    @Test
    public void listener_resets_key_after_consuming_its_events() throws InterruptedException {
        ReportingListener reportingListener = new ReportingListener();
        TestableConfigWatcher watcher = new TestableConfigWatcher(List.of(this.config1), reportingListener, this.registrar, this.service);
        WatchKey key = ConfigWatcherTest.createWatchKeyForService(this.config2, this.service);
        watcher.run();
        ((WatchKey)Mockito.verify((Object)key)).reset();
    }

    @Test
    public void close_is_closing_service_if_it_was_run() throws IOException {
        this.watcher.run();
        this.watcher.close();
        ((WatchService)Mockito.verify((Object)this.service)).close();
    }

    @Test
    public void close_is_NOT_closing_service_if_it_was_NOT_run() throws IOException {
        this.watcher.close();
        ((WatchService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.never())).close();
    }

    private static WatchKey createWatchKeyForService(Path path, WatchService service) throws InterruptedException {
        WatchEvent event = (WatchEvent)Mockito.mock(WatchEvent.class);
        Mockito.when((Object)((Path)event.context())).thenReturn((Object)path);
        WatchKey key = (WatchKey)Mockito.mock(WatchKey.class);
        Mockito.when(key.pollEvents()).thenReturn(List.of(event));
        Mockito.when((Object)service.take()).thenReturn((Object)key).thenReturn(null);
        return key;
    }

    private static class TestableConfigWatcher
    extends ConfigWatcher {
        private final WatchService service;

        public TestableConfigWatcher(List<Path> configs, ConfigWatcher.Listener listener, HighSensitivityRegistrar registrar, WatchService service) {
            super(configs, listener, registrar);
            this.service = service;
        }

        protected WatchService createWatchService() throws IOException {
            return this.service;
        }

        @NotNull
        protected Config createConfig() {
            return (Config)Mockito.mock(Config.class);
        }
    }

    private static class ReportingListener
    implements ConfigWatcher.Listener {
        private boolean called = false;
        private Config updatedConfig;
        private Exception error;

        private ReportingListener() {
        }

        public void onUpdate(Config updatedConfig, Exception error) {
            this.called = true;
            this.updatedConfig = updatedConfig;
            this.error = error;
        }

        public boolean isCalled() {
            return this.called;
        }

        public Config getUpdatedConfig() {
            return this.updatedConfig;
        }

        public Exception getError() {
            return this.error;
        }
    }
}

