/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.intellij.openapi.ui.TestDialog;
import com.intellij.testFramework.LightPlatformTestCase;
import com.redhat.devtools.intellij.common.utils.DownloadHelper;
import com.redhat.devtools.intellij.common.utils.MessagesHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;

public class DownloadHelperTest
extends LightPlatformTestCase {
    private TestDialog previous;

    public void setUp() throws Exception {
        super.setUp();
        this.previous = MessagesHelper.setTestDialog(TestDialog.OK);
    }

    protected void tearDown() throws Exception {
        MessagesHelper.setTestDialog(this.previous);
        super.tearDown();
    }

    public void testThatGZIsDownloaded() throws IOException {
        DownloadHelper.ToolInstance toolInstance = DownloadHelper.getInstance().downloadIfRequired("tkn", DownloadHelperTest.class.getResource("/tkn-test-gz.json"));
        DownloadHelperTest.assertNotNull((Object)toolInstance);
        DownloadHelperTest.assertNotNull((Object)toolInstance.getCommand());
        DownloadHelperTest.assertEquals((String)("." + File.separatorChar + "cache" + File.separatorChar + "0.5.0" + File.separatorChar + "tkn"), (String)toolInstance.getCommand());
        FileUtils.deleteDirectory((File)Paths.get(toolInstance.getCommand(), new String[0]).toFile().getParentFile());
    }

    public void testThatTarGZIsDownloaded() throws IOException {
        DownloadHelper.ToolInstance toolInstance = DownloadHelper.getInstance().downloadIfRequired("tkn", DownloadHelperTest.class.getResource("/tkn-test-tar.gz.json"));
        DownloadHelperTest.assertNotNull((Object)toolInstance);
        DownloadHelperTest.assertNotNull((Object)toolInstance.getCommand());
        DownloadHelperTest.assertEquals((String)("." + File.separatorChar + "cache" + File.separatorChar + "0.5.0" + File.separatorChar + "tkn"), (String)toolInstance.getCommand());
        FileUtils.deleteDirectory((File)Paths.get(toolInstance.getCommand(), new String[0]).toFile().getParentFile());
    }

    public void testThatPlainFileDownloaded() throws IOException {
        DownloadHelper.ToolInstance toolInstance = DownloadHelper.getInstance().downloadIfRequired("kn", DownloadHelperTest.class.getResource("/knative-test.json"));
        DownloadHelperTest.assertNotNull((Object)toolInstance);
        DownloadHelperTest.assertNotNull((Object)toolInstance.getCommand());
        DownloadHelperTest.assertEquals((String)("." + File.separatorChar + "cache" + File.separatorChar + "0.5.0" + File.separatorChar + "tkn"), (String)toolInstance.getCommand());
        FileUtils.deleteDirectory((File)Paths.get(toolInstance.getCommand(), new String[0]).toFile().getParentFile());
    }

    public void testThatChecksumIsValidForDownloadedTool() throws IOException {
        DownloadHelper.ToolInstance toolInstance = DownloadHelper.getInstance().downloadIfRequired("tkn", DownloadHelperTest.class.getResource("/tkn-test.json"));
        DownloadHelperTest.assertNotNull((Object)toolInstance);
        DownloadHelperTest.assertNotNull((Object)toolInstance.getCommand());
        FileUtils.deleteDirectory((File)Paths.get(toolInstance.getCommand(), new String[0]).toFile().getParentFile());
    }

    public void testThatChecksumIsInValidForDownloadedTool() {
        try {
            DownloadHelper.getInstance().downloadIfRequired("tkn", DownloadHelperTest.class.getResource("/tkn-test-invalid-checksum.json"));
            DownloadHelperTest.fail((String)"should raise exception");
        }
        catch (IOException e) {
            DownloadHelperTest.assertTrue((boolean)e.getMessage().contains("Error while setting tool"));
        }
    }

    public void testThatPlainFileDownloadedInUserSpecificFolder() throws IOException {
        DownloadHelper.ToolInstance toolInstance = DownloadHelper.getInstance().downloadIfRequired("tkn", DownloadHelperTest.class.getResource("/tkn-override-basedir-test.json"));
        DownloadHelperTest.assertNotNull((Object)toolInstance);
        DownloadHelperTest.assertNotNull((Object)toolInstance.getCommand());
        DownloadHelperTest.assertEquals((String)(System.getProperty("tools.dl.path") + File.separatorChar + ".tkn-test" + File.separatorChar + "cache" + File.separatorChar + "0.5.0" + File.separatorChar + "tkn"), (String)toolInstance.getCommand());
        FileUtils.deleteDirectory((File)Paths.get(toolInstance.getCommand(), new String[0]).toFile().getParentFile().getParentFile().getParentFile());
    }
}

