/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.validation;

import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.redhat.devtools.intellij.common.validation.KubernetesResourceInfo;
import com.redhat.devtools.intellij.common.validation.KubernetesTypeInfo;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLValue;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

public class KubernetesResourceInfoTest {
    private static final String KEY_METADATA = "metadata";
    private static final String KEY_NAME = "name";
    private static final String KEY_NAMESPACE = "namespace";
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule();
    @Mock
    private JsonFile jsonFile;
    @Mock
    private YAMLFile yamlFile;
    @Mock
    private JsonValue jsonTopLevelValue;
    @Mock
    private YAMLDocument yamlDocument;
    @Mock
    private YAMLValue yamlTopLevelValue;
    @Mock
    private KubernetesTypeInfo typeInfo;
    private MockedStatic<KubernetesTypeInfo> mockStatic;

    @Before
    public void setUp() {
        this.mockStatic = Mockito.mockStatic(KubernetesTypeInfo.class);
    }

    @After
    public void tearDown() {
        this.mockStatic.close();
    }

    @Test
    public void create_returns_info_for_json_file() {
        JsonProperty metadataProperty = (JsonProperty)Mockito.mock(JsonProperty.class);
        JsonValue metadataValue = (JsonValue)Mockito.mock(JsonValue.class);
        JsonProperty nameProperty = (JsonProperty)Mockito.mock(JsonProperty.class);
        JsonProperty namespaceProperty = (JsonProperty)Mockito.mock(JsonProperty.class);
        JsonValue nameValue = (JsonValue)Mockito.mock(JsonValue.class);
        JsonValue namespaceValue = (JsonValue)Mockito.mock(JsonValue.class);
        Mockito.when((Object)this.jsonFile.getTopLevelValue()).thenReturn((Object)this.jsonTopLevelValue);
        Mockito.when((Object)metadataProperty.getName()).thenReturn((Object)KEY_METADATA);
        Mockito.when((Object)metadataProperty.getValue()).thenReturn((Object)metadataValue);
        Mockito.when((Object)nameProperty.getName()).thenReturn((Object)KEY_NAME);
        Mockito.when((Object)namespaceProperty.getName()).thenReturn((Object)KEY_NAMESPACE);
        Mockito.when((Object)nameProperty.getValue()).thenReturn((Object)nameValue);
        Mockito.when((Object)namespaceProperty.getValue()).thenReturn((Object)namespaceValue);
        Mockito.when((Object)nameValue.getText()).thenReturn((Object)"\"obiwan\"");
        Mockito.when((Object)namespaceValue.getText()).thenReturn((Object)"\"stewjon\"");
        ((JsonValue)Mockito.doAnswer(invocation -> {
            PsiElementVisitor visitor = (PsiElementVisitor)invocation.getArgument(0);
            visitor.visitElement((PsiElement)metadataProperty);
            return null;
        }).when((Object)this.jsonTopLevelValue)).acceptChildren((PsiElementVisitor)Mockito.any(PsiElementVisitor.class));
        ((JsonValue)Mockito.doAnswer(invocation -> {
            PsiElementVisitor visitor = (PsiElementVisitor)invocation.getArgument(0);
            visitor.visitElement((PsiElement)nameProperty);
            visitor.visitElement((PsiElement)namespaceProperty);
            return null;
        }).when((Object)metadataValue)).acceptChildren((PsiElementVisitor)Mockito.any(PsiElementVisitor.class));
        this.mockCreateKubernetesTypeInfo(this.typeInfo, (PsiFile)this.jsonFile);
        KubernetesResourceInfo resourceInfo = KubernetesResourceInfo.create((PsiFile)this.jsonFile);
        Assertions.assertThat((Object)resourceInfo).isNotNull();
        Assertions.assertThat((String)resourceInfo.getName()).isEqualTo("\"obiwan\"");
        Assertions.assertThat((String)resourceInfo.getNamespace()).isEqualTo("\"stewjon\"");
    }

    @Test
    public void create_returns_info_for_yaml_file() {
        YAMLKeyValue metadataKeyValue = (YAMLKeyValue)Mockito.mock(YAMLKeyValue.class);
        YAMLValue metadataValue = (YAMLValue)Mockito.mock(YAMLValue.class);
        YAMLKeyValue nameKeyValue = (YAMLKeyValue)Mockito.mock(YAMLKeyValue.class);
        YAMLKeyValue namespaceKeyValue = (YAMLKeyValue)Mockito.mock(YAMLKeyValue.class);
        Mockito.when((Object)this.yamlFile.getDocuments()).thenReturn(Collections.singletonList(this.yamlDocument));
        Mockito.when((Object)this.yamlDocument.getTopLevelValue()).thenReturn((Object)this.yamlTopLevelValue);
        Mockito.when((Object)metadataKeyValue.getName()).thenReturn((Object)KEY_METADATA);
        Mockito.when((Object)metadataKeyValue.getValue()).thenReturn((Object)metadataValue);
        Mockito.when((Object)nameKeyValue.getName()).thenReturn((Object)KEY_NAME);
        Mockito.when((Object)namespaceKeyValue.getName()).thenReturn((Object)KEY_NAMESPACE);
        Mockito.when((Object)nameKeyValue.getValueText()).thenReturn((Object)"obiwan");
        Mockito.when((Object)namespaceKeyValue.getValueText()).thenReturn((Object)"stewjon");
        ((YAMLValue)Mockito.doAnswer(invocation -> {
            PsiElementVisitor visitor = (PsiElementVisitor)invocation.getArgument(0);
            visitor.visitElement((PsiElement)metadataKeyValue);
            return null;
        }).when((Object)this.yamlTopLevelValue)).acceptChildren((PsiElementVisitor)Mockito.any(PsiElementVisitor.class));
        ((YAMLValue)Mockito.doAnswer(invocation -> {
            PsiElementVisitor visitor = (PsiElementVisitor)invocation.getArgument(0);
            visitor.visitElement((PsiElement)nameKeyValue);
            visitor.visitElement((PsiElement)namespaceKeyValue);
            return null;
        }).when((Object)metadataValue)).acceptChildren((PsiElementVisitor)Mockito.any(PsiElementVisitor.class));
        this.mockCreateKubernetesTypeInfo(this.typeInfo, (PsiFile)this.yamlFile);
        KubernetesResourceInfo resourceInfo = KubernetesResourceInfo.create((PsiFile)this.yamlFile);
        Assertions.assertThat((Object)resourceInfo).isNotNull();
        Assertions.assertThat((String)resourceInfo.getName()).isEqualTo("obiwan");
        Assertions.assertThat((String)resourceInfo.getNamespace()).isEqualTo("stewjon");
    }

    @Test
    public void create_returns_empty_info_for_json_file_without_top_level_value() {
        Mockito.when((Object)this.jsonFile.getTopLevelValue()).thenReturn(null);
        this.mockCreateKubernetesTypeInfo(this.typeInfo, (PsiFile)this.jsonFile);
        KubernetesResourceInfo resourceInfo = KubernetesResourceInfo.create((PsiFile)this.jsonFile);
        Assertions.assertThat((Object)resourceInfo).isNotNull();
        Assertions.assertThat((String)resourceInfo.getName()).isNull();
        Assertions.assertThat((String)resourceInfo.getNamespace()).isNull();
    }

    @Test
    public void create_returns_empty_info_for_yaml_file_without_documents() {
        Mockito.when((Object)this.yamlFile.getDocuments()).thenReturn(Collections.emptyList());
        this.mockCreateKubernetesTypeInfo(this.typeInfo, (PsiFile)this.yamlFile);
        KubernetesResourceInfo resourceInfo = KubernetesResourceInfo.create((PsiFile)this.yamlFile);
        Assertions.assertThat((Object)resourceInfo).isNotNull();
        Assertions.assertThat((String)resourceInfo.getName()).isNull();
        Assertions.assertThat((String)resourceInfo.getNamespace()).isNull();
    }

    @Test
    public void create_returns_empty_info_for_yaml_for_file_with_null_document() {
        Mockito.when((Object)this.yamlFile.getDocuments()).thenReturn(Collections.singletonList(null));
        this.mockCreateKubernetesTypeInfo(this.typeInfo, (PsiFile)this.yamlFile);
        KubernetesResourceInfo resourceInfo = KubernetesResourceInfo.create((PsiFile)this.yamlFile);
        Assertions.assertThat((Object)resourceInfo).isNotNull();
        Assertions.assertThat((String)resourceInfo.getName()).isNull();
        Assertions.assertThat((String)resourceInfo.getNamespace()).isNull();
    }

    @Test
    public void create_returns_empty_info_for_yaml_file_with_document_that_has_null_top_level_value() {
        Mockito.when((Object)this.yamlFile.getDocuments()).thenReturn(Collections.singletonList(this.yamlDocument));
        Mockito.when((Object)this.yamlDocument.getTopLevelValue()).thenReturn(null);
        this.mockCreateKubernetesTypeInfo(this.typeInfo, (PsiFile)this.yamlFile);
        KubernetesResourceInfo resourceInfo = KubernetesResourceInfo.create((PsiFile)this.yamlFile);
        Assertions.assertThat((Object)resourceInfo).isNotNull();
        Assertions.assertThat((String)resourceInfo.getName()).isNull();
        Assertions.assertThat((String)resourceInfo.getNamespace()).isNull();
    }

    @Test
    public void equals_and_hashcode_are_correct() {
        KubernetesResourceInfo info1 = new KubernetesResourceInfo("obiwan", "stewjon", this.typeInfo);
        KubernetesResourceInfo info2 = new KubernetesResourceInfo("obiwan", "stewjon", this.typeInfo);
        KubernetesResourceInfo info3 = new KubernetesResourceInfo("luke", "stewjon", this.typeInfo);
        KubernetesResourceInfo info4 = new KubernetesResourceInfo("obiwan", "tatooine", this.typeInfo);
        KubernetesResourceInfo info5 = new KubernetesResourceInfo("obiwan", "stewjon", (KubernetesTypeInfo)Mockito.mock(KubernetesTypeInfo.class));
        Assertions.assertThat((Object)info1).isEqualTo((Object)info1);
        Assertions.assertThat((Object)info1).isEqualTo((Object)info2);
        Assertions.assertThat((Object)info1).isNotEqualTo(null);
        Assertions.assertThat((Object)info1).isNotEqualTo((Object)"not a ResourceInfo");
        Assertions.assertThat((Object)info1).isNotEqualTo((Object)info3);
        Assertions.assertThat((Object)info1).isNotEqualTo((Object)info4);
        Assertions.assertThat((Object)info1).isNotEqualTo((Object)info5);
        Assertions.assertThat((int)info1.hashCode()).isEqualTo(info2.hashCode());
        Assertions.assertThat((int)info1.hashCode()).isNotEqualTo(info3.hashCode());
    }

    @Test
    public void toString_concatenates_name_and_namespace() {
        KubernetesResourceInfo info = new KubernetesResourceInfo("obiwan", "stewjon", this.typeInfo);
        String result = info.toString();
        Assertions.assertThat((String)result).isEqualTo("obiwan, stewjon");
    }

    @Test
    public void create_returns_empty_info_for_unsupported_file_type() {
        PsiFile unsupportedFile = (PsiFile)Mockito.mock(PsiFile.class);
        this.mockCreateKubernetesTypeInfo(this.typeInfo, unsupportedFile);
        KubernetesResourceInfo resourceInfo = KubernetesResourceInfo.create((PsiFile)unsupportedFile);
        Assertions.assertThat((Object)resourceInfo).isNotNull();
        Assertions.assertThat((String)resourceInfo.getName()).isNull();
        Assertions.assertThat((String)resourceInfo.getNamespace()).isNull();
    }

    @Test
    public void getApiGroup_returns_apiGroup_of_typeInfo() {
        KubernetesResourceInfo info = new KubernetesResourceInfo("obiwan", "stewjon", this.typeInfo);
        info.getApiGroup();
        ((KubernetesTypeInfo)Mockito.verify((Object)this.typeInfo)).getApiGroup();
    }

    @Test
    public void getApiGroup_returns_null_given_typeInfo_is_null() {
        KubernetesResourceInfo info = new KubernetesResourceInfo("obiwan", "tatooine", null);
        String apiGroup = info.getApiGroup();
        Assertions.assertThat((String)apiGroup).isNull();
    }

    @Test
    public void getKind_returns_kind_of_typeInfo() {
        KubernetesResourceInfo info = new KubernetesResourceInfo("luke", "stewjon", this.typeInfo);
        info.getKind();
        ((KubernetesTypeInfo)Mockito.verify((Object)this.typeInfo)).getKind();
    }

    @Test
    public void getKind_returns_null_given_typeInfo_is_nul() {
        KubernetesResourceInfo info = new KubernetesResourceInfo("luke", "stewjon", null);
        String kind = info.getKind();
        Assertions.assertThat((String)kind).isNull();
    }

    private void mockCreateKubernetesTypeInfo(KubernetesTypeInfo typeInfo, PsiFile file) {
        this.mockStatic.when(() -> KubernetesTypeInfo.create((PsiFile)file)).thenReturn((Object)typeInfo);
    }
}

