/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.validation;

import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.redhat.devtools.intellij.common.validation.KubernetesTypeInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLValue;
import org.junit.Test;
import org.mockito.Mockito;

public class KubernetesTypeInfoTest {
    @Test
    public void getApiGroup_should_return_value_given_in_constructor() {
        String apiGroup = "apps/v1";
        KubernetesTypeInfo type = new KubernetesTypeInfo(apiGroup, null);
        Assertions.assertThat((String)type.getApiGroup()).isEqualTo(apiGroup);
    }

    @Test
    public void getKind_should_return_value_given_in_constructor() {
        String kind = "Deployment";
        KubernetesTypeInfo type = new KubernetesTypeInfo(null, kind);
        Assertions.assertThat((String)type.getKind()).isEqualTo(kind);
    }

    @Test
    public void getApiGroup_and_getKind_should_have_empty_instance_variables_when_default_constructor() {
        KubernetesTypeInfo type = new KubernetesTypeInfo();
        Assertions.assertThat((String)type.getApiGroup()).isEmpty();
        Assertions.assertThat((String)type.getKind()).isEmpty();
    }

    @Test
    public void setApiGroup_and_setKind_should_be_set_to_instance_variables() {
        KubernetesTypeInfo type = new KubernetesTypeInfo();
        String apiGroup = "apps/v1";
        String kind = "Deployment";
        type.setApiGroup(apiGroup);
        type.setKind(kind);
        Assertions.assertThat((String)type.getApiGroup()).isEqualTo(apiGroup);
        Assertions.assertThat((String)type.getKind()).isEqualTo(kind);
    }

    @Test
    public void equals_should_return_true_for_identical_apiGroup_and_kind() {
        KubernetesTypeInfo type1 = new KubernetesTypeInfo("apps/v1", "Deployment");
        KubernetesTypeInfo type2 = new KubernetesTypeInfo("apps/v1", "Deployment");
        Assertions.assertThat((Object)type1).isEqualTo((Object)type2);
    }

    @Test
    public void equals_should_return_false_for_different_apiGroup_and_kind() {
        KubernetesTypeInfo type1 = new KubernetesTypeInfo("apps/v1", "Deployment");
        KubernetesTypeInfo type2 = new KubernetesTypeInfo("v1", "Pod");
        Assertions.assertThat((Object)type1).isNotEqualTo((Object)type2);
    }

    @Test
    public void hashCode_should_be_equal_for_instances_with_identical_apiGroup_and_kind() {
        KubernetesTypeInfo type1 = new KubernetesTypeInfo("apps/v1", "Deployment");
        KubernetesTypeInfo type2 = new KubernetesTypeInfo("apps/v1", "Deployment");
        Assertions.assertThat((int)type1.hashCode()).isEqualTo(type2.hashCode());
    }

    @Test
    public void toString_should_concatenate_apiGroup_and_kind() {
        KubernetesTypeInfo type = new KubernetesTypeInfo("apps/v1", "Deployment");
        String result = type.toString();
        Assertions.assertThat((String)result).isEqualTo("apps/v1#Deployment");
    }

    @Test
    public void fromFilename_should_extract_apiGroup_and_kind_from_file_name() {
        Assertions.assertThat((Object)KubernetesTypeInfo.fromFileName((String)"apps.v1_Deployment.yaml")).isEqualTo((Object)new KubernetesTypeInfo("apps.v1", "Deployment"));
        Assertions.assertThat((Object)KubernetesTypeInfo.fromFileName((String)"Pod.yaml")).isEqualTo((Object)new KubernetesTypeInfo("", "Pod"));
        Assertions.assertThat((Object)KubernetesTypeInfo.fromFileName((String)"apps.v1_Deployment")).isEqualTo((Object)new KubernetesTypeInfo("apps.v1", "Deployment"));
    }

    @Test
    public void create_should_return_null_for_file_that_is_neither_json_nor_yaml() {
        PsiFile mockFile = (PsiFile)Mockito.mock(HtmlFileImpl.class);
        KubernetesTypeInfo type = KubernetesTypeInfo.create((PsiFile)mockFile);
        Assertions.assertThat((Object)type).isNull();
    }

    @Test
    public void create_should_return_apiGroup_and_kind_from_json_file() {
        JsonFile jsonFile = (JsonFile)Mockito.mock(JsonFile.class);
        JsonValue topLevelValue = (JsonValue)Mockito.mock(JsonValue.class);
        ((JsonFile)Mockito.doReturn((Object)topLevelValue).when((Object)jsonFile)).getTopLevelValue();
        JsonProperty apiVersion = KubernetesTypeInfoTest.mockJsonProperty("apiVersion", "apps/v1");
        JsonProperty kind = KubernetesTypeInfoTest.mockJsonProperty("kind", "Deployment");
        KubernetesTypeInfoTest.visitJsonKubernetesTypeInfo(apiVersion, kind, topLevelValue);
        KubernetesTypeInfo type = KubernetesTypeInfo.create((PsiFile)jsonFile);
        Assertions.assertThat((Object)type).isNotNull();
        Assertions.assertThat((String)type.getApiGroup()).isEqualTo("apps/v1");
        Assertions.assertThat((String)type.getKind()).isEqualTo("Deployment");
    }

    @Test
    public void create_should_return_unquoted_apiGroup_and_kind_from_json_file() {
        JsonFile jsonFile = (JsonFile)Mockito.mock(JsonFile.class);
        JsonValue topLevelValue = (JsonValue)Mockito.mock(JsonValue.class);
        ((JsonFile)Mockito.doReturn((Object)topLevelValue).when((Object)jsonFile)).getTopLevelValue();
        JsonProperty apiVersion = KubernetesTypeInfoTest.mockJsonProperty("apiVersion", "\"apps/v1\"");
        JsonProperty kind = KubernetesTypeInfoTest.mockJsonProperty("kind", "\"Deployment\"");
        KubernetesTypeInfoTest.visitJsonKubernetesTypeInfo(apiVersion, kind, topLevelValue);
        KubernetesTypeInfo type = KubernetesTypeInfo.create((PsiFile)jsonFile);
        Assertions.assertThat((Object)type).isNotNull();
        Assertions.assertThat((String)type.getApiGroup()).isEqualTo("apps/v1");
        Assertions.assertThat((String)type.getKind()).isEqualTo("Deployment");
    }

    @Test
    public void create_should_return_apiGroup_and_kind_from_yaml_file() {
        YAMLFile yamlFile = (YAMLFile)Mockito.mock(YAMLFile.class);
        YAMLDocument document = (YAMLDocument)Mockito.mock(YAMLDocument.class);
        Mockito.when((Object)yamlFile.getDocuments()).thenReturn(List.of(document));
        YAMLValue topLevelValue = (YAMLValue)Mockito.mock(YAMLValue.class);
        Mockito.when((Object)document.getTopLevelValue()).thenReturn((Object)topLevelValue);
        YAMLKeyValue apiVersion = KubernetesTypeInfoTest.mockYAMLKeyValue("apiVersion", "apps/v1");
        YAMLKeyValue kind = KubernetesTypeInfoTest.mockYAMLKeyValue("kind", "Deployment");
        KubernetesTypeInfoTest.visitYamlKubernetesTypeInfo(apiVersion, kind, topLevelValue);
        KubernetesTypeInfo type = KubernetesTypeInfo.create((PsiFile)yamlFile);
        Assertions.assertThat((Object)type).isNotNull();
        Assertions.assertThat((String)type.getApiGroup()).isEqualTo("apps/v1");
        Assertions.assertThat((String)type.getKind()).isEqualTo("Deployment");
    }

    @Test
    public void create_should_return_unquoted_apiGroup_and_kind_from_yaml_file() {
        YAMLFile yamlFile = (YAMLFile)Mockito.mock(YAMLFile.class);
        YAMLDocument document = (YAMLDocument)Mockito.mock(YAMLDocument.class);
        Mockito.when((Object)yamlFile.getDocuments()).thenReturn(List.of(document));
        YAMLValue topLevelValue = (YAMLValue)Mockito.mock(YAMLValue.class);
        Mockito.when((Object)document.getTopLevelValue()).thenReturn((Object)topLevelValue);
        YAMLKeyValue apiVersion = KubernetesTypeInfoTest.mockYAMLKeyValue("apiVersion", "\"apps/v1\"");
        YAMLKeyValue kind = KubernetesTypeInfoTest.mockYAMLKeyValue("kind", "\"Deployment\"");
        KubernetesTypeInfoTest.visitYamlKubernetesTypeInfo(apiVersion, kind, topLevelValue);
        KubernetesTypeInfo type = KubernetesTypeInfo.create((PsiFile)yamlFile);
        Assertions.assertThat((Object)type).isNotNull();
        Assertions.assertThat((String)type.getApiGroup()).isEqualTo("apps/v1");
        Assertions.assertThat((String)type.getKind()).isEqualTo("Deployment");
    }

    @Test
    public void create_should_return_null_for_null_yaml_file() {
        KubernetesTypeInfo type = KubernetesTypeInfo.create((PsiFile)((YAMLFile)null));
        Assertions.assertThat((Object)type).isNull();
    }

    @Test
    public void create_should_return_null_for_empty_yaml_file() {
        YAMLFile mockYamlFile = (YAMLFile)Mockito.mock(YAMLFile.class);
        Mockito.when((Object)mockYamlFile.getDocuments()).thenReturn(Collections.emptyList());
        KubernetesTypeInfo type = KubernetesTypeInfo.create((PsiFile)mockYamlFile);
        Assertions.assertThat((Object)type).isNull();
    }

    @Test
    public void create_should_return_apiGroup_and_kind_for_yaml_document() {
        YAMLDocument document = (YAMLDocument)Mockito.mock(YAMLDocument.class);
        YAMLValue topLevelValue = (YAMLValue)Mockito.mock(YAMLValue.class);
        Mockito.when((Object)document.getTopLevelValue()).thenReturn((Object)topLevelValue);
        YAMLKeyValue apiVersion = KubernetesTypeInfoTest.mockYAMLKeyValue("apiVersion", "apps/v1");
        YAMLKeyValue kind = KubernetesTypeInfoTest.mockYAMLKeyValue("kind", "Deployment");
        KubernetesTypeInfoTest.visitYamlKubernetesTypeInfo(apiVersion, kind, topLevelValue);
        KubernetesTypeInfo type = KubernetesTypeInfo.create((YAMLDocument)document);
        Assertions.assertThat((Object)type).isNotNull();
        Assertions.assertThat((String)type.getApiGroup()).isEqualTo("apps/v1");
        Assertions.assertThat((String)type.getKind()).isEqualTo("Deployment");
    }

    @Test
    public void createTypes_should_return_null_for_null_yaml_document() {
        KubernetesTypeInfo type = KubernetesTypeInfo.create((YAMLDocument)null);
        Assertions.assertThat((Object)type).isNull();
    }

    @Test
    public void createTypesshould_return_null_for_null_yaml_file() {
        List types = KubernetesTypeInfo.createTypes(null);
        Assertions.assertThat((List)types).isNull();
    }

    @Test
    public void createTypesshould_return_null_for_empty_yaml_file() {
        YAMLFile mockYamlFile = (YAMLFile)Mockito.mock(YAMLFile.class);
        Mockito.when((Object)mockYamlFile.getDocuments()).thenReturn(Collections.emptyList());
        List types = KubernetesTypeInfo.createTypes((YAMLFile)mockYamlFile);
        Assertions.assertThat((List)types).isNull();
    }

    @Test
    public void createTypes_should_return_list_of_metas_for_yaml_file_with_multiple_documents() {
        YAMLFile yamlFile = (YAMLFile)Mockito.mock(YAMLFile.class);
        YAMLDocument document1 = (YAMLDocument)Mockito.mock(YAMLDocument.class);
        YAMLDocument document2 = (YAMLDocument)Mockito.mock(YAMLDocument.class);
        Mockito.when((Object)yamlFile.getDocuments()).thenReturn(Arrays.asList(document1, document2));
        YAMLValue topLevelValue1 = (YAMLValue)Mockito.mock(YAMLValue.class);
        Mockito.when((Object)document1.getTopLevelValue()).thenReturn((Object)topLevelValue1);
        YAMLKeyValue apiVersion1 = KubernetesTypeInfoTest.mockYAMLKeyValue("apiVersion", "apps/v1");
        YAMLKeyValue kind1 = KubernetesTypeInfoTest.mockYAMLKeyValue("kind", "Deployment");
        KubernetesTypeInfoTest.visitYamlKubernetesTypeInfo(apiVersion1, kind1, topLevelValue1);
        YAMLValue topLevelValue2 = (YAMLValue)Mockito.mock(YAMLValue.class);
        ((YAMLDocument)Mockito.doReturn((Object)topLevelValue2).when((Object)document2)).getTopLevelValue();
        YAMLKeyValue apiVersion2 = KubernetesTypeInfoTest.mockYAMLKeyValue("apiVersion", "v1");
        YAMLKeyValue kind2 = KubernetesTypeInfoTest.mockYAMLKeyValue("kind", "Pod");
        KubernetesTypeInfoTest.visitYamlKubernetesTypeInfo(apiVersion2, kind2, topLevelValue2);
        List types = KubernetesTypeInfo.createTypes((YAMLFile)yamlFile);
        Assertions.assertThat((List)types).hasSize(2);
        Assertions.assertThat((String)((KubernetesTypeInfo)types.get(0)).getApiGroup()).isEqualTo("apps/v1");
        Assertions.assertThat((String)((KubernetesTypeInfo)types.get(0)).getKind()).isEqualTo("Deployment");
        Assertions.assertThat((String)((KubernetesTypeInfo)types.get(1)).getApiGroup()).isEqualTo("v1");
        Assertions.assertThat((String)((KubernetesTypeInfo)types.get(1)).getKind()).isEqualTo("Pod");
    }

    @NotNull
    private static YAMLKeyValue mockYAMLKeyValue(String key, String value) {
        YAMLKeyValue keyValue = (YAMLKeyValue)Mockito.mock(YAMLKeyValue.class);
        Mockito.when((Object)keyValue.getKeyText()).thenReturn((Object)key);
        Mockito.when((Object)keyValue.getValueText()).thenReturn((Object)value);
        return keyValue;
    }

    @NotNull
    private static JsonProperty mockJsonProperty(String name, String value) {
        JsonProperty property = (JsonProperty)Mockito.mock(JsonProperty.class);
        Mockito.when((Object)property.getName()).thenReturn((Object)name);
        JsonValue jsonValue = (JsonValue)Mockito.mock(JsonValue.class);
        Mockito.when((Object)jsonValue.getText()).thenReturn((Object)value);
        Mockito.when((Object)property.getValue()).thenReturn((Object)jsonValue);
        return property;
    }

    private static void visitJsonKubernetesTypeInfo(JsonProperty apiVersion, JsonProperty kind, JsonValue topLevelValue) {
        ((JsonValue)Mockito.doAnswer(invocation -> {
            KubernetesTypeInfo.JsonKubernetesTypeInfoVisitor visitor = (KubernetesTypeInfo.JsonKubernetesTypeInfoVisitor)invocation.getArgument(0);
            visitor.visitElement((PsiElement)apiVersion);
            visitor.visitElement((PsiElement)kind);
            return null;
        }).when((Object)topLevelValue)).acceptChildren((PsiElementVisitor)Mockito.any(KubernetesTypeInfo.JsonKubernetesTypeInfoVisitor.class));
    }

    private static void visitYamlKubernetesTypeInfo(YAMLKeyValue apiVersion, YAMLKeyValue kind, YAMLValue topLevelValue) {
        ((YAMLValue)Mockito.doAnswer(invocation -> {
            KubernetesTypeInfo.YAMLKubernetesTypeInfoVisitor visitor = (KubernetesTypeInfo.YAMLKubernetesTypeInfoVisitor)invocation.getArgument(0);
            visitor.visitElement((PsiElement)apiVersion);
            visitor.visitElement((PsiElement)kind);
            return null;
        }).when((Object)topLevelValue)).acceptChildren((PsiElementVisitor)Mockito.any(KubernetesTypeInfo.YAMLKubernetesTypeInfoVisitor.class));
    }
}

