/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.ssl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.net.ssl.CertificateManager;
import com.redhat.devtools.intellij.common.ssl.CompositeX509ExtendedTrustManager;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.reflect.FieldUtils;

public class IDEATrustManager {
    private static final Logger LOG = Logger.getInstance(IDEATrustManager.class);
    private final X509TrustManager trustManager;

    public IDEATrustManager() {
        this.trustManager = CertificateManager.getInstance().getTrustManager();
    }

    public IDEATrustManager(X509TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public X509TrustManager configure(List<X509ExtendedTrustManager> toAdd) {
        try {
            if (this.hasSystemManagerField()) {
                this.setCompositeManager(toAdd, this.trustManager);
            } else {
                this.addCompositeManager(toAdd, this.trustManager);
            }
        }
        catch (IllegalAccessException | RuntimeException e) {
            LOG.warn("Could not configure IDEA trust manager.", (Throwable)e);
        }
        return this.trustManager;
    }

    private boolean hasSystemManagerField() {
        return this.getSystemManagerField() != null;
    }

    private Field getSystemManagerField() {
        return FieldUtils.getDeclaredField(this.trustManager.getClass(), (String)"mySystemManager", (boolean)true);
    }

    private void setCompositeManager(List<X509ExtendedTrustManager> trustManagers, X509TrustManager destination) throws IllegalAccessException {
        Field systemManagerField = this.getSystemManagerField();
        if (systemManagerField == null) {
            return;
        }
        Object object = systemManagerField.get(destination);
        if (!(object instanceof X509ExtendedTrustManager)) {
            return;
        }
        X509ExtendedTrustManager systemManager = (X509ExtendedTrustManager)object;
        X509ExtendedTrustManager compositeTrustManager = this.createCompositeTrustManager(systemManager, trustManagers);
        systemManagerField.set(destination, compositeTrustManager);
    }

    private X509ExtendedTrustManager createCompositeTrustManager(X509ExtendedTrustManager systemManager, List<X509ExtendedTrustManager> clientTrustManagers) {
        ArrayList<X509ExtendedTrustManager> trustManagers = new ArrayList<X509ExtendedTrustManager>();
        if (systemManager instanceof CompositeX509ExtendedTrustManager) {
            trustManagers.add(((CompositeX509ExtendedTrustManager)systemManager).getInnerTrustManagers().get(0));
        } else {
            trustManagers.add(systemManager);
        }
        trustManagers.addAll(clientTrustManagers);
        return new CompositeX509ExtendedTrustManager(trustManagers);
    }

    private void addCompositeManager(List<X509ExtendedTrustManager> trustManagers, X509TrustManager destination) throws IllegalAccessException {
        Field systemManagersField = FieldUtils.getDeclaredField(destination.getClass(), (String)"mySystemManagers", (boolean)true);
        if (systemManagersField == null) {
            return;
        }
        Object object = systemManagersField.get(destination);
        if (!(object instanceof List)) {
            return;
        }
        List managers = (List)object;
        List nonCompositeManagers = managers.stream().filter(x509TrustManager -> !(x509TrustManager instanceof CompositeX509ExtendedTrustManager)).collect(Collectors.toList());
        CompositeX509ExtendedTrustManager clientTrustManager = new CompositeX509ExtendedTrustManager(new ArrayList<X509ExtendedTrustManager>(trustManagers));
        managers.clear();
        managers.addAll(nonCompositeManagers);
        managers.add(clientTrustManager);
    }
}

