/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.redhat.devtools.intellij.common.utils.HighSensitivityRegistrar;
import io.fabric8.kubernetes.client.Config;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ConfigWatcher
implements Runnable {
    private static final Logger LOG = Logger.getInstance(ConfigWatcher.class);
    private final List<Path> configs;
    protected final Listener listener;
    private final HighSensitivityRegistrar registrar;
    private WatchService service;

    public ConfigWatcher(Listener listener) {
        this(Config.getKubeconfigFilenames().stream().map(x$0 -> Paths.get(x$0, new String[0])).toList(), listener, new HighSensitivityRegistrar());
    }

    protected ConfigWatcher(List<Path> configs, Listener listener, HighSensitivityRegistrar registrar) {
        this.configs = configs;
        this.listener = listener;
        this.registrar = registrar;
    }

    @Override
    public void run() {
        this.watch(this.listener::onUpdate);
    }

    public void close() throws IOException {
        if (this.service != null) {
            this.service.close();
        }
    }

    private void watch(BiConsumer<Config, Exception> listener) {
        try (WatchService service = this.createWatchService();){
            Collection<Path> watchedDirectories = this.getWatchedDirectories();
            watchedDirectories.forEach(directory -> new ConfigDirectoryWatch((Path)directory, listener, service, this.registrar).start());
        }
        catch (IOException e) {
            String configPaths = this.configs.stream().map(path -> path.toAbsolutePath().toString()).collect(Collectors.joining());
            Logger.getInstance(ConfigWatcher.class).warn("Could not watch kubernetes config file at " + configPaths, (Throwable)e);
        }
    }

    protected WatchService createWatchService() throws IOException {
        this.service = FileSystems.getDefault().newWatchService();
        return this.service;
    }

    private Collection<Path> getWatchedDirectories() {
        return this.configs.stream().filter(this::isFileInDirectory).map(Path::getParent).collect(Collectors.toSet());
    }

    protected boolean isFileInDirectory(Path path) {
        return path != null && Files.isRegularFile(path, new LinkOption[0]) && Files.isDirectory(path.getParent(), new LinkOption[0]);
    }

    @NotNull
    protected Config createConfig() {
        Config config = Config.autoConfigure(null);
        if (config == null) {
            ConfigWatcher.$$$reportNull$$$0(0);
        }
        return config;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/redhat/devtools/intellij/common/utils/ConfigWatcher", "createConfig"));
    }

    public static interface Listener {
        public void onUpdate(Config var1, Exception var2);
    }

    private class ConfigDirectoryWatch {
        private final Path directory;
        private final WatchService service;
        private final HighSensitivityRegistrar registrar;
        private final BiConsumer<Config, Exception> listener;

        private ConfigDirectoryWatch(Path directory, BiConsumer<Config, Exception> listener, WatchService service, HighSensitivityRegistrar registrar) {
            this.directory = directory;
            this.listener = listener;
            this.service = service;
            this.registrar = registrar;
        }

        private void start() {
            try {
                this.register(this.directory, this.service, this.registrar);
                this.watch(this.listener, this.service);
            }
            catch (InterruptedException e) {
                LOG.warn("Watching " + this.directory + " was interrupted", (Throwable)e);
            }
            catch (IOException e) {
                LOG.warn("Could not watch " + this.directory, (Throwable)e);
            }
        }

        private void register(Path path, WatchService service, HighSensitivityRegistrar registrar) throws IOException {
            registrar.registerService(path, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE}, service);
        }

        private void watch(BiConsumer<Config, Exception> listener, WatchService service) throws InterruptedException {
            WatchKey key = service.take();
            while (key != null) {
                key.pollEvents().forEach(event -> {
                    Path changed = this.getAbsolutePath(this.directory, (Path)event.context());
                    this.notifyListener(listener, changed);
                });
                key.reset();
                key = service.take();
            }
        }

        private void notifyListener(BiConsumer<Config, Exception> listener, Path changed) {
            if (this.isConfigPath(changed)) {
                Config config = null;
                Exception error = null;
                try {
                    config = ConfigWatcher.this.createConfig();
                }
                catch (Exception e) {
                    error = e;
                    LOG.warn("Loading config with changed '" + changed + "' failed.", (Throwable)e);
                }
                listener.accept(config, error);
            }
        }

        protected boolean isConfigPath(Path path) {
            return ConfigWatcher.this.configs != null && ConfigWatcher.this.configs.contains(path);
        }

        private Path getAbsolutePath(Path directory, Path relativePath) {
            return directory.resolve(relativePath);
        }
    }
}

