/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.io.HttpRequests;
import com.redhat.devtools.intellij.common.CommonConstants;
import com.redhat.devtools.intellij.common.utils.ExecHelper;
import com.redhat.devtools.intellij.common.utils.ToolsConfig;
import com.redhat.devtools.intellij.common.utils.ToolsConfigHelper;
import com.redhat.devtools.intellij.common.utils.UIHelper;
import com.twelvemonkeys.lang.Platform;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class DownloadHelper {
    private static final int BUFFER_SIZE = 4096;
    private static final UnaryOperator<InputStream> UNCOMPRESSOR = input -> {
        try {
            return new CompressorStreamFactory().createCompressorInputStream(input);
        }
        catch (CompressorException e) {
            throw new RuntimeException(e);
        }
    };
    private static final UnaryOperator<InputStream> UNTAR = TarArchiveInputStream::new;
    private static final UnaryOperator<InputStream> UNZIP = ZipArchiveInputStream::new;
    private static final Map<String, UnaryOperator<InputStream>> MAPPERS = new HashMap<String, UnaryOperator<InputStream>>();
    private static DownloadHelper INSTANCE;

    private DownloadHelper() {
    }

    public static DownloadHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DownloadHelper();
        }
        return INSTANCE;
    }

    private CompletableFuture<ToolInstance> downloadIfRequiredAsyncInner(String toolName, URL url) throws IOException {
        CompletableFuture<ToolInstance> result = new CompletableFuture<ToolInstance>();
        ToolsConfig config = ToolsConfigHelper.loadToolsConfig(url);
        ToolsConfig.Tool tool = config.getTools().get(toolName);
        if (tool == null) {
            throw new IOException("Tool " + toolName + " not found in config file " + url);
        }
        ToolsConfig.Platform platform = this.getPlatformBasedOnOs(tool);
        if (platform == null) {
            throw new IOException("Tool " + toolName + " not found in config file " + url);
        }
        String command = platform.getCmdFileName();
        String version = this.getVersionFromPath(tool, platform);
        if (!this.areCompatible(version, tool.getVersionMatchRegExpr())) {
            String replacement = Strings.isEmpty((String)CommonConstants.TOOLS_DOWNLOAD_PATH) ? CommonConstants.HOME_FOLDER : CommonConstants.TOOLS_DOWNLOAD_PATH;
            Path path = Paths.get(tool.getBaseDir().replace("$HOME", replacement), "cache", tool.getVersion(), command);
            String cmd = path.toString();
            if (!Files.exists(path, new LinkOption[0])) {
                result = this.downloadInBackground(toolName, platform, path, cmd, tool, version, platform.getSha256());
            } else {
                result.complete(new ToolInstance(cmd, false));
            }
        } else {
            result.complete(new ToolInstance(command, false));
        }
        return result;
    }

    private ToolsConfig.Platform getPlatformBasedOnOs(ToolsConfig.Tool tool) {
        String osArch = Platform.arch().toString();
        String osId = Platform.os().id();
        if (tool.getPlatforms().containsKey(osId + "-" + osArch)) {
            return tool.getPlatforms().get(osId + "-" + osArch);
        }
        return tool.getPlatforms().get(osId);
    }

    private CompletableFuture<ToolInstance> downloadInBackground(String toolName, ToolsConfig.Platform platform, Path path, String cmd, ToolsConfig.Tool tool, String version, String checksum) {
        CompletableFuture<ToolInstance> result = new CompletableFuture<ToolInstance>();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.downloadInBackgroundManager(toolName, platform, path, cmd, checksum, result);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (tool.isSilentMode() || this.isDownloadAllowed(toolName, version, tool.getVersion())) {
                    this.downloadInBackgroundManager(toolName, platform, path, cmd, checksum, result);
                } else {
                    result.complete(new ToolInstance(platform.getCmdFileName(), false));
                }
            });
        }
        return result;
    }

    private void downloadInBackgroundManager(final String toolName, final ToolsConfig.Platform platform, final Path path, final String cmd, final String checksum, final CompletableFuture<ToolInstance> result) {
        final Path dlFilePath = path.resolveSibling(platform.getDlFileName());
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, "Downloading " + toolName, false){

            public void run(@NotNull ProgressIndicator progressIndicator) {
                if (progressIndicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    HttpRequests.request((String)platform.getUrl().toString()).useProxy(true).connect(request -> {
                        DownloadHelper.downloadFile(request.getInputStream(), dlFilePath, progressIndicator, request.getConnection().getContentLength());
                        DownloadHelper.this.uncompress(dlFilePath, path);
                        if (checksum != null && !DownloadHelper.this.verify(dlFilePath, checksum)) {
                            throw new IOException("Failed to verify checksum for " + platform.getDlFileName());
                        }
                        return cmd;
                    });
                }
                catch (IOException e) {
                    result.completeExceptionally(new IOException("Error while setting tool " + toolName + ".", e));
                }
            }

            public void onFinished() {
                if (!result.isCompletedExceptionally()) {
                    result.complete(new ToolInstance(cmd, true));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/redhat/devtools/intellij/common/utils/DownloadHelper$1", "run"));
            }
        });
    }

    public ToolInstance downloadIfRequired(String toolName, URL url) throws IOException {
        CompletableFuture<ToolInstance> future = this.downloadIfRequiredAsyncInner(toolName, url);
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    public CompletableFuture<ToolInstance> downloadIfRequiredAsync(String toolName, URL url) {
        try {
            return this.downloadIfRequiredAsyncInner(toolName, url);
        }
        catch (IOException e) {
            CompletableFuture<ToolInstance> future = new CompletableFuture<ToolInstance>();
            future.completeExceptionally(e);
            return future;
        }
    }

    private boolean isDownloadAllowed(String tool, String currentVersion, String requiredVersion) {
        return UIHelper.executeInUI(() -> Messages.showYesNoCancelDialog((String)(StringUtil.isEmpty((String)currentVersion) ? tool + " not found , do you want to download " + tool + " " + requiredVersion + " ?" : tool + " " + currentVersion + " found, required version is " + requiredVersion + ", do you want to download " + tool + " ?"), (String)(tool + " tool required"), (Icon)Messages.getQuestionIcon()) == 0);
    }

    private boolean areCompatible(String version, String versionMatchRegExpr) {
        boolean compatible = true;
        if (!StringUtil.isEmptyOrSpaces((String)versionMatchRegExpr)) {
            Pattern pattern = Pattern.compile(versionMatchRegExpr);
            compatible = pattern.matcher(version).matches();
        } else if (StringUtil.isEmptyOrSpaces((String)version)) {
            compatible = false;
        }
        return compatible;
    }

    private String getVersionFromPath(ToolsConfig.Tool tool, ToolsConfig.Platform platform) {
        String version = "";
        try {
            Pattern pattern = Pattern.compile(tool.getVersionExtractRegExp());
            String[] arguments = tool.getVersionCmd().split(" ");
            String output = ExecHelper.execute(platform.getCmdFileName(), false, arguments);
            try (BufferedReader reader = new BufferedReader(new StringReader(output));){
                version = reader.lines().map(pattern::matcher).filter(Matcher::matches).map(matcher -> matcher.group(1)).findFirst().orElse("");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return version;
    }

    private static void downloadFile(InputStream input, Path dlFileName, ProgressIndicator progressIndicator, long size) throws IOException {
        byte[] buffer = new byte[4096];
        Files.createDirectories(dlFileName.getParent(), new FileAttribute[0]);
        try (OutputStream output = Files.newOutputStream(dlFileName, new OpenOption[0]);){
            int lg;
            long accumulated = 0L;
            while ((lg = input.read(buffer)) > 0 && !progressIndicator.isCanceled()) {
                output.write(buffer, 0, lg);
                progressIndicator.setFraction((double)(accumulated += (long)lg) / (double)size);
            }
        }
    }

    private InputStream mapStream(String filename, InputStream input) {
        String extension;
        while ((extension = FilenameUtils.getExtension((String)filename)) != null && MAPPERS.containsKey(extension)) {
            filename = FilenameUtils.removeExtension((String)filename);
            input = (InputStream)MAPPERS.get(extension).apply(input);
        }
        return input;
    }

    private void uncompress(Path dlFilePath, Path cmd) throws IOException {
        try (BufferedInputStream input = new BufferedInputStream(Files.newInputStream(dlFilePath, new OpenOption[0]));){
            InputStream subStream = this.mapStream(dlFilePath.toString(), input);
            if (subStream instanceof ArchiveInputStream) {
                ArchiveEntry entry;
                while ((entry = ((ArchiveInputStream)subStream).getNextEntry()) != null) {
                    this.save(subStream, cmd.resolveSibling(entry.getName()), entry.getSize());
                }
            } else {
                if (cmd.equals(dlFilePath)) {
                    cmd.toFile().setExecutable(true);
                    return;
                }
                this.save(subStream, cmd, -1L);
            }
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    private void save(InputStream source, Path destination, long length) throws IOException {
        try (OutputStream stream = Files.newOutputStream(destination, new OpenOption[0]);){
            if (length == -1L) {
                IOUtils.copy((InputStream)source, (OutputStream)stream);
            } else {
                IOUtils.copyLarge((InputStream)source, (OutputStream)stream, (long)0L, (long)length);
            }
        }
        destination.toFile().setExecutable(true);
    }

    private boolean verify(Path path, String checksum) throws IOException {
        boolean bl;
        block9: {
            InputStream stream = Files.newInputStream(path, new OpenOption[0]);
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                byte[] buffer = new byte[4096];
                int read = stream.read(buffer, 0, 4096);
                while (read > -1) {
                    digest.update(buffer, 0, read);
                    read = stream.read(buffer, 0, 4096);
                }
                bl = MessageDigest.isEqual(digest.digest(), Hex.decodeHex((String)checksum));
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchAlgorithmException | DecoderException e) {
                    throw new IOException("Could not verify checksum for file " + path, e);
                }
            }
            stream.close();
        }
        return bl;
    }

    static {
        MAPPERS.put("gz", UNCOMPRESSOR);
        MAPPERS.put("zip", UNZIP);
        MAPPERS.put("tar", UNTAR);
    }

    public static class ToolInstance {
        private final String command;
        private final boolean isDownloaded;

        public ToolInstance(String command, boolean isDownloaded) {
            this.command = command;
            this.isDownloaded = isDownloaded;
        }

        public String getCommand() {
            return this.command;
        }

        public boolean isDownloaded() {
            return this.isDownloaded;
        }
    }
}

