/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeConfigEnvValue {
    private static final String KUBECONFIG_KEY = "KUBECONFIG";
    private static final Logger LOGGER = LoggerFactory.getLogger(KubeConfigEnvValue.class);

    private KubeConfigEnvValue() {
    }

    public static void copyToSystem() {
        if (!SystemInfo.isMac) {
            return;
        }
        String current = System.getProperty(KUBECONFIG_KEY);
        if (!StringUtil.isEmpty((String)current)) {
            LOGGER.info("Current KUBECONFIG value is " + current + ".");
            return;
        }
        String shellValue = EnvironmentUtil.getValue((String)KUBECONFIG_KEY);
        if (StringUtil.isEmpty((String)shellValue)) {
            return;
        }
        LOGGER.info("Copying KUBECONFIG value " + shellValue + " from shell to System.");
        System.getProperties().put(KUBECONFIG_KEY, shellValue);
        System.getProperties().put(KUBECONFIG_KEY.toLowerCase(), shellValue);
    }
}

