/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.devtools.intellij.common.utils.YAMLHelper;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataClutter {
    private static final Logger logger = LoggerFactory.getLogger(MetadataClutter.class);
    public static final List<String> properties = Arrays.asList("clusterName", "creationTimestamp", "deletionGracePeriodSeconds", "deletionTimestamp", "finalizers", "generation", "managedFields", "ownerReferences", "resourceVersion", "selfLink", "uid");
    private static final List<Consumer<ObjectMeta>> setters = Arrays.asList(metadata -> {
        if (metadata.getAdditionalProperties() != null) {
            metadata.getAdditionalProperties().remove("clusterName");
        }
    }, metadata -> metadata.setCreationTimestamp(null), metadata -> metadata.setDeletionGracePeriodSeconds(null), metadata -> metadata.setDeletionTimestamp(null), metadata -> metadata.setFinalizers(Collections.emptyList()), metadata -> metadata.setGeneration(null), metadata -> metadata.setManagedFields(Collections.emptyList()), metadata -> metadata.setOwnerReferences(Collections.emptyList()), metadata -> metadata.setResourceVersion(null), metadata -> metadata.setSelfLink(null), metadata -> metadata.setUid(null));
    private static final String PROPERTY_METADATA = "metadata";

    public static String remove(String resource) {
        return MetadataClutter.remove(resource, true);
    }

    public static String remove(String resource, boolean minimizeQuotes) {
        if (resource == null || resource.isEmpty()) {
            return resource;
        }
        try {
            ObjectNode metadata;
            ObjectNode contentNode = (ObjectNode)YAMLHelper.YAMLToJsonNode(resource);
            ObjectNode objectNode = metadata = contentNode.has(PROPERTY_METADATA) ? (ObjectNode)contentNode.get(PROPERTY_METADATA) : null;
            if (metadata != null) {
                metadata.remove(properties);
                contentNode.set(PROPERTY_METADATA, (JsonNode)metadata);
                resource = YAMLHelper.JSONToYAML((JsonNode)contentNode, minimizeQuotes);
            }
        }
        catch (IOException e) {
            logger.warn(e.getLocalizedMessage(), (Throwable)e);
        }
        return resource;
    }

    public static ObjectMeta remove(ObjectMeta metadata) {
        if (metadata == null) {
            return null;
        }
        setters.forEach(consumer -> consumer.accept(metadata));
        return metadata;
    }
}

