/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YAMLHelper {
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final Pattern PATTERN_PROPERTY = Pattern.compile("(\\w+)(\\[(\\d)\\])*");

    public static String getStringValueFromYAML(String yamlAsString, String[] path) throws IOException {
        JsonNode nodeValue = YAMLHelper.getValueFromYAML(yamlAsString, path);
        if (nodeValue == null || !nodeValue.isTextual()) {
            return null;
        }
        return nodeValue.asText();
    }

    public static JsonNode getValueFromYAML(String yamlAsString, String[] path) throws IOException {
        if (yamlAsString == null) {
            return null;
        }
        JsonNode node = YAML_MAPPER.readTree(yamlAsString);
        Pattern arrayPattern = Pattern.compile("(\\w+)(\\[(\\d)\\])*");
        for (String field : path) {
            Property property = YAMLHelper.createProperty(field, node);
            if (!property.existsIn(node)) {
                return null;
            }
            node = property.getNodeIn(node);
        }
        return node;
    }

    public static String JSONToYAML(JsonNode json) throws IOException {
        return YAMLHelper.JSONToYAML(json, true);
    }

    public static String JSONToYAML(JsonNode json, boolean minimizeQuotes) throws IOException {
        if (json == null) {
            return "";
        }
        try {
            return new YAMLMapper().configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false).configure(YAMLGenerator.Feature.MINIMIZE_QUOTES, minimizeQuotes).writeValueAsString((Object)json);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    public static JsonNode YAMLToJsonNode(String yaml) throws IOException {
        return YAML_MAPPER.readTree(yaml);
    }

    public static JsonNode URLToJSON(URL file) throws IOException {
        if (file == null) {
            return null;
        }
        return YAML_MAPPER.readTree(file);
    }

    public static JsonNode editValueInYAML(String yamlAsString, String[] fieldnames, String value) throws IOException {
        JsonNode node;
        if (yamlAsString == null) {
            return null;
        }
        JsonNode tmpNode = node = YAML_MAPPER.readTree(yamlAsString);
        for (int i = 0; i < fieldnames.length; ++i) {
            Property property = YAMLHelper.createProperty(fieldnames[i], tmpNode);
            if (!property.existsIn(tmpNode)) {
                return null;
            }
            if (i == fieldnames.length - 1) {
                ((ObjectNode)tmpNode).put(fieldnames[i], value);
                continue;
            }
            tmpNode = property.getNodeIn(tmpNode);
        }
        return node;
    }

    public static JsonNode addLabelToResource(String yaml, String labelKey, String labelValue) throws IOException {
        ObjectNode resource = (ObjectNode)YAMLHelper.YAMLToJsonNode(yaml);
        ObjectNode metadata = !resource.has("metadata") ? YAML_MAPPER.createObjectNode() : (ObjectNode)resource.get("metadata");
        if (!metadata.has("labels")) {
            ObjectNode newLabel = YAML_MAPPER.createObjectNode();
            newLabel.put(labelKey, labelValue);
            metadata.set("labels", (JsonNode)newLabel);
        } else if (!metadata.get("labels").has(labelKey)) {
            ((ObjectNode)metadata.get("labels")).put(labelKey, labelValue);
        }
        resource.set("metadata", (JsonNode)metadata);
        return resource;
    }

    public static JsonNode removeLabelFromResource(String yaml, String labelKey) throws IOException {
        ObjectNode resource = (ObjectNode)YAMLHelper.YAMLToJsonNode(yaml);
        ObjectNode metadata = !resource.has("metadata") ? YAML_MAPPER.createObjectNode() : (ObjectNode)resource.get("metadata");
        if (metadata.has("labels") && metadata.get("labels").has(labelKey)) {
            ((ObjectNode)metadata.get("labels")).remove(labelKey);
            if (metadata.get("labels").size() == 0) {
                metadata.remove("labels");
            }
        }
        resource.set("metadata", (JsonNode)metadata);
        return resource;
    }

    private static Property createProperty(String name, JsonNode node) {
        Property property = null;
        Matcher match = PATTERN_PROPERTY.matcher(name);
        property = match.matches() && match.group(3) != null ? new ArrayProperty(match.group(1), Integer.parseInt(match.group(3))) : new Property(name);
        return property;
    }

    private static class Property {
        protected final String name;

        Property(String name) {
            this.name = name;
        }

        public boolean existsIn(JsonNode node) {
            return node != null && node.has(this.name);
        }

        public JsonNode getNodeIn(JsonNode node) {
            if (node == null) {
                return null;
            }
            return node.get(this.name);
        }

        public String getName() {
            return this.name;
        }
    }

    private static class ArrayProperty
    extends Property {
        private final int index;

        ArrayProperty(String name, int index) {
            super(name);
            this.index = index;
        }

        @Override
        public boolean existsIn(JsonNode node) {
            return node != null && node.get(this.name) != null && node.get(this.name).get(this.index) != null;
        }

        @Override
        public JsonNode getNodeIn(JsonNode node) {
            if (node == null || node.get(this.name) == null) {
                return null;
            }
            return node.get(this.name).get(this.index);
        }
    }
}

