/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.validation;

import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.redhat.devtools.intellij.common.validation.KubernetesTypeInfo;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLValue;

public class KubernetesResourceInfo {
    private static final String KEY_METADATA = "metadata";
    private static final String KEY_NAME = "name";
    private static final String KEY_NAMESPACE = "namespace";
    private String name;
    private String namespace;
    private KubernetesTypeInfo typeInfo;

    KubernetesResourceInfo(String name, String namespace, KubernetesTypeInfo info) {
        this.name = name;
        this.namespace = namespace;
        this.typeInfo = info;
    }

    private KubernetesResourceInfo() {
    }

    public static KubernetesResourceInfo create(PsiFile file) {
        KubernetesResourceInfo resourceInfo = new KubernetesResourceInfo();
        if (file instanceof JsonFile) {
            KubernetesResourceInfo.create((JsonFile)file, resourceInfo);
        } else if (file instanceof YAMLFile) {
            KubernetesResourceInfo.create((YAMLFile)file, resourceInfo);
        }
        resourceInfo.setTypeInfo(KubernetesTypeInfo.create(file));
        return resourceInfo;
    }

    private static void create(JsonFile file, KubernetesResourceInfo resourceInfo) {
        JsonValue content = file.getTopLevelValue();
        if (content == null) {
            return;
        }
        content.acceptChildren((PsiElementVisitor)new ResourceVisitor(resourceInfo));
    }

    private static void create(YAMLFile file, KubernetesResourceInfo resourceInfo) {
        if (file.getDocuments().isEmpty()) {
            return;
        }
        KubernetesResourceInfo.create((YAMLDocument)file.getDocuments().get(0), resourceInfo);
    }

    private static void create(YAMLDocument document, KubernetesResourceInfo resourceInfo) {
        if (document == null) {
            return;
        }
        YAMLValue content = document.getTopLevelValue();
        if (content == null) {
            return;
        }
        content.acceptChildren((PsiElementVisitor)new ResourceVisitor(resourceInfo));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    private void setTypeInfo(KubernetesTypeInfo typeInfo) {
        this.typeInfo = typeInfo;
    }

    public String getApiGroup() {
        if (this.typeInfo == null) {
            return null;
        }
        return this.typeInfo.getApiGroup();
    }

    public String getKind() {
        if (this.typeInfo == null) {
            return null;
        }
        return this.typeInfo.getKind();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KubernetesResourceInfo that = (KubernetesResourceInfo)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.typeInfo, that.typeInfo);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.namespace, this.typeInfo);
    }

    public String toString() {
        return this.name + ", " + this.namespace;
    }

    private static class ResourceVisitor
    extends PsiElementVisitor {
        private final KubernetesResourceInfo info;

        private ResourceVisitor(KubernetesResourceInfo info) {
            this.info = info;
        }

        public void visitElement(@NotNull PsiElement element) {
            PsiElement value;
            if (element == null) {
                ResourceVisitor.$$$reportNull$$$0(0);
            }
            if (!(element instanceof PsiNamedElement)) {
                return;
            }
            PsiNamedElement namedElement = (PsiNamedElement)element;
            if (KubernetesResourceInfo.KEY_METADATA.equals(namedElement.getName()) && (value = this.getValue(namedElement)) != null) {
                value.acceptChildren(this.visitMetadata());
            }
        }

        @Nullable
        private PsiElement getValue(PsiNamedElement namedElement) {
            if (namedElement instanceof JsonProperty) {
                return ((JsonProperty)namedElement).getValue();
            }
            if (namedElement instanceof YAMLKeyValue) {
                return ((YAMLKeyValue)namedElement).getValue();
            }
            return null;
        }

        @NotNull
        private PsiElementVisitor visitMetadata() {
            return new PsiElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!(element instanceof PsiNamedElement)) {
                        return;
                    }
                    PsiNamedElement namedElement = (PsiNamedElement)element;
                    if (KubernetesResourceInfo.KEY_NAME.equals(namedElement.getName())) {
                        this.setName((PsiElement)namedElement);
                    } else if (KubernetesResourceInfo.KEY_NAMESPACE.equals(namedElement.getName())) {
                        this.setNamespace((PsiElement)namedElement);
                    }
                }

                private void setName(PsiElement element) {
                    if (element instanceof JsonProperty) {
                        info.setName(this.valueOrNull((JsonProperty)element));
                    } else if (element instanceof YAMLKeyValue) {
                        info.setName(this.valueOrNull((YAMLKeyValue)element));
                    }
                }

                private void setNamespace(PsiElement element) {
                    if (element instanceof JsonProperty) {
                        info.setNamespace(this.valueOrNull((JsonProperty)element));
                    } else if (element instanceof YAMLKeyValue) {
                        info.setNamespace(this.valueOrNull((YAMLKeyValue)element));
                    }
                }

                private String valueOrNull(JsonProperty property) {
                    return property.getValue() != null ? property.getValue().getText() : null;
                }

                private String valueOrNull(YAMLKeyValue key) {
                    return key.getValueText();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/redhat/devtools/intellij/common/validation/KubernetesResourceInfo$ResourceVisitor$1", "visitElement"));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/redhat/devtools/intellij/common/validation/KubernetesResourceInfo$ResourceVisitor", "visitElement"));
        }
    }
}

