/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.validation;

import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLValue;

public class KubernetesTypeInfo {
    private static final String KEY_API_VERSION = "apiVersion";
    private static final String KEY_KIND = "kind";
    private String apiGroup = "";
    private String kind = "";

    public KubernetesTypeInfo(String apiGroup, String kind) {
        this.apiGroup = apiGroup;
        this.kind = kind;
    }

    public KubernetesTypeInfo() {
    }

    public static KubernetesTypeInfo create(PsiFile file) {
        if (file instanceof JsonFile) {
            return KubernetesTypeInfo.create((JsonFile)file);
        }
        if (file instanceof YAMLFile) {
            return KubernetesTypeInfo.create((YAMLFile)file);
        }
        return null;
    }

    private static KubernetesTypeInfo create(JsonFile file) {
        JsonKubernetesTypeInfoVisitor collector = new JsonKubernetesTypeInfoVisitor();
        JsonValue content = file.getTopLevelValue();
        if (content != null) {
            content.acceptChildren((PsiElementVisitor)collector);
        }
        return collector.getKubernetesTypeInfo();
    }

    private static KubernetesTypeInfo create(YAMLFile file) {
        if (file == null || file.getDocuments().isEmpty()) {
            return null;
        }
        return KubernetesTypeInfo.create((YAMLDocument)file.getDocuments().get(0));
    }

    static List<KubernetesTypeInfo> createTypes(YAMLFile file) {
        if (file == null || file.getDocuments().isEmpty()) {
            return null;
        }
        return file.getDocuments().stream().map(KubernetesTypeInfo::create).toList();
    }

    public static KubernetesTypeInfo create(YAMLDocument document) {
        YAMLValue content;
        YAMLKubernetesTypeInfoVisitor collector = new YAMLKubernetesTypeInfoVisitor();
        if (document != null && (content = document.getTopLevelValue()) != null) {
            content.acceptChildren((PsiElementVisitor)collector);
        }
        return collector.getKubernetesTypeInfo();
    }

    public String getApiGroup() {
        return this.apiGroup;
    }

    public void setApiGroup(String apiGroup) {
        this.apiGroup = apiGroup;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KubernetesTypeInfo that = (KubernetesTypeInfo)o;
        return Objects.equals(this.apiGroup, that.apiGroup) && Objects.equals(this.kind, that.kind);
    }

    public int hashCode() {
        return Objects.hash(this.apiGroup, this.kind);
    }

    public String toString() {
        return this.apiGroup + "#" + this.kind;
    }

    public static KubernetesTypeInfo fromFileName(String filename) {
        int index = filename.indexOf(95);
        String apiGroup = index != -1 ? filename.substring(0, index) : "";
        String kind = index != -1 ? filename.substring(index + 1) : filename;
        index = kind.lastIndexOf(46);
        kind = index != -1 ? kind.substring(0, index) : kind;
        return new KubernetesTypeInfo(apiGroup, kind);
    }

    static class JsonKubernetesTypeInfoVisitor
    extends KubernetesTypeInfoVisitor {
        JsonKubernetesTypeInfoVisitor() {
        }

        public void visitElement(@NotNull PsiElement element) {
            JsonProperty property;
            if (element == null) {
                JsonKubernetesTypeInfoVisitor.$$$reportNull$$$0(0);
            }
            if (element instanceof JsonProperty && (property = (JsonProperty)element).getValue() != null && property.getValue().getText() != null) {
                String value = StringUtil.unquoteString((String)property.getValue().getText());
                if (property.getName().equals(KubernetesTypeInfo.KEY_API_VERSION)) {
                    this.setApiGroup(value);
                } else if (property.getName().equals(KubernetesTypeInfo.KEY_KIND)) {
                    this.setKind(value);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/redhat/devtools/intellij/common/validation/KubernetesTypeInfo$JsonKubernetesTypeInfoVisitor", "visitElement"));
        }
    }

    static class YAMLKubernetesTypeInfoVisitor
    extends KubernetesTypeInfoVisitor {
        YAMLKubernetesTypeInfoVisitor() {
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                YAMLKubernetesTypeInfoVisitor.$$$reportNull$$$0(0);
            }
            if (element instanceof YAMLKeyValue) {
                YAMLKeyValue property = (YAMLKeyValue)element;
                String value = StringUtil.unquoteString((String)property.getValueText());
                if (property.getKeyText().equals(KubernetesTypeInfo.KEY_API_VERSION)) {
                    this.setApiGroup(value);
                } else if (property.getKeyText().equals(KubernetesTypeInfo.KEY_KIND)) {
                    this.setKind(value);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/redhat/devtools/intellij/common/validation/KubernetesTypeInfo$YAMLKubernetesTypeInfoVisitor", "visitElement"));
        }
    }

    private static abstract class KubernetesTypeInfoVisitor
    extends PsiElementVisitor {
        private KubernetesTypeInfo info = null;

        private KubernetesTypeInfoVisitor() {
        }

        protected void setApiGroup(String apiGroup) {
            this.existingOrCreate().setApiGroup(apiGroup);
        }

        protected void setKind(String kind) {
            this.existingOrCreate().setKind(kind);
        }

        private KubernetesTypeInfo existingOrCreate() {
            if (this.info == null) {
                this.info = new KubernetesTypeInfo();
            }
            return this.info;
        }

        public KubernetesTypeInfo getKubernetesTypeInfo() {
            return this.info;
        }
    }
}

