/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.validation;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.redhat.devtools.intellij.common.validation.KubernetesTypeInfo;
import com.redhat.devtools.intellij.common.validation.SchemaProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemasProviderFactory
implements JsonSchemaProviderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemasProviderFactory.class);
    private List<SchemaProvider> providers = new ArrayList<SchemaProvider>();

    public SchemasProviderFactory() {
        this.load();
    }

    private void load() {
        block13: {
            try (InputStream list = SchemasProviderFactory.class.getResourceAsStream("/schemas/index.properties");){
                if (list == null) break block13;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(list, StandardCharsets.UTF_8));){
                    reader.lines().filter(line -> !StringUtil.isEmptyOrSpaces((String)line)).forEach(this::loadSchema);
                }
            }
            catch (IOException e) {
                LOGGER.warn(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private void loadSchema(String schema) {
        URL url = SchemasProviderFactory.class.getResource("/schemas/" + schema);
        if (url != null) {
            KubernetesTypeInfo info = KubernetesTypeInfo.fromFileName(schema);
            VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(VfsUtil.convertFromUrl((URL)url));
            this.providers.add(new SchemaProvider(info, file));
        }
    }

    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        if (project == null) {
            SchemasProviderFactory.$$$reportNull$$$0(0);
        }
        List<JsonSchemaFileProvider> list = this.providers.stream().map(provider -> provider.withProject(project)).collect(Collectors.toList());
        if (list == null) {
            SchemasProviderFactory.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/redhat/devtools/intellij/common/validation/SchemasProviderFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/redhat/devtools/intellij/common/validation/SchemasProviderFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProviders";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

