/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fuse.eap.config;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.wildfly.extras.config.ConfigContext;
import org.wildfly.extras.config.ConfigPlugin;
import org.wildfly.extras.config.ConfigSupport;
import org.wildfly.extras.config.LayerConfig;
import org.wildfly.extras.config.NamespaceRegistry;

public class SwitchyardConfigPlugin
implements ConfigPlugin {
    public static final String NS_SWITCHYARD = "urn:jboss:domain:switchyard";
    private NamespaceRegistry registry;

    public SwitchyardConfigPlugin() {
        this.registerNamespaceVersions(new NamespaceRegistry());
    }

    public SwitchyardConfigPlugin(NamespaceRegistry registry) {
        this.registerNamespaceVersions(registry);
    }

    public String getConfigName() {
        return "switchyard";
    }

    public List<LayerConfig> getLayerConfigs() {
        return Arrays.asList(new LayerConfig("fuse", LayerConfig.Type.INSTALLING, -10), new LayerConfig("bpms", LayerConfig.Type.OPTIONAL, -9), new LayerConfig("soa", LayerConfig.Type.INSTALLING, -8));
    }

    public void applyStandaloneConfigChange(ConfigContext context, boolean enable) {
        String fileName = context.getConfiguration().getFileName().toString();
        this.updateExtension(context, enable);
        this.updateLogging(context, enable);
        this.updateSecurityDomain(context, enable);
        this.updateSubsystem(context, enable);
        if (fileName.contains("-ha")) {
            this.updateInfinispan(true, context);
        }
    }

    public void applyDomainConfigChange(ConfigContext context, boolean enable) {
        this.applyStandaloneConfigChange(context, enable);
        this.updateInfinispan(enable, context);
    }

    private void updateExtension(ConfigContext context, boolean enable) {
        Namespace[] domainNamespaces = this.registry.getNamespaces("urn:jboss:domain");
        Element extensions = ConfigSupport.findChildElement((Element)context.getDocument().getRootElement(), (String)"extensions", (Namespace[])domainNamespaces);
        ConfigSupport.assertExists((Element)extensions, (String)"Did not find the <extensions> element");
        Element element = ConfigSupport.findElementWithAttributeValue((Element)extensions, (String)"extension", (String)"module", (String)"org.switchyard", (Namespace[])domainNamespaces);
        Namespace domainNamespace = context.getDocument().getRootElement().getNamespace();
        if (enable && element == null) {
            extensions.addContent((Content)new Text("    "));
            extensions.addContent((Content)new Element("extension", domainNamespace).setAttribute("module", "org.switchyard"));
            extensions.addContent((Content)new Text("\n    "));
        }
        if (!enable && element != null) {
            element.getParentElement().removeContent((Content)element);
        }
    }

    private void updateLogging(ConfigContext context, boolean enable) {
        Namespace[] domainNamespaces = this.registry.getNamespaces("urn:jboss:domain");
        Namespace[] loggingNamespaces = this.registry.getNamespaces("urn:jboss:domain:logging");
        List profiles = ConfigSupport.findProfileElements((Document)context.getDocument(), (Namespace[])domainNamespaces);
        for (Element profile : profiles) {
            URL resource;
            Element logging = ConfigSupport.findChildElement((Element)profile, (String)"subsystem", (Namespace[])loggingNamespaces);
            ConfigSupport.assertExists((Element)logging, (String)"Did not find the logging subsystem");
            Element element = ConfigSupport.findElementWithAttributeValue((Element)logging, (String)"logger", (String)"category", (String)"org.switchyard", (Namespace[])loggingNamespaces);
            if (enable && element == null) {
                resource = SwitchyardConfigPlugin.class.getResource("/logger-switchyard.xml");
                logging.addContent((Content)new Text("    "));
                logging.addContent((Content)ConfigSupport.loadElementFrom((URL)resource));
                logging.addContent((Content)new Text("\n    "));
            }
            if (!enable && element != null) {
                element.getParentElement().removeContent((Content)element);
            }
            element = ConfigSupport.findElementWithAttributeValue((Element)logging, (String)"logger", (String)"category", (String)"org.apache.deltaspike.core.api.provider.BeanManagerProvider", (Namespace[])loggingNamespaces);
            if (enable && element == null) {
                resource = SwitchyardConfigPlugin.class.getResource("/logger-deltaspike.xml");
                logging.addContent((Content)new Text("    "));
                logging.addContent((Content)ConfigSupport.loadElementFrom((URL)resource));
                logging.addContent((Content)new Text("\n    "));
            }
            if (enable || element == null) continue;
            element.getParentElement().removeContent((Content)element);
        }
    }

    private void updateSubsystem(ConfigContext context, boolean enable) {
        Namespace[] domainNamespaces = this.registry.getNamespaces("urn:jboss:domain");
        Namespace[] switchYardNamespaces = this.registry.getNamespaces(NS_SWITCHYARD);
        List profiles = ConfigSupport.findProfileElements((Document)context.getDocument(), (Namespace[])domainNamespaces);
        for (Element profile : profiles) {
            Element element = ConfigSupport.findChildElement((Element)profile, (String)"subsystem", (Namespace[])switchYardNamespaces);
            if (enable && element == null) {
                URL resource = SwitchyardConfigPlugin.class.getResource("/switchyard-subsystem.xml");
                profile.addContent((Content)new Text("    "));
                profile.addContent((Content)ConfigSupport.loadElementFrom((URL)resource));
                profile.addContent((Content)new Text("\n    "));
            }
            if (enable || element == null) continue;
            element.getParentElement().removeContent((Content)element);
        }
    }

    private void updateSecurityDomain(ConfigContext context, boolean enable) {
        Namespace[] domainNamespaces = this.registry.getNamespaces("urn:jboss:domain");
        Namespace[] securityNamespaces = this.registry.getNamespaces("urn:jboss:domain:security");
        List profiles = ConfigSupport.findProfileElements((Document)context.getDocument(), (Namespace[])domainNamespaces);
        for (Element profile : profiles) {
            Element security = ConfigSupport.findChildElement((Element)profile, (String)"subsystem", (Namespace[])securityNamespaces);
            ConfigSupport.assertExists((Element)security, (String)"Did not find the security subsystem");
            Element domains = ConfigSupport.findChildElement((Element)security, (String)"security-domains", (Namespace[])securityNamespaces);
            ConfigSupport.assertExists((Element)domains, (String)"Did not find the <security-domains> element");
            Element domain = ConfigSupport.findElementWithAttributeValue((Element)domains, (String)"security-domain", (String)"name", (String)"bpel-console", (Namespace[])securityNamespaces);
            if (enable && domain == null) {
                URL resource = SwitchyardConfigPlugin.class.getResource("/bpel-console-security-domain.xml");
                domains.addContent((Content)new Text("    "));
                domains.addContent((Content)ConfigSupport.loadElementFrom((URL)resource));
                domains.addContent((Content)new Text("\n            "));
            }
            if (enable || domain == null) continue;
            domain.getParentElement().removeContent((Content)domain);
        }
    }

    private void updateInfinispan(boolean enable, ConfigContext context) {
        Namespace[] domainNamespaces = this.registry.getNamespaces("urn:jboss:domain");
        Namespace[] infinispanNamespaces = this.registry.getNamespaces("urn:jboss:domain:infinispan");
        List profiles = ConfigSupport.findProfileElements((Document)context.getDocument(), (Namespace[])domainNamespaces);
        for (Element profile : profiles) {
            Element infinispan = ConfigSupport.findChildElement((Element)profile, (String)"subsystem", (Namespace[])infinispanNamespaces);
            ConfigSupport.assertExists((Element)infinispan, (String)"Did not find the cache subsystem");
            Element element = ConfigSupport.findElementWithAttributeValue((Element)infinispan, (String)"cache-container", (String)"name", (String)"switchyard", (Namespace[])infinispanNamespaces);
            if (enable && element == null) {
                URL resource = SwitchyardConfigPlugin.class.getResource("/switchyard-cache-container.xml");
                infinispan.addContent((Content)new Text("    "));
                infinispan.addContent((Content)ConfigSupport.loadElementFrom((URL)resource));
                infinispan.addContent((Content)new Text("\n    "));
            }
            if (enable || element == null) continue;
            element.getParentElement().removeContent((Content)element);
        }
    }

    private void registerNamespaceVersions(NamespaceRegistry registry) {
        this.registry = registry;
        registry.registerNamespace("urn:jboss:domain", "1.8");
        registry.registerNamespace("urn:jboss:domain", "1.7");
        registry.registerNamespace("urn:jboss:domain:infinispan", "1.5");
        registry.registerNamespace("urn:jboss:domain:logging", "1.5");
        registry.registerNamespace("urn:jboss:domain:security", "1.2");
        registry.registerNamespace(NS_SWITCHYARD, "1.0");
    }
}

