package com.redhat.gss.redhat_support_lib.infrastructure;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.core.MultivaluedMap;

import org.apache.log4j.Logger;

import com.redhat.gss.redhat_support_lib.api.API;
import com.redhat.gss.redhat_support_lib.errors.RequestException;
import com.redhat.gss.redhat_support_lib.helpers.FilterHelper;
import com.redhat.gss.redhat_support_lib.helpers.QueryBuilder;
import com.redhat.gss.redhat_support_lib.parsers.Solution;
import com.redhat.gss.redhat_support_lib.web.ConnectionManager;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;

public class Solutions extends BaseQuery {
	private final static Logger LOGGER = Logger.getLogger(API.class.getName());
	ConnectionManager connectionManager = null;
	static String url = "/rs/solutions/";

	public Solutions(ConnectionManager connectionManager) {
		this.connectionManager = connectionManager;
	}

	/**
	 * Queries the API for the given solution ID. RESTful method:
	 * https://api.access.redhat.com/rs/solutions/<solutionID>
	 * 
	 * @param solNum
	 *            The exact solutionID you are interested in.
	 * @return A solution object that represents the given solution ID.
	 * @throws RequestException
	 *             An exception if there was a connection related issue.
	 * @throws MalformedURLException 
	 */
	public Solution get(String solNum) throws RequestException, MalformedURLException {

		WebResource webResource = connectionManager.getConnection().resource(
				connectionManager.getConfig().getUrl() + url + solNum);
		return get(webResource, Solution.class);
	}

	/**
	 * Queries the solutions RESTful interface with a given set of keywords.
	 * RESTful method: https://api.access.redhat.com/rs/solutions?keyword=NFS
	 * 
	 * @param keywords
	 *            A String array of keywords to search on.
	 * @param kwargs
	 *            Additional properties to filter on. The RESTful interface can
	 *            only search on keywords; however, you can use this method to
	 *            post-filter the results returned. Simply supply a String array
	 *            of valid properties and their associated values.
	 * @return A list of solution objects
	 * @throws RequestException
	 *             An exception if there was a connection related issue.
	 * @throws MalformedURLException 
	 */
	public List<Solution> list(String[] keywords, String[] kwargs)
			throws RequestException, MalformedURLException {

		List<String> queryParams = new ArrayList<String>();
		for (String keyword : keywords) {
			queryParams.add("keyword=" + keyword);
		}
		WebResource webResource = connectionManager.getConnection().resource(
				QueryBuilder.appendQuery(connectionManager.getConfig().getUrl()
						+ url, queryParams));
		com.redhat.gss.redhat_support_lib.parsers.Solutions solutions = get(webResource,
				com.redhat.gss.redhat_support_lib.parsers.Solutions.class);
		return (List<Solution>) FilterHelper.filterResults(
				solutions.getSolution(), kwargs);
	}

	/**
	 * Add a new solution
	 * 
	 * @param sol
	 *            The solution to be added.
	 * @return The same solution with the ID and view_uri set if successful.
	 * @throws Exception
	 *             An exception if there was a connection, file open, etc.
	 *             issue.
	 */
	public Solution add(Solution sol) throws Exception {
		// TODO: Test once implemented

		WebResource webResource = connectionManager.getConnection().resource(
				connectionManager.getConfig().getUrl() + url);
		ClientResponse resp = add(webResource, sol);
		MultivaluedMap<String, String> headers = resp.getHeaders();
		URL url = null;
		try {
			url = new URL(headers.getFirst("view-uri"));
		} catch (MalformedURLException e) {
			LOGGER.debug("Failed : Adding solution " + sol.getTitle()
					+ " was unsuccessful.");
			throw new Exception();
		}
		String path = url.getPath();
		sol.setId(path.substring(path.lastIndexOf('/') + 1, path.length()));
		sol.setViewUri(url.toString());
		return sol;
	}
}
