/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.redhat_support_lib.infrastructure;

import com.redhat.gss.redhat_support_lib.api.API;
import com.redhat.gss.redhat_support_lib.errors.RequestException;
import com.redhat.gss.redhat_support_lib.helpers.FilterHelper;
import com.redhat.gss.redhat_support_lib.helpers.QueryBuilder;
import com.redhat.gss.redhat_support_lib.infrastructure.BaseQuery;
import com.redhat.gss.redhat_support_lib.parsers.Article;
import com.redhat.gss.redhat_support_lib.web.ConnectionManager;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Articles
extends BaseQuery {
    private static final Logger LOGGER = Logger.getLogger((String)API.class.getName());
    ConnectionManager connectionManager = null;
    static String url = "/rs/articles/";

    public Articles(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Article get(String artID) throws RequestException, MalformedURLException {
        WebResource webResource = this.connectionManager.getConnection().resource(String.valueOf(this.connectionManager.getConfig().getUrl()) + url + artID);
        return this.get(webResource, Article.class);
    }

    public List<Article> list(String[] keywords, String[] kwargs) throws RequestException, MalformedURLException {
        ArrayList<String> queryParams = new ArrayList<String>();
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            queryParams.add("keyword=" + arg);
            ++n2;
        }
        WebResource webResource = this.connectionManager.getConnection().resource(QueryBuilder.appendQuery(String.valueOf(this.connectionManager.getConfig().getUrl()) + url, queryParams));
        com.redhat.gss.redhat_support_lib.parsers.Articles articles = this.get(webResource, com.redhat.gss.redhat_support_lib.parsers.Articles.class);
        return FilterHelper.filterResults(articles.getArticle(), kwargs);
    }

    public Article add(Article art) throws Exception {
        WebResource webResource = this.connectionManager.getConnection().resource(String.valueOf(this.connectionManager.getConfig().getUrl()) + url);
        ClientResponse resp = this.add(webResource, art);
        MultivaluedMap headers = resp.getHeaders();
        URL url = null;
        try {
            url = new URL((String)headers.getFirst((Object)"view-uri"));
        }
        catch (MalformedURLException e) {
            LOGGER.debug((Object)("Failed : Adding article " + art.getTitle() + " was unsuccessful."));
            throw new Exception();
        }
        String path = url.getPath();
        art.setId(path.substring(path.lastIndexOf(47) + 1, path.length()));
        art.setViewUri(url.toString());
        return art;
    }
}

