/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.redhat_support_lib.infrastructure;

import com.redhat.gss.redhat_support_lib.errors.RequestException;
import com.redhat.gss.redhat_support_lib.helpers.FilterHelper;
import com.redhat.gss.redhat_support_lib.infrastructure.BaseQuery;
import com.redhat.gss.redhat_support_lib.parsers.Product;
import com.redhat.gss.redhat_support_lib.parsers.Versions;
import com.redhat.gss.redhat_support_lib.web.ConnectionManager;
import com.sun.jersey.api.client.WebResource;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Products
extends BaseQuery {
    ConnectionManager connectionManager = null;

    public Products(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public List<Product> list(String[] kwargs) throws RequestException, MalformedURLException {
        String url = "/rs/products/";
        WebResource webResource = this.connectionManager.getConnection().resource(String.valueOf(this.connectionManager.getConfig().getUrl()) + url);
        com.redhat.gss.redhat_support_lib.parsers.Products prods = this.get(webResource, com.redhat.gss.redhat_support_lib.parsers.Products.class);
        return FilterHelper.filterResults(prods.getProduct(), kwargs);
    }

    public List<String> getVersions(String prodName) throws RequestException, MalformedURLException, UnsupportedEncodingException {
        String url = "/rs/products/{prodName}/versions";
        prodName = URLEncoder.encode(prodName, "UTF-8").replace("+", "%20");
        url = url.replace("{prodName}", prodName);
        WebResource webResource = this.connectionManager.getConnection().resource(String.valueOf(this.connectionManager.getConfig().getUrl()) + url);
        Versions vers = this.get(webResource, Versions.class);
        return vers.getVersion();
    }
}

