/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.redhat_support_lib.infrastructure;

import com.redhat.gss.redhat_support_lib.errors.FTPException;
import com.redhat.gss.redhat_support_lib.errors.RequestException;
import com.redhat.gss.redhat_support_lib.helpers.FilterHelper;
import com.redhat.gss.redhat_support_lib.helpers.QueryBuilder;
import com.redhat.gss.redhat_support_lib.infrastructure.BaseQuery;
import com.redhat.gss.redhat_support_lib.infrastructure.Comments;
import com.redhat.gss.redhat_support_lib.parsers.AttachmentType;
import com.redhat.gss.redhat_support_lib.parsers.AttachmentsType;
import com.redhat.gss.redhat_support_lib.parsers.CommentType;
import com.redhat.gss.redhat_support_lib.web.ConnectionManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.net.ftp.FTPClient;

public class Attachments
extends BaseQuery {
    private ConnectionManager connectionManager = null;

    public Attachments(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public List<AttachmentType> list(String caseNumber, String startDate, String endDate, String[] kwargs) throws RequestException, MalformedURLException {
        String url = "/rs/cases/{caseNumber}/attachments";
        url = url.replace("{caseNumber}", caseNumber);
        ArrayList<String> queryParams = new ArrayList<String>();
        if (startDate != null) {
            queryParams.add("startDate=" + startDate);
        }
        if (endDate != null) {
            queryParams.add("endDate=" + endDate);
        }
        String fullUrl = QueryBuilder.appendQuery(this.connectionManager.getConfig().getUrl() + url, queryParams);
        AttachmentsType attachments = this.get(this.connectionManager.getConnection(), fullUrl, AttachmentsType.class);
        return FilterHelper.filterResults(attachments.getAttachment(), kwargs);
    }

    public String get(String caseNumber, String attachmentUUID, String fileName, String destDir) throws Exception {
        String url = "/rs/cases/{caseNumber}/attachments/{attachmentUUID}";
        url = url.replace("{caseNumber}", caseNumber);
        url = url.replace("{attachmentUUID}", attachmentUUID);
        String fullUrl = this.connectionManager.getConfig().getUrl() + url;
        return this.getFile(this.connectionManager.getConnection(), fullUrl, fileName, destDir);
    }

    public boolean delete(String caseNumber, String attachmentUUID) throws RequestException, MalformedURLException {
        String url = "/rs/cases/{caseNumber}/attachments/{attachmentUUID}";
        url = url.replace("{caseNumber}", caseNumber);
        url = url.replace("{attachmentUUID}", attachmentUUID);
        String fullUrl = this.connectionManager.getConfig().getUrl() + url;
        return this.delete(this.connectionManager.getConnection(), fullUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String add(String caseNumber, boolean publicVis, String fileName, String description) throws Exception {
        String url = "/rs/cases/{caseNumber}/attachments";
        url = url.replace("{caseNumber}", caseNumber);
        File file = new File(fileName);
        ArrayList<String> queryParams = new ArrayList<String>();
        queryParams.add("public=" + Boolean.toString(publicVis));
        String uri = null;
        if (file.length() > this.connectionManager.getConfig().getFtpFileSize()) {
            FTPClient ftp = null;
            FileInputStream fis = null;
            try {
                ftp = this.connectionManager.getFTP();
                ftp.cwd(this.connectionManager.getConfig().getFtpDir());
                ftp.enterLocalPassiveMode();
                fis = new FileInputStream(file);
                if (!ftp.storeFile(file.getName(), (InputStream)fis)) {
                    throw new FTPException("Error during FTP store file.");
                }
            }
            finally {
                fis.close();
                ftp.logout();
            }
            String cmntText = "The file " + fileName + " exceeds the byte limit to attach a file to a case; therefore, the file was uploaded to " + this.connectionManager.getConfig().getFtpHost() + "as " + file.getName();
            CommentType comment = new CommentType();
            comment.setCaseNumber(caseNumber);
            comment.setPublic(true);
            comment.setText(cmntText);
            Comments comments = new Comments(this.connectionManager);
            comments.add(comment);
            return uri;
        }
        String fullUrl = this.connectionManager.getConfig().getUrl() + url;
        Response response = null;
        try {
            response = this.upload(this.connectionManager.getConnection(), fullUrl, file, description);
            uri = (String)response.getStringHeaders().getFirst((Object)"location");
        }
        catch (Throwable throwable) {
            this.safeClose(response);
            throw throwable;
        }
        this.safeClose(response);
        return uri;
    }
}

