/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.redhat_support_lib.infrastructure;

import com.redhat.gss.redhat_support_lib.errors.RequestException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;

public class BaseQuery {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T get(ResteasyClient client, String uri, Class<T> c) throws RequestException {
        Object object;
        Response response = null;
        try {
            Object returnObject;
            response = client.target(uri).request().accept(new String[]{"application/xml"}).get();
            if (response.getStatus() != 200) {
                throw new RequestException(response.getStatusInfo().getStatusCode() + " - " + response.getStatusInfo().getReasonPhrase());
            }
            object = returnObject = response.readEntity(c);
            this.safeClose(response);
        }
        catch (Throwable throwable) {
            this.safeClose(response);
            throw throwable;
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getFile(ResteasyClient client, String uri, String fileName, String destDir) throws RequestException, IOException, ParseException {
        Response response = null;
        try {
            response = client.target(uri).request().accept(new String[]{"application/xml"}).get();
            if (response.getStatus() != 200) {
                throw new RequestException(response.getStatusInfo().getStatusCode() + " - " + response.getStatusInfo().getReasonPhrase());
            }
            response.bufferEntity();
            File file = (File)response.readEntity(File.class);
            StringBuilder filePath = new StringBuilder();
            if (destDir != null) {
                String nameOfFile;
                filePath.append(destDir);
                if (!destDir.endsWith(File.separator)) {
                    filePath.append(File.separator);
                }
                if (fileName != null) {
                    nameOfFile = fileName;
                } else {
                    String name = (String)response.getStringHeaders().getFirst((Object)"Content-Disposition");
                    String[] temp = name.split("\"");
                    nameOfFile = MimeUtility.decodeWord((String)temp[1]);
                }
                filePath.append(nameOfFile);
                File movedFile = new File(filePath.toString());
                FileUtils.moveFile((File)file, (File)movedFile);
                file.delete();
                file = movedFile;
            }
            String string = file.getAbsolutePath();
            this.safeClose(response);
            return string;
        }
        catch (Throwable throwable) {
            this.safeClose(response);
            throw throwable;
        }
    }

    protected Response add(ResteasyClient client, String uri, Object object) throws RequestException {
        Response response = client.target(uri).request().accept(new String[]{"application/xml"}).post(Entity.entity((Object)object, (String)"application/xml"));
        if (response.getStatus() >= 400) {
            throw new RequestException(response.getStatusInfo().getStatusCode() + " - " + response.getStatusInfo().getReasonPhrase());
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T add(ResteasyClient client, String uri, Object object, Class<T> c) throws RequestException {
        Object object2;
        Response response = null;
        try {
            Object returnObject;
            response = client.target(uri).request(new String[]{"application/xml"}).accept(new String[]{"application/xml"}).post(Entity.entity((Object)object, (String)"application/xml"));
            if (response.getStatus() >= 400) {
                throw new RequestException(response.getStatusInfo().getStatusCode() + " - " + response.getStatusInfo().getReasonPhrase());
            }
            object2 = returnObject = response.readEntity(c);
            this.safeClose(response);
        }
        catch (Throwable throwable) {
            this.safeClose(response);
            throw throwable;
        }
        return (T)object2;
    }

    protected Response update(ResteasyClient client, String uri, Object object) throws RequestException {
        Response response = client.target(uri).request().accept(new String[]{"application/xml"}).put(Entity.entity((Object)object, (String)"application/xml"));
        if (response.getStatus() >= 400) {
            throw new RequestException(response.getStatusInfo().getStatusCode() + " - " + response.getStatusInfo().getReasonPhrase());
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean delete(ResteasyClient client, String uri) throws RequestException {
        Response response = null;
        try {
            response = client.target(uri).request().delete();
            if (response.getStatus() >= 400) {
                throw new RequestException(response.getStatusInfo().getStatusCode() + " - " + response.getStatusInfo().getReasonPhrase());
            }
            boolean bl = true;
            this.safeClose(response);
            return bl;
        }
        catch (Throwable throwable) {
            this.safeClose(response);
            throw throwable;
        }
    }

    protected Response upload(ResteasyClient client, String uri, File file, String description) throws FileNotFoundException, java.text.ParseException, RequestException {
        Response response;
        MultipartFormDataOutput mdo = new MultipartFormDataOutput();
        if (description != null) {
            mdo.addFormData("description", (Object)description, MediaType.APPLICATION_XML_TYPE);
        }
        mdo.addFormData("file", (Object)file, MediaType.APPLICATION_OCTET_STREAM_TYPE, file.getName());
        GenericEntity<MultipartFormDataOutput> entity = new GenericEntity<MultipartFormDataOutput>(mdo){};
        Invocation.Builder builder = client.target(uri).request(new String[]{"application/xml"});
        if (description != null) {
            builder.header("description", (Object)description);
        }
        if ((response = builder.post(Entity.entity((Object)entity, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE))).getStatus() >= 400) {
            throw new RequestException(response.getStatusInfo().getStatusCode() + " - " + response.getStatusInfo().getReasonPhrase());
        }
        return response;
    }

    public void safeClose(Response response) {
        if (response != null) {
            response.close();
        }
    }
}

