/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.redhat_support_lib.infrastructure;

import com.redhat.gss.redhat_support_lib.errors.RequestException;
import com.redhat.gss.redhat_support_lib.web.ConnectionManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;

public class Insights {
    private ConnectionManager connectionManager = null;
    public static final String MACHINE_ID = "machine_id";
    public static final String HOSTNAME = "hostname";

    public Insights(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Response get(String uri) throws RequestException, MalformedURLException {
        Response response = this.connectionManager.getConnection().target(new URL(new URL(this.connectionManager.getConfig().getUrl()), uri).toString()).request().accept(new String[]{"application/json"}).get();
        if (response.getStatus() != 200) {
            throw new RequestException(response.getStatusInfo().getStatusCode() + " - " + response.getStatusInfo().getReasonPhrase());
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSystem(String uri, String uuid, String hostname) throws RequestException, MalformedURLException {
        String url = new URL(new URL(this.connectionManager.getConfig().getUrl()), uri).toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(MACHINE_ID, uuid);
        params.put(HOSTNAME, hostname);
        try (Response response = null;){
            response = this.connectionManager.getConnection().target(url).request().accept(new String[]{"application/json"}).post(Entity.entity(params, (String)"application/json"));
            if (response.getStatus() >= 400) {
                throw new RequestException(response.getStatusInfo().getStatusCode() + " - " + response.getStatusInfo().getReasonPhrase());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSystem(String uri, String hostname) throws RequestException, MalformedURLException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(HOSTNAME, hostname);
        try (Response response = null;){
            response = this.connectionManager.getConnection().target(new URL(new URL(this.connectionManager.getConfig().getUrl()), uri).toString()).request().accept(new String[]{"application/json"}).put(Entity.entity(params, (String)"application/json"));
            if (response.getStatus() >= 400) {
                throw new RequestException(response.getStatusInfo().getStatusCode() + " - " + response.getStatusInfo().getReasonPhrase());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(String uri, File file, String description) throws FileNotFoundException, ParseException, RequestException, MalformedURLException {
        MultipartFormDataOutput mdo = new MultipartFormDataOutput();
        if (description != null) {
            mdo.addFormData("description", (Object)description, MediaType.APPLICATION_JSON_TYPE);
        }
        mdo.addFormData("file", (Object)file, MediaType.APPLICATION_OCTET_STREAM_TYPE, file.getName());
        GenericEntity<MultipartFormDataOutput> entity = new GenericEntity<MultipartFormDataOutput>(mdo){};
        Invocation.Builder builder = this.connectionManager.getConnection().target(new URL(new URL(this.connectionManager.getConfig().getUrl()), uri).toString()).request(new String[]{"application/json"});
        if (description != null) {
            builder.header("description", (Object)description);
        }
        try (Response response = null;){
            response = builder.post(Entity.entity((Object)entity, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE));
            if (response.getStatus() >= 400) {
                throw new RequestException(response.getStatusInfo().getStatusCode() + " - " + response.getStatusInfo().getReasonPhrase());
            }
        }
    }
}

