/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.redhat_support_lib.infrastructure;

import com.redhat.gss.redhat_support_lib.errors.RequestException;
import com.redhat.gss.redhat_support_lib.helpers.FilterHelper;
import com.redhat.gss.redhat_support_lib.helpers.QueryBuilder;
import com.redhat.gss.redhat_support_lib.infrastructure.BaseQuery;
import com.redhat.gss.redhat_support_lib.parsers.SolutionType;
import com.redhat.gss.redhat_support_lib.parsers.SolutionsType;
import com.redhat.gss.redhat_support_lib.web.ConnectionManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public class Solutions
extends BaseQuery {
    private ConnectionManager connectionManager = null;
    static String url = "/rs/solutions/";

    public Solutions(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public SolutionType get(String solNum) throws RequestException, MalformedURLException {
        String fullUrl = this.connectionManager.getConfig().getUrl() + url + solNum;
        return this.get(this.connectionManager.getConnection(), fullUrl, SolutionType.class);
    }

    public List<SolutionType> list(String[] keywords, String[] kwargs) throws RequestException, MalformedURLException {
        ArrayList<String> queryParams = new ArrayList<String>();
        for (String keyword : keywords) {
            queryParams.add("keyword=" + keyword);
        }
        String fullUrl = QueryBuilder.appendQuery(this.connectionManager.getConfig().getUrl() + url, queryParams);
        SolutionsType solutions = this.get(this.connectionManager.getConnection(), fullUrl, SolutionsType.class);
        return FilterHelper.filterResults(solutions.getSolution(), kwargs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolutionType add(SolutionType sol) throws Exception {
        SolutionType solutionType;
        String fullUrl = this.connectionManager.getConfig().getUrl() + url;
        Response resp = null;
        try {
            resp = this.add(this.connectionManager.getConnection(), fullUrl, sol);
            MultivaluedMap headers = resp.getStringHeaders();
            URL url = new URL((String)headers.getFirst((Object)"view-uri"));
            String path = url.getPath();
            sol.setId(path.substring(path.lastIndexOf(47) + 1, path.length()));
            sol.setViewUri(url.toString());
            solutionType = sol;
        }
        catch (Throwable throwable) {
            this.safeClose(resp);
            throw throwable;
        }
        this.safeClose(resp);
        return solutionType;
    }
}

