/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.redhat_support_lib.web;

import com.redhat.gss.redhat_support_lib.helpers.ConfigHelper;
import com.redhat.gss.redhat_support_lib.logger.RedHatSupportLibLogger;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;

public class CustomHttpEngine
extends ApacheHttpClient4Engine {
    public static TrustManager[] gullibleManagers = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }};

    public CustomHttpEngine(ConfigHelper config) {
        HttpClientBuilder client = HttpClientBuilder.create();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        if (config.getProxyUrl() != null) {
            HttpHost proxy = new HttpHost(config.getProxyUrl().getHost(), config.getProxyPort());
            client.setProxy(proxy);
        }
        if (config.getProxyUser() != null && config.getProxyPassword() != null) {
            credsProvider.setCredentials(new AuthScope(config.getProxyUrl().getHost(), config.getProxyPort()), (Credentials)new UsernamePasswordCredentials(config.getProxyUser(), config.getProxyPassword()));
            client.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        try {
            client.setSslcontext(CustomHttpEngine.createGullibleSslContext());
        }
        catch (KeyManagementException e) {
            RedHatSupportLibLogger.ROOT_LOGGER.couldNotInitializeCustomHttpEngine(e);
        }
        catch (NoSuchAlgorithmException e) {
            RedHatSupportLibLogger.ROOT_LOGGER.couldNotInitializeCustomHttpEngine(e);
        }
        this.httpClient = client.build();
    }

    public static SSLContext createGullibleSslContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext ctx = SSLContext.getInstance("SSL");
        ctx.init(null, gullibleManagers, new SecureRandom());
        return ctx;
    }
}

