/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.http;

import com.redhat.insights.InsightsErrorCode;
import com.redhat.insights.InsightsException;
import com.redhat.insights.config.InsightsConfiguration;
import com.redhat.insights.http.InsightsHttpClient;
import com.redhat.insights.logging.InsightsLogger;
import com.redhat.insights.reports.InsightsReport;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class InsightsFileWritingClient
implements InsightsHttpClient {
    private final InsightsLogger logger;
    private final InsightsConfiguration config;

    public InsightsFileWritingClient(InsightsLogger logger, InsightsConfiguration config) {
        this.logger = logger;
        this.config = config;
        this.ensureArchiveUploadDirExists();
    }

    private void ensureArchiveUploadDirExists() {
        Path dir = Paths.get(this.config.getArchiveUploadDir(), new String[0]);
        if (Files.notExists(dir, new LinkOption[0]) && !this.config.isOptingOut()) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new InsightsException(InsightsErrorCode.ERROR_UPLOAD_DIR_CREATION, "Could not create directories for path " + dir);
            }
        }
    }

    @Override
    public void decorate(InsightsReport report) {
        report.decorate("app.transport.type.file", "rhel");
    }

    @Override
    public void sendInsightsReport(String filename, InsightsReport report) {
        if (this.config.isOptingOut()) {
            return;
        }
        this.decorate(report);
        Path p = Paths.get(this.config.getArchiveUploadDir(), filename + ".json");
        try {
            Files.write(p, report.serializeRaw(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException iox) {
            throw new InsightsException(InsightsErrorCode.ERROR_WRITING_FILE, "Could not write to: " + p, iox);
        }
    }

    @Override
    public boolean isReadyToSend() {
        return new File(this.config.getMachineIdFilePath()).exists();
    }
}

