/*
 * Decompiled with CFR 0.152.
 */
package com.redis.testcontainers;

import com.redis.testcontainers.RedisServer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.shaded.org.apache.commons.lang3.ClassUtils;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public abstract class AbstractRedisContainer<C extends AbstractRedisContainer<C>>
extends GenericContainer<C>
implements RedisServer {
    public static final int REDIS_PORT = 6379;

    protected AbstractRedisContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    protected AbstractRedisContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        this.addExposedPorts(new int[]{6379});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Ready to accept connections.*\\n", (int)1));
    }

    public C withKeyspaceNotifications() {
        this.withCopyFileToContainer(MountableFile.forClasspathResource((String)"redis-keyspace-notifications.conf"), "/data/redis.conf");
        this.withCommand(new String[]{"redis-server", "/data/redis.conf"});
        return (C)this;
    }

    public String toString() {
        return ClassUtils.getShortClassName(this.getClass());
    }

    @Override
    public String getRedisHost() {
        return this.getHost();
    }

    @Override
    public int getRedisPort() {
        return this.getFirstMappedPort();
    }

    @Override
    public boolean isRedisCluster() {
        return false;
    }
}

