/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.csv;

import com.univocity.parsers.common.CommonParserSettings;
import com.univocity.parsers.common.Context;
import com.univocity.parsers.common.ProcessorErrorHandler;
import com.univocity.parsers.common.RowProcessorErrorHandler;
import com.univocity.parsers.common.input.CharAppender;
import com.univocity.parsers.common.input.DefaultCharAppender;
import com.univocity.parsers.common.input.ExpandingCharAppender;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.UnescapedQuoteHandling;
import java.util.Arrays;
import java.util.Map;

public class CsvParserSettings
extends CommonParserSettings<CsvFormat> {
    private String emptyValue = null;
    private boolean parseUnescapedQuotes = true;
    private boolean parseUnescapedQuotesUntilDelimiter = true;
    private boolean escapeUnquotedValues = false;
    private boolean keepEscapeSequences = false;
    private boolean keepQuotes = false;
    private boolean normalizeLineEndingsWithinQuotes = true;
    private boolean ignoreTrailingWhitespacesInQuotes = false;
    private boolean ignoreLeadingWhitespacesInQuotes = false;
    private boolean delimiterDetectionEnabled = false;
    private boolean quoteDetectionEnabled = false;
    private UnescapedQuoteHandling unescapedQuoteHandling = null;
    private char[] delimitersForDetection = null;
    private int formatDetectorRowSampleCount = 20;

    public String getEmptyValue() {
        return this.emptyValue;
    }

    public CsvParserSettings setEmptyValue(String emptyValue) {
        this.emptyValue = emptyValue;
        return this;
    }

    @Override
    protected CharAppender newCharAppender() {
        int chars = this.getMaxCharsPerColumn();
        if (chars != -1) {
            return new DefaultCharAppender(chars, this.emptyValue, this.getWhitespaceRangeStart());
        }
        return new ExpandingCharAppender(this.emptyValue, this.getWhitespaceRangeStart());
    }

    @Override
    protected CsvFormat createDefaultFormat() {
        return new CsvFormat();
    }

    @Deprecated
    public boolean isParseUnescapedQuotes() {
        return this.parseUnescapedQuotes || this.unescapedQuoteHandling != null && this.unescapedQuoteHandling != UnescapedQuoteHandling.RAISE_ERROR;
    }

    @Deprecated
    public CsvParserSettings setParseUnescapedQuotes(boolean parseUnescapedQuotes) {
        this.parseUnescapedQuotes = parseUnescapedQuotes;
        return this;
    }

    @Deprecated
    public CsvParserSettings setParseUnescapedQuotesUntilDelimiter(boolean parseUnescapedQuotesUntilDelimiter) {
        if (parseUnescapedQuotesUntilDelimiter) {
            this.parseUnescapedQuotes = true;
        }
        this.parseUnescapedQuotesUntilDelimiter = parseUnescapedQuotesUntilDelimiter;
        return this;
    }

    @Deprecated
    public boolean isParseUnescapedQuotesUntilDelimiter() {
        return this.parseUnescapedQuotesUntilDelimiter && this.isParseUnescapedQuotes() || this.unescapedQuoteHandling == UnescapedQuoteHandling.STOP_AT_DELIMITER || this.unescapedQuoteHandling == UnescapedQuoteHandling.SKIP_VALUE;
    }

    public boolean isEscapeUnquotedValues() {
        return this.escapeUnquotedValues;
    }

    public CsvParserSettings setEscapeUnquotedValues(boolean escapeUnquotedValues) {
        this.escapeUnquotedValues = escapeUnquotedValues;
        return this;
    }

    public final boolean isKeepEscapeSequences() {
        return this.keepEscapeSequences;
    }

    public final CsvParserSettings setKeepEscapeSequences(boolean keepEscapeSequences) {
        this.keepEscapeSequences = keepEscapeSequences;
        return this;
    }

    public final boolean isDelimiterDetectionEnabled() {
        return this.delimiterDetectionEnabled;
    }

    public final void setDelimiterDetectionEnabled(boolean separatorDetectionEnabled) {
        this.setDelimiterDetectionEnabled(separatorDetectionEnabled, new char[0]);
    }

    public final CsvParserSettings setDelimiterDetectionEnabled(boolean separatorDetectionEnabled, char ... delimitersForDetection) {
        this.delimiterDetectionEnabled = separatorDetectionEnabled;
        this.delimitersForDetection = delimitersForDetection;
        return this;
    }

    public final boolean isQuoteDetectionEnabled() {
        return this.quoteDetectionEnabled;
    }

    public final CsvParserSettings setQuoteDetectionEnabled(boolean quoteDetectionEnabled) {
        this.quoteDetectionEnabled = quoteDetectionEnabled;
        return this;
    }

    public final void detectFormatAutomatically() {
        this.detectFormatAutomatically(new char[0]);
    }

    public final CsvParserSettings detectFormatAutomatically(char ... delimitersForDetection) {
        this.setDelimiterDetectionEnabled(true, delimitersForDetection);
        this.setQuoteDetectionEnabled(true);
        this.setLineSeparatorDetectionEnabled(true);
        return this;
    }

    public boolean isNormalizeLineEndingsWithinQuotes() {
        return this.normalizeLineEndingsWithinQuotes;
    }

    public CsvParserSettings setNormalizeLineEndingsWithinQuotes(boolean normalizeLineEndingsWithinQuotes) {
        this.normalizeLineEndingsWithinQuotes = normalizeLineEndingsWithinQuotes;
        return this;
    }

    public CsvParserSettings setUnescapedQuoteHandling(UnescapedQuoteHandling unescapedQuoteHandling) {
        this.unescapedQuoteHandling = unescapedQuoteHandling;
        return this;
    }

    public UnescapedQuoteHandling getUnescapedQuoteHandling() {
        return this.unescapedQuoteHandling;
    }

    public boolean getKeepQuotes() {
        return this.keepQuotes;
    }

    public CsvParserSettings setKeepQuotes(boolean keepQuotes) {
        this.keepQuotes = keepQuotes;
        return this;
    }

    @Override
    protected void addConfiguration(Map<String, Object> out) {
        super.addConfiguration(out);
        out.put("Empty value", this.emptyValue);
        out.put("Unescaped quote handling", (Object)this.unescapedQuoteHandling);
        out.put("Escape unquoted values", this.escapeUnquotedValues);
        out.put("Keep escape sequences", this.keepEscapeSequences);
        out.put("Keep quotes", this.keepQuotes);
        out.put("Normalize escaped line separators", this.normalizeLineEndingsWithinQuotes);
        out.put("Autodetect column delimiter", this.delimiterDetectionEnabled);
        out.put("Autodetect quotes", this.quoteDetectionEnabled);
        out.put("Delimiters for detection", Arrays.toString(this.delimitersForDetection));
        out.put("Ignore leading whitespaces in quotes", this.ignoreLeadingWhitespacesInQuotes);
        out.put("Ignore trailing whitespaces in quotes", this.ignoreTrailingWhitespacesInQuotes);
    }

    @Override
    public final CsvParserSettings clone() {
        return (CsvParserSettings)super.clone();
    }

    @Override
    public final CsvParserSettings clone(boolean clearInputSpecificSettings) {
        return (CsvParserSettings)super.clone(clearInputSpecificSettings);
    }

    public final char[] getDelimitersForDetection() {
        return this.delimitersForDetection;
    }

    public boolean getIgnoreTrailingWhitespacesInQuotes() {
        return this.ignoreTrailingWhitespacesInQuotes;
    }

    public CsvParserSettings setIgnoreTrailingWhitespacesInQuotes(boolean ignoreTrailingWhitespacesInQuotes) {
        this.ignoreTrailingWhitespacesInQuotes = ignoreTrailingWhitespacesInQuotes;
        return this;
    }

    public boolean getIgnoreLeadingWhitespacesInQuotes() {
        return this.ignoreLeadingWhitespacesInQuotes;
    }

    public CsvParserSettings setIgnoreLeadingWhitespacesInQuotes(boolean ignoreLeadingWhitespacesInQuotes) {
        this.ignoreLeadingWhitespacesInQuotes = ignoreLeadingWhitespacesInQuotes;
        return this;
    }

    public final CsvParserSettings trimQuotedValues(boolean trim) {
        this.setIgnoreTrailingWhitespacesInQuotes(trim);
        this.setIgnoreLeadingWhitespacesInQuotes(trim);
        return this;
    }

    @Override
    public CsvParserSettings setNullValue(String emptyValue) {
        super.setNullValue(emptyValue);
        return this;
    }

    @Override
    public CsvParserSettings setMaxCharsPerColumn(int maxCharsPerColumn) {
        super.setMaxCharsPerColumn(maxCharsPerColumn);
        return this;
    }

    @Override
    public CsvParserSettings setSkipEmptyLines(boolean skipEmptyLines) {
        super.setSkipEmptyLines(skipEmptyLines);
        return this;
    }

    @Override
    public CsvParserSettings setIgnoreTrailingWhitespaces(boolean ignoreTrailingWhitespaces) {
        super.setIgnoreTrailingWhitespaces(ignoreTrailingWhitespaces);
        return this;
    }

    @Override
    public CsvParserSettings setIgnoreLeadingWhitespaces(boolean ignoreLeadingWhitespaces) {
        super.setIgnoreLeadingWhitespaces(ignoreLeadingWhitespaces);
        return this;
    }

    @Override
    public CsvParserSettings setHeaders(String ... headers) {
        super.setHeaders(headers);
        return this;
    }

    @Override
    public CsvParserSettings setHeadersDerivedFromClass(Class<?> headerSourceClass, String ... headers) {
        super.setHeadersDerivedFromClass(headerSourceClass, headers);
        return this;
    }

    @Override
    public CsvParserSettings setMaxColumns(int maxColumns) {
        super.setMaxColumns(maxColumns);
        return this;
    }

    public CsvParserSettings setFormat(CsvFormat format) {
        super.setFormat(format);
        return this;
    }

    @Override
    public final CsvParserSettings setAutoConfigurationEnabled(boolean autoConfigurationEnabled) {
        super.setAutoConfigurationEnabled(autoConfigurationEnabled);
        return this;
    }

    @Override
    @Deprecated
    public CsvParserSettings setRowProcessorErrorHandler(RowProcessorErrorHandler rowProcessorErrorHandler) {
        super.setRowProcessorErrorHandler(rowProcessorErrorHandler);
        return this;
    }

    @Override
    public CsvParserSettings setProcessorErrorHandler(ProcessorErrorHandler<? extends Context> processorErrorHandler) {
        super.setProcessorErrorHandler(processorErrorHandler);
        return this;
    }

    @Override
    public CsvParserSettings setErrorContentLength(int errorContentLength) {
        super.setErrorContentLength(errorContentLength);
        return this;
    }

    @Override
    public final CsvParserSettings setSkipBitsAsWhitespace(boolean skipBitsAsWhitespace) {
        super.setSkipBitsAsWhitespace(skipBitsAsWhitespace);
        return this;
    }

    public int getFormatDetectorRowSampleCount() {
        return this.formatDetectorRowSampleCount;
    }

    public void setFormatDetectorRowSampleCount(int formatDetectorRowSampleCount) {
        this.formatDetectorRowSampleCount = formatDetectorRowSampleCount <= 0 ? 20 : formatDetectorRowSampleCount;
    }
}

