/*
 * Decompiled with CFR 0.152.
 */
package spark;

import spark.Filter;
import spark.Request;
import spark.Response;

public abstract class FilterImpl
implements Filter {
    static final String DEFAULT_ACCEPT_TYPE = "*/*";
    private String path;
    private String acceptType;

    static FilterImpl create(String path, Filter filter) {
        return FilterImpl.create(path, DEFAULT_ACCEPT_TYPE, filter);
    }

    static FilterImpl create(String path, String acceptType, final Filter filter) {
        if (acceptType == null) {
            acceptType = DEFAULT_ACCEPT_TYPE;
        }
        return new FilterImpl(path, acceptType){

            @Override
            public void handle(Request request, Response response) throws Exception {
                filter.handle(request, response);
            }
        };
    }

    protected FilterImpl(String path, String acceptType) {
        this.path = path;
        this.acceptType = acceptType;
    }

    @Override
    public abstract void handle(Request var1, Response var2) throws Exception;

    public String getAcceptType() {
        return this.acceptType;
    }

    String getPath() {
        return this.path;
    }
}

