/*
 * Decompiled with CFR 0.152.
 */
package spark;

import spark.Request;
import spark.Response;
import spark.Route;

public abstract class RouteImpl
implements Route {
    static final String DEFAULT_ACCEPT_TYPE = "*/*";
    private String path;
    private String acceptType;

    static RouteImpl create(String path, Route route) {
        return RouteImpl.create(path, DEFAULT_ACCEPT_TYPE, route);
    }

    static RouteImpl create(String path, String acceptType, final Route route) {
        if (acceptType == null) {
            acceptType = DEFAULT_ACCEPT_TYPE;
        }
        return new RouteImpl(path, acceptType){

            @Override
            public Object handle(Request request, Response response) throws Exception {
                return route.handle(request, response);
            }
        };
    }

    protected RouteImpl(String path) {
        this(path, DEFAULT_ACCEPT_TYPE);
    }

    protected RouteImpl(String path, String acceptType) {
        this.path = path;
        this.acceptType = acceptType;
    }

    @Override
    public abstract Object handle(Request var1, Response var2) throws Exception;

    public Object render(Object element) throws Exception {
        if (element != null) {
            return element;
        }
        return null;
    }

    public String getAcceptType() {
        return this.acceptType;
    }

    String getPath() {
        return this.path;
    }
}

