/*
 * Decompiled with CFR 0.152.
 */
package spark.webserver;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Access;
import spark.ExceptionHandlerImpl;
import spark.ExceptionMapper;
import spark.FilterImpl;
import spark.HaltException;
import spark.Request;
import spark.RequestResponseFactory;
import spark.Response;
import spark.RouteImpl;
import spark.route.HttpMethod;
import spark.route.SimpleRouteMatcher;
import spark.routematch.RouteMatch;
import spark.utils.GzipUtils;
import spark.webserver.NotConsumedException;
import spark.webserver.RequestWrapper;
import spark.webserver.ResponseWrapper;
import spark.webserver.serialization.SerializerChain;

public class MatcherFilter
implements Filter {
    private static final String ACCEPT_TYPE_REQUEST_MIME_HEADER = "Accept";
    private static final String HTTP_METHOD_OVERRIDE_HEADER = "X-HTTP-Method-Override";
    private SimpleRouteMatcher routeMatcher;
    private SerializerChain serializerChain;
    private boolean isServletContext;
    private boolean hasOtherHandlers;
    private static final Logger LOG = LoggerFactory.getLogger(MatcherFilter.class);
    private static final String NOT_FOUND = "<html><body><h2>404 Not found</h2></body></html>";
    private static final String INTERNAL_ERROR = "<html><body><h2>500 Internal Error</h2></body></html>";

    public MatcherFilter(SimpleRouteMatcher routeMatcher, boolean isServletContext, boolean hasOtherHandlers) {
        this.routeMatcher = routeMatcher;
        this.isServletContext = isServletContext;
        this.hasOtherHandlers = hasOtherHandlers;
        this.serializerChain = new SerializerChain();
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        boolean consumed;
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        String method = httpRequest.getHeader(HTTP_METHOD_OVERRIDE_HEADER);
        if (method == null) {
            method = httpRequest.getMethod();
        }
        String httpMethodStr = method.toLowerCase();
        String uri = httpRequest.getPathInfo();
        String acceptType = httpRequest.getHeader(ACCEPT_TYPE_REQUEST_MIME_HEADER);
        String bodyContent = null;
        RequestWrapper requestWrapper = new RequestWrapper();
        ResponseWrapper responseWrapper = new ResponseWrapper();
        Response response = RequestResponseFactory.create(httpResponse);
        LOG.debug("httpMethod:" + httpMethodStr + ", uri: " + uri);
        try {
            List<RouteMatch> matchSet = this.routeMatcher.findTargetsForRequestedRoute(HttpMethod.before, uri, acceptType);
            for (RouteMatch filterMatch : matchSet) {
                Object filterTarget = filterMatch.getTarget();
                if (!(filterTarget instanceof FilterImpl)) continue;
                Request request = RequestResponseFactory.create(filterMatch, httpRequest);
                FilterImpl filter = (FilterImpl)filterTarget;
                requestWrapper.setDelegate(request);
                responseWrapper.setDelegate(response);
                filter.handle(requestWrapper, responseWrapper);
                String bodyAfterFilter = Access.getBody(response);
                if (bodyAfterFilter == null) continue;
                bodyContent = bodyAfterFilter;
            }
            HttpMethod httpMethod = HttpMethod.valueOf(httpMethodStr);
            RouteMatch match = null;
            match = this.routeMatcher.findTargetForRequestedRoute(httpMethod, uri, acceptType);
            Object target = null;
            if (match != null) {
                target = match.getTarget();
            } else if (httpMethod == HttpMethod.head && bodyContent == null) {
                String string = bodyContent = this.routeMatcher.findTargetForRequestedRoute(HttpMethod.get, uri, acceptType) != null ? "" : null;
            }
            if (target != null) {
                Object result = null;
                if (target instanceof RouteImpl) {
                    RouteImpl route = (RouteImpl)target;
                    if (requestWrapper.getDelegate() == null) {
                        Request request = RequestResponseFactory.create(match, httpRequest);
                        requestWrapper.setDelegate(request);
                    } else {
                        requestWrapper.changeMatch(match);
                    }
                    responseWrapper.setDelegate(response);
                    Object element = route.handle(requestWrapper, responseWrapper);
                    result = route.render(element);
                }
                if (result != null) {
                    bodyContent = result;
                }
            }
            matchSet = this.routeMatcher.findTargetsForRequestedRoute(HttpMethod.after, uri, acceptType);
            for (RouteMatch filterMatch : matchSet) {
                Object filterTarget = filterMatch.getTarget();
                if (!(filterTarget instanceof FilterImpl)) continue;
                if (requestWrapper.getDelegate() == null) {
                    Request request = RequestResponseFactory.create(filterMatch, httpRequest);
                    requestWrapper.setDelegate(request);
                } else {
                    requestWrapper.changeMatch(filterMatch);
                }
                responseWrapper.setDelegate(response);
                FilterImpl filter = (FilterImpl)filterTarget;
                filter.handle(requestWrapper, responseWrapper);
                String bodyAfterFilter = Access.getBody(response);
                if (bodyAfterFilter == null) continue;
                bodyContent = bodyAfterFilter;
            }
        }
        catch (HaltException hEx) {
            LOG.debug("halt performed");
            httpResponse.setStatus(hEx.getStatusCode());
            bodyContent = hEx.getBody() != null ? hEx.getBody() : "";
        }
        catch (Exception e) {
            ExceptionHandlerImpl handler = ExceptionMapper.getInstance().getHandler(e);
            if (handler != null) {
                handler.handle(e, requestWrapper, responseWrapper);
                String bodyAfterFilter = Access.getBody(responseWrapper.getDelegate());
                if (bodyAfterFilter != null) {
                    bodyContent = bodyAfterFilter;
                }
            }
            LOG.error("", (Throwable)e);
            httpResponse.setStatus(500);
            bodyContent = INTERNAL_ERROR;
        }
        if (bodyContent == null && responseWrapper.isRedirected()) {
            bodyContent = "";
        }
        boolean bl = consumed = bodyContent != null;
        if (!consumed && this.hasOtherHandlers) {
            throw new NotConsumedException();
        }
        if (!consumed && !this.isServletContext) {
            LOG.info("The requested route [" + uri + "] has not been mapped in Spark");
            httpResponse.setStatus(404);
            bodyContent = String.format(NOT_FOUND, new Object[0]);
            consumed = true;
        }
        if (consumed) {
            if (!httpResponse.isCommitted()) {
                if (httpResponse.getContentType() == null) {
                    httpResponse.setContentType("text/html; charset=utf-8");
                }
                OutputStream outputStream = GzipUtils.checkAndWrap(httpRequest, httpResponse);
                this.serializerChain.process(outputStream, bodyContent);
                outputStream.flush();
            }
        } else if (chain != null) {
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
    }

    public void destroy() {
    }
}

