/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf;

import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.faces.view.facelets.FaceletContext;

public class IterationIdManager {
    private static final String _STACK_OF_TRACKED_IDS = "com.sun.faces.facelets.tag.js._TRACKED_IDS";

    public static boolean registerLiteralId(FaceletContext ctx, String id) {
        Set<String> trackedIds = IterationIdManager.getStackOfTrackedIds(ctx).peek();
        if (trackedIds == null) {
            return false;
        }
        if (trackedIds.contains(id)) {
            return true;
        }
        trackedIds.add(id);
        return false;
    }

    public static void startIteration(FaceletContext ctx) {
        Deque<Set<String>> stack = IterationIdManager.getStackOfTrackedIds(ctx);
        Set<String> current = stack.peek();
        if (current == null) {
            current = new HashSet<String>();
        }
        stack.push(current);
    }

    public static void stopIteration(FaceletContext ctx) {
        IterationIdManager.getStackOfTrackedIds(ctx).pop();
    }

    public static void startNamingContainer(FaceletContext ctx) {
        IterationIdManager.getStackOfTrackedIds(ctx).push(null);
    }

    public static void stopNamingContainer(FaceletContext ctx) {
        IterationIdManager.getStackOfTrackedIds(ctx).pop();
    }

    private static Deque<Set<String>> getStackOfTrackedIds(FaceletContext ctx) {
        LinkedList stack = (LinkedList)ctx.getAttribute(_STACK_OF_TRACKED_IDS);
        if (stack == null) {
            stack = new LinkedList();
            ctx.setAttribute(_STACK_OF_TRACKED_IDS, stack);
        }
        return stack;
    }
}

