/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import jakarta.faces.component.UICommand;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.FacesEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class ButtonRenderer
extends HtmlBasicRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.COMMANDBUTTON);

    @Override
    public void decode(FacesContext context, UIComponent component) {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldDecode(component)) {
            return;
        }
        String clientId = this.decodeBehaviors(context, component);
        if (ButtonRenderer.wasClicked(context, component, clientId) && !ButtonRenderer.isReset(component)) {
            component.queueEvent((FacesEvent)new ActionEvent(context, component));
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("This command resulted in form submission  ActionEvent queued.");
                logger.log(Level.FINE, "End decoding component {0}", component.getId());
            }
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        Collection<ClientBehaviorContext.Parameter> params;
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        String type = ButtonRenderer.getButtonType(component);
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String label = "";
        Object value = ((UICommand)component).getValue();
        if (value != null) {
            label = value.toString();
        }
        if (!(params = this.getBehaviorParameters(component)).isEmpty() && (type.equals("submit") || type.equals("button"))) {
            RenderKitUtils.renderFacesJsIfNecessary(context);
        }
        String imageSrc = (String)component.getAttributes().get("image");
        writer.startElement("input", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        String clientId = component.getClientId(context);
        if (imageSrc != null) {
            writer.writeAttribute("type", (Object)"image", "type");
            writer.writeURIAttribute("src", (Object)RenderKitUtils.getImageSource(context, component, "image"), "image");
            writer.writeAttribute("name", (Object)clientId, "clientId");
            String alt = (String)component.getAttributes().get("alt");
            if (alt != null) {
                writer.writeAttribute("alt", (Object)alt, "alt");
            } else if (writer.getContentType().equals("application/xhtml+xml")) {
                writer.writeAttribute("alt", (Object)"", "alt");
            }
        } else {
            writer.writeAttribute("type", (Object)type, "type");
            writer.writeAttribute("name", (Object)clientId, "clientId");
            writer.writeAttribute("value", (Object)label, "value");
        }
        RenderKitUtils.renderPassThruAttributes(context, writer, component, ATTRIBUTES, ButtonRenderer.getNonOnClickBehaviors(component));
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component);
        String styleClass = (String)component.getAttributes().get("styleClass");
        if (styleClass != null && styleClass.length() > 0) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        RenderKitUtils.renderOnclick(context, component, params, null, false);
        if (component.getChildCount() == 0) {
            writer.endElement("input");
        }
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (component.getChildCount() > 0) {
            context.getResponseWriter().endElement("input");
        }
    }

    private static boolean wasClicked(FacesContext context, UIComponent component, String clientId) {
        if (clientId == null) {
            clientId = component.getClientId(context);
        }
        if (context.getPartialViewContext().isAjaxRequest()) {
            return RenderKitUtils.PredefinedPostbackParameter.BEHAVIOR_SOURCE_PARAM.getValue(context).equals(clientId);
        }
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.get(clientId) == null) {
            if (RenderKitUtils.isPartialOrBehaviorAction(context, clientId)) {
                return true;
            }
            StringBuilder builder = new StringBuilder(clientId);
            String xValue = builder.append(".x").toString();
            builder.setLength(clientId.length());
            String yValue = builder.append(".y").toString();
            return requestParameterMap.get(xValue) != null && requestParameterMap.get(yValue) != null;
        }
        return true;
    }

    private static boolean isReset(UIComponent component) {
        return "reset".equals(component.getAttributes().get("type"));
    }

    private static String getButtonType(UIComponent component) {
        String type = (String)component.getAttributes().get("type");
        if (type == null || !"reset".equals(type) && !"submit".equals(type) && !"button".equals(type)) {
            type = "submit";
            component.getAttributes().put("type", type);
        }
        return type;
    }

    private static Map<String, List<ClientBehavior>> getNonOnClickBehaviors(UIComponent component) {
        return ButtonRenderer.getPassThruBehaviors(component, "click", "action");
    }
}

