/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.EntryFilters;
import com.swoval.files.FileOps;
import com.swoval.files.LinkOption;
import com.swoval.files.MapOps;
import com.swoval.files.NioWrappers;
import com.swoval.files.QuickFile;
import com.swoval.files.QuickFileImpl;
import com.swoval.files.QuickList;
import com.swoval.functional.Either;
import com.swoval.functional.Filter;
import com.swoval.functional.Filters;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class Directory<T>
implements AutoCloseable {
    public final Path path;
    public final Path realPath;
    private final int depth;
    private final Converter<T> converter;
    private final AtomicReference<Entry<T>> _cacheEntry;
    private final Object lock = new Object();
    private final MapByName<Directory<T>> subdirectories = new MapByName();
    private final MapByName<Entry<T>> files = new MapByName();
    private static final Converter<Path> PATH_CONVERTER = new Converter<Path>(){

        @Override
        public Path apply(Path path) {
            return path;
        }
    };
    private final Filter<QuickFile> pathFilter;

    public int getDepth() {
        return this.depth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            Iterator iterator = this.subdirectories.values().iterator();
            while (iterator.hasNext()) {
                ((Directory)iterator.next()).close();
            }
            this.subdirectories.clear();
            this.files.clear();
        }
    }

    public Entry<T> entry() {
        return this._cacheEntry.get();
    }

    Directory(Path path, Path path2, Converter<T> converter, int n, final Filter<? super QuickFile> filter) throws IOException {
        this.path = path;
        this.realPath = path2;
        this.converter = converter;
        this.depth = n;
        int n2 = Entry.getKind(path);
        this._cacheEntry = new AtomicReference<Object>(null);
        this.pathFilter = new Filter<QuickFile>(){

            @Override
            public boolean accept(QuickFile quickFile) {
                return quickFile.toPath().startsWith(Directory.this.path) && filter.accept(quickFile);
            }
        };
        try {
            this._cacheEntry.set(new Entry<T>(path, this.converter.apply(path2), n2));
        }
        catch (IOException iOException) {
            this._cacheEntry.set(new Entry<IOException>(path, iOException, n2));
        }
    }

    public List<Entry<T>> list(int n, EntryFilter<? super T> entryFilter) {
        ArrayList<Entry<T>> arrayList = new ArrayList<Entry<T>>();
        this.listImpl(n, entryFilter, arrayList);
        return arrayList;
    }

    public List<Entry<T>> list(boolean bl, EntryFilter<? super T> entryFilter) {
        ArrayList<Entry<T>> arrayList = new ArrayList<Entry<T>>();
        this.listImpl(bl ? Integer.MAX_VALUE : 0, entryFilter, arrayList);
        return arrayList;
    }

    public List<Entry<T>> list(Path path, int n, EntryFilter<? super T> entryFilter) {
        Either<Entry<T>, Directory<T>> either = this.find(path);
        if (either != null) {
            if (either.isRight()) {
                return either.get().list(n, entryFilter);
            }
            Entry entry = (Entry)either.left().getValue();
            ArrayList<Entry<T>> arrayList = new ArrayList<Entry<T>>();
            if (entry != null && entryFilter.accept(entry)) {
                arrayList.add(entry);
            }
            return arrayList;
        }
        return new ArrayList<Entry<T>>();
    }

    public List<Entry<T>> list(Path path, boolean bl, EntryFilter<? super T> entryFilter) {
        return this.list(path, bl ? Integer.MAX_VALUE : 0, entryFilter);
    }

    public Updates<T> update(Path path, int n) throws IOException {
        return this.pathFilter.accept(new QuickFileImpl(path.toString(), n)) ? this.updateImpl(path.equals(this.path) ? new ArrayList() : FileOps.parts(this.path.relativize(path)), n) : new Updates();
    }

    public List<Entry<T>> remove(Path path) {
        if (path.isAbsolute() && path.startsWith(this.path)) {
            return this.removeImpl(FileOps.parts(this.path.relativize(path)));
        }
        return new ArrayList<Entry<T>>();
    }

    public boolean recursive() {
        return this.depth == Integer.MAX_VALUE;
    }

    public String toString() {
        return "Directory(" + this.path + ", maxDepth = " + this.depth + ")";
    }

    private int subdirectoryDepth() {
        return this.depth == Integer.MAX_VALUE ? this.depth : (this.depth > 0 ? this.depth - 1 : 0);
    }

    private void addDirectory(Directory<T> directory, Path path, Updates<T> updates) throws IOException {
        Directory<Object> directory2 = new Directory<T>(path, path, this.converter, super.subdirectoryDepth(), this.pathFilter).init();
        HashMap<Path, Entry> hashMap = new HashMap<Path, Entry>();
        Directory<Object> directory3 = directory.subdirectories.put(path.getFileName().toString(), directory2);
        if (directory3 != null) {
            hashMap.put(directory3.realPath, directory3.entry());
            for (Entry object : directory3.list(Integer.MAX_VALUE, EntryFilters.AllPass)) {
                hashMap.put(object.path, object);
            }
        }
        HashMap<Path, Entry<T>> hashMap2 = new HashMap<Path, Entry<T>>();
        hashMap2.put(directory2.realPath, directory2.entry());
        for (Entry<Object> entry : directory2.list(Integer.MAX_VALUE, EntryFilters.AllPass)) {
            hashMap2.put(entry.path, entry);
        }
        MapOps.diffDirectoryEntries(hashMap, (Map)hashMap2, updates);
    }

    private boolean isLoop(Path path, Path path2) {
        return path.startsWith(path2) && !path.equals(path2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Updates<T> updateImpl(List<Path> list, int n) throws IOException {
        Updates<T> updates = new Updates<T>();
        if (!list.isEmpty()) {
            Iterator<Path> iterator = list.iterator();
            Directory<Object> directory = this;
            while (iterator.hasNext() && directory != null && directory.depth >= 0) {
                Object object;
                Path path = iterator.next();
                if (path.toString().isEmpty()) {
                    return updates;
                }
                Path path2 = directory.path.resolve(path);
                Path path3 = this.toRealPath(path2);
                if (!iterator.hasNext()) {
                    object = directory.lock;
                    synchronized (object) {
                        boolean bl;
                        boolean bl2 = bl = (n & 1) != 0;
                        if (!bl || directory.depth <= 0 || super.isLoop(path2, path3)) {
                            Entry<T> entry;
                            Directory<T> directory2 = bl ? directory.subdirectories.getByName(path) : null;
                            Entry<T> entry2 = directory2 != null ? directory2.entry() : directory.files.getByName(path);
                            Entry<T> entry3 = new Entry<T>(path, this.converter.apply(path2), n);
                            if (bl) {
                                directory.subdirectories.put(path.toString(), new Directory<T>(path2, path3, this.converter, -1, this.pathFilter));
                            } else {
                                directory.files.put(path.toString(), entry3);
                            }
                            Entry<T> entry4 = entry = entry2 == null ? null : entry2.resolvedFrom(directory.path);
                            if (entry == null) {
                                updates.onCreate(entry3.resolvedFrom(directory.path));
                            } else {
                                updates.onUpdate(entry, entry3.resolvedFrom(directory.path));
                            }
                            return updates;
                        }
                        super.addDirectory(directory, path2, updates);
                        return updates;
                    }
                }
                object = directory.lock;
                synchronized (object) {
                    Directory<Object> directory3 = directory.subdirectories.getByName(path);
                    if (directory3 == null && directory.depth > 0) {
                        super.addDirectory(directory, directory.path.resolve(path), updates);
                    }
                    directory = directory3;
                }
            }
        } else if (n == 1) {
            List<Entry<Object>> list2 = this.list(true, EntryFilters.AllPass);
            this.init();
            MapOps.diffDirectoryEntries(list2, this.list(true, EntryFilters.AllPass), updates);
        } else {
            Entry<T> entry = this.entry();
            try {
                Entry<T> entry5 = new Entry<T>(this.realPath, this.converter.apply(this.realPath), n);
                this._cacheEntry.set(entry5);
                updates.onUpdate(entry, this.entry());
            }
            catch (IOException iOException) {
                updates.onError(this.realPath, iOException);
            }
        }
        return updates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Either<Entry<T>, Directory<T>> findImpl(List<Path> list) {
        Iterator<Path> iterator = list.iterator();
        Directory<T> directory = this;
        Either either = null;
        while (iterator.hasNext() && directory != null && either == null) {
            Object object;
            Path path = iterator.next();
            if (!iterator.hasNext()) {
                object = directory.lock;
                synchronized (object) {
                    Directory<T> directory2 = directory.subdirectories.getByName(path);
                    if (directory2 != null) {
                        either = Either.right(directory2);
                    } else {
                        Entry<T> entry = directory.files.getByName(path);
                        if (entry != null) {
                            either = Either.left(entry.resolvedFrom(directory.path, entry.getKind()));
                        }
                    }
                    continue;
                }
            }
            object = directory.lock;
            synchronized (object) {
                directory = directory.subdirectories.getByName(path);
            }
        }
        return either;
    }

    private Either<Entry<T>, Directory<T>> find(Path path) {
        if (path.equals(this.path)) {
            return Either.right(this);
        }
        if (!path.isAbsolute()) {
            return this.findImpl(FileOps.parts(path));
        }
        if (path.startsWith(this.path)) {
            return this.findImpl(FileOps.parts(this.path.relativize(path)));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listImpl(int n, EntryFilter<? super T> entryFilter, List<Entry<T>> list) {
        if (this.depth < 0) {
            list.add(this.entry());
        } else {
            ArrayList arrayList;
            ArrayList arrayList2;
            Iterator iterator = this.lock;
            synchronized (iterator) {
                arrayList2 = new ArrayList(this.files.values());
                arrayList = new ArrayList(this.subdirectories.values());
            }
            for (Object object : arrayList2) {
                Object object2 = ((Entry)object).resolvedFrom(this.path, ((Entry)object).getKind());
                if (!entryFilter.accept((Entry<T>)object2)) continue;
                list.add((Entry<T>)object2);
            }
            for (Object object2 : arrayList) {
                Entry<T> entry = ((Directory)object2).entry();
                Entry<T> entry2 = entry.resolvedFrom(this.path, entry.getKind());
                if (entryFilter.accept(entry2)) {
                    list.add(entry2);
                }
                if (n <= 0) continue;
                super.listImpl(n - 1, entryFilter, list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Entry<T>> removeImpl(List<Path> list) {
        ArrayList<Entry<T>> arrayList = new ArrayList<Entry<T>>();
        Iterator<Path> iterator = list.iterator();
        Directory<T> directory = this;
        while (iterator.hasNext() && directory != null) {
            Object object;
            Path path = iterator.next();
            if (!iterator.hasNext()) {
                object = directory.lock;
                synchronized (object) {
                    Entry<T> entry = directory.files.removeByName(path);
                    if (entry != null) {
                        arrayList.add(entry.resolvedFrom(directory.path, entry.getKind()));
                    } else {
                        Directory<Object> directory2 = directory.subdirectories.removeByName(path);
                        if (directory2 != null) {
                            arrayList.addAll(directory2.list(Integer.MAX_VALUE, EntryFilters.AllPass));
                            arrayList.add(directory2.entry());
                        }
                    }
                    continue;
                }
            }
            object = directory.lock;
            synchronized (object) {
                directory = directory.subdirectories.getByName(path);
            }
        }
        return arrayList;
    }

    private Path toRealPath(Path path) {
        try {
            return path.toRealPath(new java.nio.file.LinkOption[0]);
        }
        catch (IOException iOException) {
            return path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Directory<T> init() throws IOException {
        if (this.depth >= 0) {
            Object object = this.lock;
            synchronized (object) {
                for (QuickFile quickFile : QuickList.list(this.path, 0, true)) {
                    if (!this.pathFilter.accept(quickFile)) continue;
                    int n = (quickFile.isSymbolicLink() ? 4 : 0) | (quickFile.isDirectory() ? 1 : 2);
                    Path path = quickFile.toPath();
                    Path path2 = this.path.relativize(path).getFileName();
                    if (quickFile.isDirectory()) {
                        if (this.depth > 0) {
                            Path path3 = this.toRealPath(path);
                            if (!quickFile.isSymbolicLink() || !this.isLoop(path, path3)) {
                                this.subdirectories.put(path2.toString(), new Directory<T>(path, path3, this.converter, this.subdirectoryDepth(), this.pathFilter).init());
                                continue;
                            }
                            this.subdirectories.put(path2.toString(), new Directory<T>(path, path3, this.converter, -1, this.pathFilter));
                            continue;
                        }
                        try {
                            this.files.put(path2.toString(), new Entry<T>(path2, this.converter.apply(path), n));
                        }
                        catch (IOException iOException) {
                            this.files.put(path2.toString(), new Entry<IOException>(path2, iOException, n));
                        }
                        continue;
                    }
                    try {
                        this.files.put(path2.toString(), new Entry<T>(path2, this.converter.apply(path), n));
                    }
                    catch (IOException iOException) {
                        this.files.put(path2.toString(), new Entry<IOException>(path2, iOException, n));
                    }
                }
            }
        }
        return this;
    }

    public static Directory<Path> of(Path path) throws IOException {
        return Directory.of(path, true);
    }

    public static Directory<Path> of(Path path, int n) throws IOException {
        return new Directory<Path>(path, path, PATH_CONVERTER, n, Filters.AllPass).init();
    }

    public static Directory<Path> of(Path path, boolean bl) throws IOException {
        return new Directory<Path>(path, path, PATH_CONVERTER, bl ? Integer.MAX_VALUE : 0, Filters.AllPass).init();
    }

    public static <T> Directory<T> cached(Path path, Converter<T> converter) throws IOException {
        return new Directory<T>(path, path, converter, Integer.MAX_VALUE, Filters.AllPass).init();
    }

    public static <T> Directory<T> cached(Path path, Converter<T> converter, boolean bl) throws IOException {
        return new Directory<T>(path, path, converter, bl ? Integer.MAX_VALUE : 0, Filters.AllPass).init();
    }

    public static <T> Directory<T> cached(Path path, Converter<T> converter, int n) throws IOException {
        return new Directory<T>(path, path, converter, n, Filters.AllPass).init();
    }

    public static interface Observer<T> {
        public void onCreate(Entry<T> var1);

        public void onDelete(Entry<T> var1);

        public void onUpdate(Entry<T> var1, Entry<T> var2);

        public void onError(Path var1, IOException var2);
    }

    public static interface OnError {
        public void apply(Path var1, IOException var2);
    }

    public static interface OnUpdate<T> {
        public void apply(Entry<T> var1, Entry<T> var2);
    }

    public static interface OnChange<T> {
        public void apply(Entry<T> var1);
    }

    public static interface EntryFilter<T> {
        public boolean accept(Entry<? extends T> var1);
    }

    static class Updates<T>
    implements Observer<T> {
        private final List<Entry<T>> creations = new ArrayList<Entry<T>>();
        private final List<Entry<T>> deletions = new ArrayList<Entry<T>>();
        private final List<Entry<T>[]> updates = new ArrayList<Entry<T>[]>();

        Updates() {
        }

        public void observe(Observer<T> observer) {
            Iterator<Entry<T>> iterator = this.creations.iterator();
            while (iterator.hasNext()) {
                observer.onCreate(iterator.next());
            }
            for (Entry<T>[] object2 : this.updates) {
                observer.onUpdate(object2[0], object2[1]);
            }
            Iterator<Entry<T>> iterator2 = this.deletions.iterator();
            while (iterator2.hasNext()) {
                observer.onDelete(iterator2.next());
            }
        }

        @Override
        public void onCreate(Entry<T> entry) {
            this.creations.add(entry);
        }

        @Override
        public void onDelete(Entry<T> entry) {
            this.deletions.add(entry);
        }

        @Override
        public void onUpdate(Entry<T> entry, Entry<T> entry2) {
            this.updates.add(new Entry[]{entry, entry2});
        }

        @Override
        public void onError(Path path, IOException iOException) {
        }
    }

    public static final class Entry<T>
    implements Comparable<Entry<T>> {
        public static final int DIRECTORY = 1;
        public static final int FILE = 2;
        public static final int LINK = 4;
        public static final int UNKNOWN = 8;
        private final int kind;
        public final Path path;
        private final T value;
        private final IOException exception;

        public static int getKind(Path path, BasicFileAttributes basicFileAttributes) {
            return basicFileAttributes.isSymbolicLink() ? 4 | (Files.isDirectory(path, new java.nio.file.LinkOption[0]) ? 1 : 2) : (basicFileAttributes.isDirectory() ? 1 : 2);
        }

        public static int getKind(Path path) throws IOException {
            return Entry.getKind(path, NioWrappers.readAttributes((Path)path, (java.nio.file.LinkOption[])new java.nio.file.LinkOption[]{LinkOption.NOFOLLOW_LINKS}));
        }

        private static int getKindOrUnknown(Path path) {
            try {
                return Entry.getKind(path);
            }
            catch (IOException iOException) {
                return 8;
            }
        }

        public final boolean isDirectory() {
            return this.is(1) || this.is(8) && Files.isDirectory(this.path, new java.nio.file.LinkOption[0]);
        }

        public final boolean isFile() {
            return this.is(2) || this.is(8) && Files.isRegularFile(this.path, new java.nio.file.LinkOption[0]);
        }

        public final boolean isSymbolicLink() {
            return this.is(4) || this.is(8) && Files.isRegularFile(this.path, new java.nio.file.LinkOption[0]);
        }

        public final int getKind() {
            return this.kind;
        }

        public T getValue() throws NullPointerException {
            if (this.value == null) {
                throw new NullPointerException();
            }
            return this.value;
        }

        public T getValueOrDefault(T t) {
            return this.value == null ? t : this.value;
        }

        public IOException getIOException() {
            return this.exception;
        }

        private Entry(Path path, T t, IOException iOException, int n) {
            this.path = path;
            this.value = t;
            this.kind = n;
            this.exception = iOException;
        }

        public Entry(Path path, IOException iOException, int n) {
            this(path, null, iOException, n);
        }

        public Entry(Path path, T t, int n) {
            this(path, t, null, n);
        }

        public Entry(Path path, T t) {
            this(path, t, Entry.getKindOrUnknown(path));
        }

        public Entry<T> resolvedFrom(Path path) {
            return this.value == null ? new Entry<T>(path.resolve(this.path), this.exception, this.kind) : new Entry<T>(path.resolve(this.path), this.value, this.kind);
        }

        public Entry<T> resolvedFrom(Path path, int n) {
            return this.value == null ? new Entry<T>(path.resolve(this.path), this.exception, n) : new Entry<T>(path.resolve(this.path), this.value, n);
        }

        public boolean equals(Object object) {
            if (object instanceof Entry) {
                Entry entry = (Entry)object;
                return this.path.equals(entry.path) && (this.value == null ? entry.value == null : this.value.equals(entry.value));
            }
            return false;
        }

        public int hashCode() {
            return this.path.hashCode() ^ this.value.hashCode();
        }

        public String toString() {
            return "Entry(" + this.path + ", " + this.value + ")";
        }

        private boolean is(int n) {
            return (n & this.kind) != 0;
        }

        @Override
        public int compareTo(Entry<T> entry) {
            return this.path.compareTo(entry.path);
        }
    }

    private static class MapByName<T>
    extends HashMap<String, T> {
        private MapByName() {
        }

        T getByName(Path path) {
            return (T)this.get(path.getFileName().toString());
        }

        T removeByName(Path path) {
            return (T)this.remove(path.getFileName().toString());
        }
    }

    public static interface Converter<R> {
        public R apply(Path var1) throws IOException;
    }
}

