/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.ArrayOps;
import com.swoval.files.Directory;
import com.swoval.files.DirectoryRegistry;
import com.swoval.files.DirectoryWatcher;
import com.swoval.files.EntryFilters;
import com.swoval.files.Executor;
import com.swoval.files.QuickFile;
import com.swoval.files.QuickFileImpl;
import com.swoval.files.QuickList;
import com.swoval.files.WatchedDirectories;
import com.swoval.files.WatchedDirectory;
import com.swoval.functional.Consumer;
import com.swoval.functional.Either;
import com.swoval.functional.Filter;
import com.swoval.functional.IO;
import java.io.IOException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class NioDirectoryWatcher
extends DirectoryWatcher {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    protected final Executor callbackExecutor;
    protected final Executor executor;
    private final Map<Path, Directory<WatchedDirectory>> rootDirectories = new HashMap<Path, Directory<WatchedDirectory>>();
    private final boolean pollNewDirectories;
    private final DirectoryRegistry directoryRegistry;
    private final Directory.Converter<WatchedDirectory> converter;
    private final Directory.Observer<WatchedDirectory> updateObserver = new Directory.Observer<WatchedDirectory>(){

        @Override
        public void onCreate(Directory.Entry<WatchedDirectory> entry) {
        }

        @Override
        public void onDelete(Directory.Entry<WatchedDirectory> entry) {
            entry.getValue().close();
        }

        @Override
        public void onUpdate(Directory.Entry<WatchedDirectory> entry, Directory.Entry<WatchedDirectory> entry2) {
        }

        @Override
        public void onError(Path path, IOException iOException) {
        }
    };

    NioDirectoryWatcher(final IO<Path, WatchedDirectory> iO, Executor executor, Executor executor2, DirectoryRegistry directoryRegistry, DirectoryWatcher.Option ... optionArray) {
        this.directoryRegistry = directoryRegistry;
        this.pollNewDirectories = ArrayOps.contains(optionArray, DirectoryWatcher.Options.POLL_NEW_DIRECTORIES);
        this.callbackExecutor = executor;
        this.executor = executor2;
        this.converter = new Directory.Converter<WatchedDirectory>(){

            @Override
            public WatchedDirectory apply(Path path) {
                return (WatchedDirectory)iO.apply(path).getOrElse(WatchedDirectories.INVALID);
            }
        };
    }

    private Directory<WatchedDirectory> getRoot(Path path) {
        Directory<WatchedDirectory> directory = this.rootDirectories.get(path);
        if (directory == null) {
            try {
                directory = new Directory<WatchedDirectory>(path, path, this.converter, Integer.MAX_VALUE, (Filter<? super QuickFile>)new Filter<QuickFile>(){

                    @Override
                    public boolean accept(QuickFile quickFile) {
                        return NioDirectoryWatcher.this.directoryRegistry.accept(quickFile.toPath());
                    }
                }).init();
                this.rootDirectories.put(path, directory);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return directory;
    }

    @Override
    public Either<IOException, Boolean> register(final Path path, final int n) {
        return this.executor.block(new Callable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return NioDirectoryWatcher.this.registerImpl(path, n);
            }
        }).castLeft(IOException.class);
    }

    @Override
    public void unregister(final Path path) {
        this.executor.block(new Runnable(){

            @Override
            public void run() {
                NioDirectoryWatcher.this.directoryRegistry.removeDirectory(path);
                Directory directory = NioDirectoryWatcher.this.getRoot(path.getRoot());
                if (directory != null) {
                    List<Directory.Entry<Object>> list = directory.list(true, EntryFilters.AllPass);
                    Collections.sort(list);
                    Collections.reverse(list);
                    for (Directory.Entry<Object> entry : list) {
                        if (NioDirectoryWatcher.this.directoryRegistry.accept(entry.path)) continue;
                        Iterator iterator = directory.remove(entry.path).iterator();
                        while (iterator.hasNext()) {
                            ((WatchedDirectory)iterator.next().getValue()).close();
                        }
                    }
                }
            }
        });
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            super.close();
            this.executor.block(new Runnable(){

                @Override
                public void run() {
                    NioDirectoryWatcher.this.callbackExecutor.close();
                    for (Directory directory : NioDirectoryWatcher.this.rootDirectories.values()) {
                        ((WatchedDirectory)directory.entry().getValue()).close();
                        Iterator<Directory.Entry<Object>> iterator = directory.list(true, EntryFilters.AllPass).iterator();
                        while (iterator.hasNext()) {
                            ((WatchedDirectory)iterator.next().getValue()).close();
                        }
                    }
                }
            });
            this.executor.close();
        }
    }

    private void maybeRunCallback(final Consumer<DirectoryWatcher.Event> consumer, final DirectoryWatcher.Event event) {
        if (this.directoryRegistry.accept(event.path)) {
            this.callbackExecutor.run(new Runnable(){

                @Override
                public void run() {
                    consumer.accept(event);
                }
            });
        }
    }

    private void processPath(Consumer<DirectoryWatcher.Event> consumer, Path path, DirectoryWatcher.Event.Kind kind, HashSet<QuickFile> hashSet, HashSet<Path> hashSet2) {
        int n;
        HashSet<QuickFile> hashSet3 = new HashSet<QuickFile>();
        this.add(path, n - ((n = this.directoryRegistry.maxDepthFor(path)) == Integer.MAX_VALUE ? 0 : 1), hashSet3);
        if (hashSet2.add(path)) {
            this.maybeRunCallback(consumer, new DirectoryWatcher.Event(path, kind));
            for (QuickFile quickFile : hashSet3) {
                if (quickFile.isDirectory() && hashSet.add(quickFile)) {
                    this.processPath(consumer, quickFile.toPath(), DirectoryWatcher.Event.Create, hashSet, hashSet2);
                    continue;
                }
                if (!hashSet2.add(quickFile.toPath())) continue;
                this.maybeRunCallback(consumer, new DirectoryWatcher.Event(quickFile.toPath(), DirectoryWatcher.Event.Create));
            }
        }
    }

    protected void handleEvent(Consumer<DirectoryWatcher.Event> consumer, Path path, DirectoryWatcher.Event.Kind kind) {
        Directory<WatchedDirectory> directory;
        if (!Files.exists(path, new LinkOption[0]) && (directory = this.rootDirectories.get(path.getRoot())) != null) {
            Iterator<Directory.Entry<WatchedDirectory>> iterator = directory.remove(path).iterator();
            while (iterator.hasNext()) {
                WatchedDirectory watchedDirectory = iterator.next().getValue();
                if (watchedDirectory == null) continue;
                watchedDirectory.close();
            }
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            this.processPath(consumer, path, kind, new HashSet<QuickFile>(), new HashSet<Path>());
        } else {
            this.maybeRunCallback(consumer, new DirectoryWatcher.Event(path, kind));
        }
    }

    protected void handleOverflow(final Consumer<DirectoryWatcher.Event> consumer, final Path path) {
        int n = this.directoryRegistry.maxDepthFor(path);
        boolean bl = false;
        while (!bl && n > 0) {
            try {
                boolean bl2 = false;
                HashSet<QuickFile> hashSet = new HashSet<QuickFile>();
                Iterator iterator = this.directoryRegistry.registeredDirectories().iterator();
                while (iterator.hasNext()) {
                    hashSet.add(new QuickFileImpl(((Path)iterator.next()).toString(), 1));
                }
                this.maybePoll(path, hashSet);
                for (final QuickFile quickFile : hashSet) {
                    if (!quickFile.isDirectory()) continue;
                    boolean bl3 = this.registerImpl(quickFile.toPath(), n == Integer.MAX_VALUE ? Integer.MAX_VALUE : n - 1);
                    boolean bl4 = bl2 = bl2 || bl3;
                    if (!bl3) continue;
                    this.callbackExecutor.run(new Runnable(){

                        @Override
                        public void run() {
                            consumer.accept(new DirectoryWatcher.Event(quickFile.toPath(), DirectoryWatcher.Event.Create));
                        }
                    });
                }
                bl = !bl2;
            }
            catch (NoSuchFileException noSuchFileException) {
                bl = false;
            }
            catch (IOException iOException) {
                bl = true;
            }
        }
        this.callbackExecutor.run(new Runnable(){

            @Override
            public void run() {
                consumer.accept(new DirectoryWatcher.Event(path, DirectoryWatcher.Event.Overflow));
            }
        });
    }

    private void maybePoll(Path path, Set<QuickFile> set) throws IOException {
        if (this.pollNewDirectories) {
            boolean bl;
            do {
                bl = false;
                Iterator<QuickFile> iterator = QuickList.list(path, 0, false, (Filter<? super QuickFile>)new Filter<QuickFile>(){

                    @Override
                    public boolean accept(QuickFile quickFile) {
                        return !quickFile.isDirectory() || NioDirectoryWatcher.this.directoryRegistry.accept(quickFile.toPath());
                    }
                }).iterator();
                while (iterator.hasNext()) {
                    bl = set.add(iterator.next()) || bl;
                }
            } while (!Thread.currentThread().isInterrupted() && bl);
        }
    }

    private boolean add(Path path, int n, Set<QuickFile> set) {
        boolean bl = true;
        try {
            Directory<WatchedDirectory> directory;
            if (this.directoryRegistry.maxDepthFor(path) >= 0 && (directory = this.getRoot(path.getRoot())) != null) {
                this.update(directory, path);
            }
            this.maybePoll(path, set);
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    private void update(Directory<WatchedDirectory> directory, Path path) throws IOException {
        directory.update(path, 1).observe(this.updateObserver);
    }

    private boolean registerImpl(Path path, int n) throws IOException {
        Path path2;
        int n2 = this.directoryRegistry.maxDepthFor(path);
        boolean bl = n2 < n;
        try {
            path2 = path.toRealPath(new LinkOption[0]);
        }
        catch (IOException iOException) {
            path2 = path;
        }
        if (bl) {
            this.directoryRegistry.addDirectory(path, n);
        } else if (!path.equals(path2)) {
            throw new FileSystemLoopException(path.toString());
        }
        if (bl) {
            Path path3;
            Directory<WatchedDirectory> directory = this.getRoot(path2.getRoot());
            for (path3 = path; path3 != null && !Files.isDirectory(path3, new LinkOption[0]); path3 = path3.getParent()) {
            }
            if (directory != null && path3 != null) {
                this.update(directory, path3);
            }
        }
        return bl;
    }
}

