/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.data.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.metadata.data.statement.RGBPaletteEntry;
import com.webauthn4j.util.CollectionUtil;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayPNGCharacteristicsDescriptor {
    @NotNull
    private final BigInteger width;
    @NotNull
    private final BigInteger height;
    @NotNull
    private final Short bitDepth;
    @NotNull
    private final Short colorType;
    @NotNull
    private final Short compression;
    @NotNull
    private final Short filter;
    @NotNull
    private final Short interlace;
    @Nullable
    private final List<RGBPaletteEntry> plte;

    @JsonCreator
    public DisplayPNGCharacteristicsDescriptor(@JsonProperty(value="width") @NotNull BigInteger width, @JsonProperty(value="height") @NotNull BigInteger height, @JsonProperty(value="bitDepth") @NotNull Short bitDepth, @JsonProperty(value="colorType") @NotNull Short colorType, @JsonProperty(value="compression") @NotNull Short compression, @JsonProperty(value="filter") @NotNull Short filter, @JsonProperty(value="interlace") @NotNull Short interlace, @JsonProperty(value="plte") @Nullable List<RGBPaletteEntry> plte) {
        this.width = width;
        this.height = height;
        this.bitDepth = bitDepth;
        this.colorType = colorType;
        this.compression = compression;
        this.filter = filter;
        this.interlace = interlace;
        this.plte = CollectionUtil.unmodifiableList(plte);
    }

    @NotNull
    public BigInteger getWidth() {
        return this.width;
    }

    @NotNull
    public BigInteger getHeight() {
        return this.height;
    }

    @NotNull
    public Short getBitDepth() {
        return this.bitDepth;
    }

    @NotNull
    public Short getColorType() {
        return this.colorType;
    }

    @NotNull
    public Short getCompression() {
        return this.compression;
    }

    @NotNull
    public Short getFilter() {
        return this.filter;
    }

    @NotNull
    public Short getInterlace() {
        return this.interlace;
    }

    @Nullable
    public List<RGBPaletteEntry> getPlte() {
        return this.plte;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisplayPNGCharacteristicsDescriptor that = (DisplayPNGCharacteristicsDescriptor)o;
        return Objects.equals(this.width, that.width) && Objects.equals(this.height, that.height) && Objects.equals(this.bitDepth, that.bitDepth) && Objects.equals(this.colorType, that.colorType) && Objects.equals(this.compression, that.compression) && Objects.equals(this.filter, that.filter) && Objects.equals(this.interlace, that.interlace) && Objects.equals(this.plte, that.plte);
    }

    public int hashCode() {
        return Objects.hash(this.width, this.height, this.bitDepth, this.colorType, this.compression, this.filter, this.interlace, this.plte);
    }
}

