/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.bm;

import cz.xtf.core.bm.ManagedBuild;
import cz.xtf.core.config.WaitingConfig;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.waiting.SimpleWaiter;
import cz.xtf.core.waiting.Waiter;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.client.GracePeriodConfigurable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigSpecBuilder;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BinaryBuild
implements ManagedBuild {
    private static final Logger log = LoggerFactory.getLogger(BinaryBuild.class);
    private static final String CONTENT_HASH_LABEL_KEY = "xtf.bm/content-hash";
    private final String id;
    private final Path path;
    private final String builderImage;
    private final Map<String, String> envProperties;
    protected final ImageStream is;
    protected final BuildConfig bc;
    protected String contentHash = null;

    public BinaryBuild(String builderImage, Path path, Map<String, String> envProperties, String id) {
        this.builderImage = builderImage;
        this.path = path;
        this.envProperties = envProperties;
        this.id = id;
        this.is = this.createIsDefinition();
        this.bc = this.createBcDefinition();
    }

    @Override
    public void update(OpenShift openShift) {
        this.delete(openShift);
        this.build(openShift);
    }

    @Override
    public void delete(OpenShift openShift) {
        ((GracePeriodConfigurable)((Resource)openShift.imageStreams().withName(this.is.getMetadata().getName())).withPropagationPolicy(DeletionPropagation.BACKGROUND)).delete();
        ((GracePeriodConfigurable)((BuildConfigResource)openShift.buildConfigs().withName(this.bc.getMetadata().getName())).withPropagationPolicy(DeletionPropagation.BACKGROUND)).delete();
        String podName = this.bc.getMetadata().getName() + "-1-build";
        ((GracePeriodConfigurable)((PodResource)openShift.pods().withName(podName)).withPropagationPolicy(DeletionPropagation.BACKGROUND)).delete();
        new SimpleWaiter(() -> openShift.getImageStream(this.is.getMetadata().getName()) == null, TimeUnit.MILLISECONDS, WaitingConfig.timeout(), "Waiting for old imageStreams deletion").waitFor();
        new SimpleWaiter(() -> openShift.getBuildConfig(this.bc.getMetadata().getName()) == null, TimeUnit.MILLISECONDS, WaitingConfig.timeout(), "Waiting for old buildConfigs deletion").waitFor();
        new SimpleWaiter(() -> openShift.getPods().stream().noneMatch(p -> podName.equals(p.getMetadata().getName())), TimeUnit.MILLISECONDS, WaitingConfig.timeout(), "Waiting for old pods deletion").waitFor();
    }

    @Override
    public boolean isPresent(OpenShift openShift) {
        boolean isPresence = ((Resource)openShift.imageStreams().withName(this.id)).get() != null;
        boolean bcPresence = ((BuildConfigResource)openShift.buildConfigs().withName(this.id)).get() != null;
        return isPresence || bcPresence;
    }

    protected abstract List<EnvVar> getEnv(BuildConfig var1);

    protected abstract void configureBuildStrategy(BuildConfigSpecBuilder var1, String var2, List<EnvVar> var3);

    protected abstract String getImage(BuildConfig var1);

    protected abstract String getContentHash();

    protected boolean isCached() {
        return true;
    }

    @Override
    public boolean needsUpdate(OpenShift openShift) {
        ImageStream activeIs;
        BuildConfig activeBc = (BuildConfig)((BuildConfigResource)openShift.buildConfigs().withName(this.id)).get();
        boolean needsUpdate = activeBc == null | (activeIs = (ImageStream)((Resource)openShift.imageStreams().withName(this.id)).get()) == null;
        if (!needsUpdate) {
            String activeBuilderImage = this.getImage(activeBc);
            needsUpdate = !this.builderImage.equals(activeBuilderImage);
            log.debug("Builder image differs? {} != {} ? {} ", new Object[]{this.builderImage, activeBuilderImage, needsUpdate});
        }
        if (!needsUpdate) {
            String activeContentHash = (String)activeBc.getMetadata().getLabels().get(CONTENT_HASH_LABEL_KEY);
            needsUpdate = !this.getContentHash().equals(activeContentHash);
            log.debug("Content hash differs? {}", (Object)needsUpdate);
        }
        if (!needsUpdate) {
            int thisCount = this.envProperties != null ? this.envProperties.size() : 0;
            List<EnvVar> activeBcEnv = this.getEnv(activeBc);
            int themCount = activeBcEnv != null ? activeBcEnv.size() : 0;
            needsUpdate = thisCount != themCount;
            log.debug("env count differs? {} != {} ? {}", new Object[]{thisCount, themCount, needsUpdate});
            if (thisCount == themCount && thisCount > 0) {
                for (EnvVar envVar : activeBcEnv) {
                    if (envVar.getValue() == null) {
                        if (this.envProperties.get(envVar.getName()) == null) continue;
                        needsUpdate = true;
                        log.debug("env {} null in BC, but not in envProperties", (Object)envVar.getValue());
                        break;
                    }
                    if (envVar.getValue().equals(this.envProperties.get(envVar.getName()))) continue;
                    needsUpdate = true;
                    log.debug("env {}={} in BC, but {} in envProperties", new Object[]{envVar.getName(), envVar.getValue(), this.envProperties.get(envVar.getName())});
                    break;
                }
            }
            log.debug("Build strategy differs? {}", (Object)needsUpdate);
        }
        if (!needsUpdate) {
            if (activeBc.getStatus() == null || activeBc.getStatus().getLastVersion() == null) {
                log.debug("No build last version");
                needsUpdate = true;
            } else {
                Build activeBuild = openShift.getBuild(this.id + "-" + activeBc.getStatus().getLastVersion());
                if (activeBuild == null || activeBuild.getStatus() == null || "Failed".equals(activeBuild.getStatus().getPhase())) {
                    log.debug("Build failed");
                    needsUpdate = true;
                }
            }
        }
        return needsUpdate;
    }

    @Override
    public Waiter hasCompleted(OpenShift openShift) {
        return openShift.waiters().hasBuildCompleted(this.id);
    }

    private ImageStream createIsDefinition() {
        ObjectMeta metadata = ((ObjectMetaBuilder)new ObjectMetaBuilder().withName(this.id)).build();
        return ((ImageStreamBuilder)new ImageStreamBuilder().withMetadata(metadata)).build();
    }

    private BuildConfig createBcDefinition() {
        LinkedList<EnvVar> envVarList = new LinkedList<EnvVar>();
        if (this.envProperties != null) {
            for (Map.Entry<String, String> env : this.envProperties.entrySet()) {
                envVarList.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName(env.getKey())).withValue(env.getValue())).build());
            }
        }
        ObjectMeta metadata = ((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName(this.id)).withLabels(Collections.singletonMap(CONTENT_HASH_LABEL_KEY, this.getContentHash()))).build();
        BuildConfigSpecBuilder bcBuilder = new BuildConfigSpecBuilder();
        ((BuildConfigSpecFluent.SourceNested)((BuildConfigSpecBuilder)((BuildConfigSpecFluent.OutputNested)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)bcBuilder.withNewOutput().withNewTo().withKind("ImageStreamTag")).withName(this.id + ":latest")).endTo()).endOutput()).withNewSource().withType("Binary")).endSource();
        this.configureBuildStrategy(bcBuilder, this.builderImage, envVarList);
        return ((BuildConfigBuilder)((BuildConfigBuilder)new BuildConfigBuilder().withMetadata(metadata)).withSpec(bcBuilder.build())).build();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Path getPath() {
        return this.path;
    }
}

